/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionManager;
import Reika.DragonAPI.Instantiable.Math.Noise.SimplexNoiseGenerator;
import Reika.DragonAPI.Interfaces.CustomMapColorBiome;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import java.awt.Color;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class ChromaDimensionBiome
extends BiomeGenBase
implements CustomMapColorBiome {
    public final ChromaDimensionManager.Biomes biomeType;
    protected final SimplexNoiseGenerator grassColor;

    public ChromaDimensionBiome(int id, String n, ChromaDimensionManager.Biomes t) {
        super(id);
        this.func_76735_a(n);
        this.func_76733_a(5159473);
        this.func_76745_m();
        this.biomeType = t;
        this.grassColor = new SimplexNoiseGenerator(System.currentTimeMillis());
        this.field_76761_J.clear();
        this.field_76762_K.clear();
        this.field_82914_M.clear();
        this.field_76755_L.clear();
        this.initSpawnRules();
    }

    protected void initSpawnRules() {
    }

    public final int getMapColor(World world, int x, int z) {
        int color;
        int n = color = this.biomeType != null ? 0xFF000000 | Color.HSBtoRGB((float)this.biomeType.ordinal() / (float)ChromaDimensionManager.Biomes.biomeList.length, 1.0f, 1.0f) : -1;
        if (this.getExactType() instanceof ChromaDimensionManager.SubBiomes) {
            color = ReikaColorAPI.getColorWithBrightnessMultiplier((int)color, (float)0.67f);
        }
        if (this.getExactType() == ChromaDimensionManager.Biomes.STRUCTURE) {
            color = 0x606060;
        }
        return color;
    }

    public int func_150558_b(int x, int y, int z) {
        int c = ChromatiCraft.rainbowforest.func_150558_b(x, y, z);
        double rx = (double)x / 8.0;
        double rz = (double)z / 8.0;
        float f = (float)ReikaMathLibrary.normalizeToBounds((double)this.grassColor.getValue(rx, rz), (double)1.0, (double)1.5);
        return ReikaColorAPI.multiplyChannels((int)c, (float)1.0f, (float)f, (float)1.0f);
    }

    public int getWaterColorMultiplier() {
        return ChromatiCraft.rainbowforest.getWaterColorMultiplier();
    }

    public ChromaDimensionManager.ChromaDimensionBiomeType getExactType() {
        return this.biomeType;
    }

    public static abstract class ChromaDimensionSubBiome
    extends ChromaDimensionBiome {
        public final ChromaDimensionManager.SubBiomes subType;

        public ChromaDimensionSubBiome(int id, String n, ChromaDimensionManager.SubBiomes t) {
            super(id, n, t.getParent());
            this.subType = t;
        }

        @Override
        public ChromaDimensionManager.ChromaDimensionBiomeType getExactType() {
            return this.subType;
        }
    }
}

