/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base;

import Reika.ChromatiCraft.API.Interfaces.CrystalEffectBoostArmor;
import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Auxiliary.Interfaces.CrystalRenderedBlock;
import Reika.ChromatiCraft.Base.CrystalTypeBlock;
import Reika.ChromatiCraft.Magic.CrystalPotionController;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCCFloatingSeedsFX;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Interfaces.Block.SemiUnbreakable;
import Reika.DragonAPI.Interfaces.Block.Submergeable;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.crafting.IInfusionStabiliser;

@APIStripper.Strippable(value={"thaumcraft.api.crafting.IInfusionStabiliser"})
public abstract class CrystalBlock
extends CrystalTypeBlock
implements CrystalRenderedBlock,
IInfusionStabiliser,
SemiUnbreakable,
Submergeable {
    protected final IIcon[] icons = new IIcon[CrystalElement.elements.length];
    protected static final Random rand = new Random();

    public CrystalBlock(Material mat) {
        super(mat);
        this.func_149711_c(1.0f);
        this.func_149752_b(2.0f);
    }

    public final float getEnchantPowerBonus(World world, int x, int y, int z) {
        return this != ChromaBlocks.LAMP.getBlockInstance() && world.func_72805_g(x, y, z) == CrystalElement.PURPLE.ordinal() ? (this == ChromaBlocks.SUPER.getBlockInstance() ? 1.5f : 1.0f) : 0.0f;
    }

    public float func_149737_a(EntityPlayer ep, World world, int x, int y, int z) {
        return this.isUnbreakable(world, x, y, z, world.func_72805_g(x, y, z)) ? -1.0f : super.func_149737_a(ep, world, x, y, z);
    }

    public boolean isUnbreakable(World world, int x, int y, int z, int meta) {
        return false;
    }

    public final void func_149695_a(World world, int x, int y, int z, Block b) {
        if (world.func_72864_z(x, y, z)) {
            CrystalElement e = CrystalElement.elements[world.func_72805_g(x, y, z)];
            CrystalBlock.ding(world, x, y, z, e, (float)CrystalBlock.getDingPitchFromRedstone(e, world.func_94577_B(x, y, z)));
        }
    }

    private static double getDingPitchFromRedstone(CrystalElement e, int power) {
        if (power >= 12) {
            return CrystalMusicManager.instance.getOctave(e);
        }
        if (power >= 8) {
            return CrystalMusicManager.instance.getFifth(e);
        }
        if (power >= 4) {
            return CrystalMusicManager.instance.getThird(e);
        }
        return CrystalMusicManager.instance.getDingPitchScale(e);
    }

    @SideOnly(value=Side.CLIENT)
    public final IIcon func_149691_a(int s, int meta) {
        return this.icons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149651_a(IIconRegister ico) {
        for (int i = 0; i < ReikaDyeHelper.dyes.length; ++i) {
            this.icons[i] = ico.func_94245_a("ChromatiCraft:crystal/crystal_outline");
        }
    }

    public final int func_149645_b() {
        return ChromaISBRH.crystal.getRenderID();
    }

    public final boolean func_149662_c() {
        return false;
    }

    public final boolean func_149686_d() {
        return false;
    }

    public final int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        ChromaISBRH.crystal.setRenderPass(pass);
        return pass <= 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        CrystalElement e = this.getCrystalElement((IBlockAccess)world, x, y, z);
        this.doParticles(world, x, y, z, e, rand);
        if (this.shouldGiveEffects(e) && this.performEffect(e) && rand.nextInt(3) == 0) {
            ReikaPacketHelper.sendUpdatePacket((String)"ChromaData", (int)ChromaPackets.CRYSTALEFFECT.ordinal(), (int)x, (int)y, (int)z, (PacketTarget)PacketTarget.server);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        int x = target.field_72311_b;
        int y = target.field_72312_c;
        int z = target.field_72309_d;
        CrystalElement e = this.getCrystalElement((IBlockAccess)world, x, y, z);
        this.doParticles(world, x, y, z, e, rand);
        if (this.shouldGiveEffects(e) && this.performEffect(e) && e != CrystalElement.PURPLE && e != CrystalElement.BROWN) {
            ReikaPacketHelper.sendUpdatePacket((String)"ChromaData", (int)ChromaPackets.CRYSTALEFFECT.ordinal(), (int)x, (int)y, (int)z, (PacketTarget)PacketTarget.server);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z, CrystalElement e, Random rand) {
        if (rand.nextInt(20) > 0) {
            double rx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.5);
            double rz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.5);
            double ry = ReikaRandomHelper.getRandomPlusMinus((double)((double)y + 0.5 + 0.125), (double)0.5);
            float s = 1.0f + rand.nextFloat() * 1.5f;
            int l = 5 + rand.nextInt(60);
            int n = 3 + rand.nextInt(6);
            float f = s / 16.0f;
            float s2 = s / 4.0f;
            for (int i = 0; i < n; ++i) {
                double rrx = ReikaRandomHelper.getRandomPlusMinus((double)rx, (double)f);
                double rry = ReikaRandomHelper.getRandomPlusMinus((double)ry, (double)f);
                double rrz = ReikaRandomHelper.getRandomPlusMinus((double)rz, (double)f);
                EntityBlurFX fx = new EntityCCBlurFX(e, world, rrx, rry, rrz, 0.0, 0.0, 0.0).setIcon(ChromaIcons.SPARKLEPARTICLE).setLife(l).setScale(s2).enableAlphaTest();
                if (rand.nextBoolean()) {
                    fx.setRapidExpand();
                }
                if (rand.nextBoolean()) {
                    fx.setBasicBlend();
                }
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        } else {
            double rx = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.35);
            double rz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.35);
            EntityBlurFX fx = new EntityCCFloatingSeedsFX(world, rx, (double)y + 0.5, rz, 0.0, 90.0, ChromaIcons.CENTER).setColor(e.getColor()).setScale(4.0f).setLife(120).setColliding();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public final void updateEffects(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            CrystalElement color = CrystalElement.elements[world.func_72805_g(x, y, z)];
            if (this.shouldMakeNoise()) {
                float f1 = rand.nextFloat();
                float f2 = rand.nextFloat();
                float f3 = 0.5f * ((f1 - f2) * 0.7f + 1.8f);
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.orb", 0.05f, f3);
            }
            int r = this.getRange();
            AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z).func_72314_b((double)r, (double)r, (double)r);
            List inbox = world.func_72872_a(EntityLivingBase.class, box);
            Collections.shuffle(inbox);
            this.applyEffect(color, inbox, x, y, z, r);
        }
    }

    public final void applyEffect(CrystalElement color, List<EntityLivingBase> li, int x, int y, int z, int r) {
        int level = this.getPotionLevel(color);
        int dura = this.getDuration(color);
        boolean boost = level > 0;
        boolean player = false;
        for (EntityLivingBase e : li) {
            if (e instanceof EntityPlayer) {
                if (player) continue;
                player = true;
            }
            if (!(ReikaMathLibrary.py3d((double)(e.field_70165_t - (double)x - 0.5), (double)(e.field_70163_u + (double)(e.func_70047_e() / 2.0f) - (double)y - 0.5), (double)(e.field_70161_v - (double)z - 0.5)) <= (double)r)) continue;
            int dura2 = dura;
            int level2 = level;
            float slug = this.getSlugPower(e);
            if (slug > 0.0f) {
                dura2 = (int)((double)dura2 * (1.0 - 0.2 * (double)slug));
                level2 = (int)((float)level2 + slug);
            }
            CrystalPotionController.instance.applyEffectFromColor(dura2, level2, e, color, true);
        }
    }

    private float getSlugPower(EntityLivingBase e) {
        float ret = 0.0f;
        for (int i = 1; i < 4; ++i) {
            ItemStack is = e.func_71124_b(i);
            if (is == null || !(is.func_77973_b() instanceof CrystalEffectBoostArmor)) continue;
            ret += ((CrystalEffectBoostArmor)is.func_77973_b()).getPower(is);
        }
        return ret;
    }

    public abstract boolean shouldMakeNoise();

    public abstract boolean shouldGiveEffects(CrystalElement var1);

    public abstract boolean performEffect(CrystalElement var1);

    public abstract int getRange();

    public abstract int getDuration(CrystalElement var1);

    @Override
    public boolean renderAllArms() {
        return this.renderBase();
    }

    public abstract int getPotionLevel(CrystalElement var1);

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity e) {
        return false;
    }

    @Override
    public final int getTintColor(int meta) {
        int c0 = ReikaColorAPI.getModifiedSat((int)CrystalElement.elements[meta].getColor(), (float)0.65f);
        int c1 = ReikaDyeHelper.dyes[meta].color;
        return ReikaColorAPI.mixColors((int)c0, (int)c1, (float)0.65f);
    }

    public final boolean canStabaliseInfusion(World world, int x, int y, int z) {
        return true;
    }

    public final boolean isSubmergeable(IBlockAccess iba, int x, int y, int z) {
        return true;
    }

    public final boolean renderLiquid(int meta) {
        return true;
    }
}

