/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base;

import Reika.ChromatiCraft.Base.DynamicStructurePiece;
import Reika.ChromatiCraft.Base.StructureData;
import Reika.ChromatiCraft.Base.TileEntity.StructureBlockTile;
import Reika.ChromatiCraft.Block.Dimension.Structure.BlockStructureDataStorage;
import Reika.ChromatiCraft.Block.Worldgen.BlockLootChest;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Progression.ChromaResearchManager;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityDimensionCore;
import Reika.ChromatiCraft.World.Dimension.Structure.AltarGenerator;
import Reika.ChromatiCraft.World.Dimension.Structure.AntFarmGenerator;
import Reika.ChromatiCraft.World.Dimension.Structure.BridgeGenerator;
import Reika.ChromatiCraft.World.Dimension.Structure.GOLGenerator;
import Reika.ChromatiCraft.World.Dimension.Structure.GravityPuzzleGenerator;
import Reika.ChromatiCraft.World.Dimension.Structure.LaserPuzzleGenerator;
import Reika.ChromatiCraft.World.Dimension.Structure.LightPanelGenerator;
import Reika.ChromatiCraft.World.Dimension.Structure.LocksGenerator;
import Reika.ChromatiCraft.World.Dimension.Structure.MusicPuzzleGenerator;
import Reika.ChromatiCraft.World.Dimension.Structure.NonEuclideanGenerator;
import Reika.ChromatiCraft.World.Dimension.Structure.PinballGenerator;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTapeGenerator;
import Reika.ChromatiCraft.World.Dimension.Structure.RayBlendGenerator;
import Reika.ChromatiCraft.World.Dimension.Structure.ShiftMazeGenerator;
import Reika.ChromatiCraft.World.Dimension.Structure.TessellationGenerator;
import Reika.ChromatiCraft.World.Dimension.Structure.ThreeDMazeGenerator;
import Reika.ChromatiCraft.World.Dimension.Structure.TracePuzzleGenerator;
import Reika.ChromatiCraft.World.Dimension.Structure.WaterPuzzleGenerator;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Collections.ChancedOutputList;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class DimensionStructureGenerator
implements ChunkSplicedGenerationCache.TileCallback {
    protected final ChunkSplicedGenerationCache world = new ChunkSplicedGenerationCache();
    private DimensionStructureType structureType;
    private int structureTypeIndex;
    private ChunkCoordIntPair genCore;
    private ChunkCoordIntPair center;
    private final HashSet<Coordinate> breakable = new HashSet();
    protected int posX;
    protected int posY;
    protected int posZ;
    protected int entryX;
    protected int entryZ;
    protected Coordinate coreLocation = null;
    private CrystalElement genColor;
    private final MultiMap<ChunkCoordIntPair, DynamicPieceLocation> dynamicParts = new MultiMap().setNullEmpty();
    public final UUID id = UUID.randomUUID();
    private boolean forcedOpen;

    protected DimensionStructureGenerator() {
    }

    public final int getPosX() {
        return this.posX;
    }

    public final int getPosY() {
        return this.posY;
    }

    public final int getPosZ() {
        return this.posZ;
    }

    public final Coordinate getPos() {
        return new Coordinate(this.posX, this.posY, this.posZ);
    }

    public final int getEntryPosX() {
        return this.entryX;
    }

    public final int getEntryPosZ() {
        return this.entryZ;
    }

    public void offsetEntry(int dx, int dz) {
        this.entryX += dx;
        this.entryZ += dz;
    }

    public final DimensionStructureType getType() {
        return this.structureType;
    }

    public int getGenerationIndex() {
        return this.structureTypeIndex;
    }

    protected final void addDynamicStructure(DynamicStructurePiece dsp, int x, int z) {
        this.dynamicParts.addValue((Object)new ChunkCoordIntPair(x >> 4, z >> 4), (Object)new DynamicPieceLocation(dsp, x, z));
    }

    protected abstract void calculate(int var1, int var2, Random var3);

    public final void startCalculate(CrystalElement e, int chunkX, int chunkZ, Random rand) {
        this.genColor = e;
        this.genCore = new ChunkCoordIntPair(chunkX >> 4, chunkZ >> 4);
        this.posX = chunkX;
        this.posZ = chunkZ;
        this.entryX = chunkX;
        this.entryZ = chunkZ;
        long time = System.currentTimeMillis();
        ChromatiCraft.logger.log((Object)("Calculating a " + e + " " + (Object)((Object)this.getType())));
        this.calculate(chunkX, chunkZ, rand);
        long dur = System.currentTimeMillis() - time;
        ChromatiCraft.logger.log((Object)("Done in " + dur + " ms"));
    }

    public final void generateChunk(World w, ChunkCoordIntPair cp) {
        this.world.generate(w, cp);
        Collection c = this.dynamicParts.get((Object)cp);
        if (c != null) {
            for (DynamicPieceLocation dsp : c) {
                int x = (cp.field_77276_a << 4) + dsp.relX;
                int z = (cp.field_77275_b << 4) + dsp.relZ;
                dsp.generator.generate(w, x, z);
            }
        }
    }

    public boolean isChunkGenerated(int x, int z) {
        return this.world.isChunkGenerated(x, z);
    }

    public final void generateAll(World w) {
        this.world.generateAll(w);
        for (ChunkCoordIntPair cp : this.dynamicParts.keySet()) {
            Collection c = this.dynamicParts.get((Object)cp);
            if (c == null) continue;
            for (DynamicPieceLocation dsp : c) {
                int x = (cp.field_77276_a << 4) + dsp.relX;
                int z = (cp.field_77275_b << 4) + dsp.relZ;
                dsp.generator.generate(w, x, z);
            }
        }
    }

    public Set<Coordinate> getBreakableSpots() {
        return Collections.unmodifiableSet(this.breakable);
    }

    public void addBreakable(int x, int y, int z) {
        this.breakable.add(new Coordinate(x, y, z));
    }

    public abstract StructureData createDataStorage();

    public final void clear() {
        this.world.clear();
        this.dynamicParts.clear();
        this.breakable.clear();
        this.center = null;
        this.coreLocation = null;
        this.clearCaches();
    }

    public final ChunkCoordIntPair getLocation() {
        return this.genCore;
    }

    public final ChunkCoordIntPair getCentralLocation() {
        if (this.center == null) {
            this.center = new ChunkCoordIntPair(this.genCore.field_77276_a + (this.getCenterXOffset() >> 4), this.genCore.field_77275_b + (this.getCenterZOffset() >> 4));
        }
        return this.center;
    }

    public final ChunkCoordIntPair getEntryLocation() {
        return new ChunkCoordIntPair(this.entryX >> 4, this.entryZ >> 4);
    }

    public final String getCentralBlockCoords() {
        ChunkCoordIntPair ctr = this.getCentralLocation();
        return String.format("%d, %d", ctr.field_77276_a * 16 + this.getCenterXOffset(), ctr.field_77275_b * 16 + this.getCenterZOffset());
    }

    protected abstract int getCenterXOffset();

    protected abstract int getCenterZOffset();

    protected abstract void clearCaches();

    public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
        if (te instanceof TileEntityDimensionCore) {
            StructurePair sp = new StructurePair(this, this.getCoreColor());
            sp.generatedDimension = world.field_73011_w.field_76574_g;
            ((TileEntityDimensionCore)te).setStructure(sp);
        } else {
            ChromatiCraft.logger.logError((Object)(te + " instead of a Dimension Core at " + x + ", " + y + ", " + z + "!!"));
        }
    }

    public CrystalElement getCoreColor() {
        return this.genColor;
    }

    public final void placeCore(int x, int y, int z) {
        this.world.setTileEntity(x, y, z, ChromaTiles.DIMENSIONCORE.getBlock(), ChromaTiles.DIMENSIONCORE.getBlockMetadata(), (ChunkSplicedGenerationCache.TileCallback)this);
        this.coreLocation = new Coordinate(x, y, z);
    }

    public boolean hasCore() {
        return this.coreLocation != null;
    }

    public boolean isComplete() {
        return this.hasCore();
    }

    public final boolean shouldAllowCoreMining(World world, EntityPlayer ep) {
        return this.forcedOpen || this.hasBeenSolved(world);
    }

    protected abstract boolean hasBeenSolved(World var1);

    public final void forceOpen(World world, EntityPlayer ep) {
        this.forcedOpen = true;
        this.openStructure(world);
        TileEntityDimensionCore te = this.getCoreTile(world);
        if (te != null) {
            te.whitelistPlayer(ep);
        }
    }

    public final TileEntityDimensionCore getCoreTile(World world) {
        return (TileEntityDimensionCore)this.coreLocation.getTileEntity((IBlockAccess)world);
    }

    public boolean forcedOpen() {
        return this.forcedOpen;
    }

    protected abstract void openStructure(World var1);

    public int getPassword(EntityPlayer ep) {
        return new StructureTypeData(this).getPassword(ep);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + " @ " + this.getCentralBlockCoords() + " (E = " + this.getEntryLocation() + ")";
    }

    public static void resetCachedGenerators() {
        DimensionStructureType.generatorTypes.clear();
        for (int i = 0; i < DimensionStructureType.types.length; ++i) {
            DimensionStructureType.types[i].generators.clear();
        }
    }

    public static DimensionStructureGenerator getGeneratorByID(UUID uid) {
        DimensionStructureType type = (DimensionStructureType)((Object)DimensionStructureType.generatorTypes.get(uid));
        return type != null ? (DimensionStructureGenerator)type.generators.get(uid) : null;
    }

    public final void generateDataTile(int x, int y, int z, Object ... data) {
        this.world.setTileEntity(x, y, z, ChromaBlocks.DIMDATA.getBlockInstance(), 0, (ChunkSplicedGenerationCache.TileCallback)new StructureInterfaceCallback(this, data));
    }

    public final void generatePasswordTile(World world, int x, int y, int z) {
        if (ChromaOptions.structureBypassEnabled()) {
            world.func_147465_d(x, y, z, ChromaBlocks.DIMDATA.getBlockInstance(), 1, 2);
            StructureInterfaceCallback sr = new StructureInterfaceCallback(this, null);
            sr.onTilePlaced(world, x, y, z, world.func_147438_o(x, y, z));
        }
    }

    public final void generatePasswordTile(int x, int y, int z) {
        if (ChromaOptions.structureBypassEnabled()) {
            this.world.setTileEntity(x, y, z, ChromaBlocks.DIMDATA.getBlockInstance(), 1, (ChunkSplicedGenerationCache.TileCallback)new StructureInterfaceCallback(this, null));
        }
    }

    public final void generateLootChest(int x, int y, int z, ForgeDirection dir, String chest, int bonus, Object ... extras) {
        this.world.setTileEntity(x, y, z, ChromaBlocks.LOOTCHEST.getBlockInstance(), BlockLootChest.getMeta(dir), (ChunkSplicedGenerationCache.TileCallback)new LootChestCallback(chest, bonus, extras));
    }

    public void tickPlayer(EntityPlayer ep) {
    }

    public void onBlockUpdate(World world, int x, int y, int z, Block b) {
    }

    public void updateTick(World world) {
    }

    public static final class LootChestCallback
    implements ChunkSplicedGenerationCache.TileCallback {
        private final String chest;
        private final int bonus;
        private final ChancedOutputList extras;

        public LootChestCallback(String s, int b, Object ... ex) {
            this(s, b, ChancedOutputList.parseFromArray((boolean)false, (Object[])ex));
        }

        public LootChestCallback(String s, int b, ChancedOutputList ex) {
            this.chest = s;
            this.bonus = b;
            this.extras = ex;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            if (te instanceof BlockLootChest.TileEntityLootChest) {
                BlockLootChest.TileEntityLootChest tc = (BlockLootChest.TileEntityLootChest)te;
                tc.populateChest(this.chest, null, this.bonus, world.field_73012_v);
                ArrayList extra = this.extras.calculate();
                for (ItemStack is : extra) {
                    int slot = world.field_73012_v.nextInt(tc.func_70302_i_());
                    tc.func_70299_a(slot, is);
                }
            }
        }
    }

    public static final class UUIDPlace
    implements ChunkSplicedGenerationCache.TileCallback {
        private final UUID uid;

        public UUIDPlace(UUID id) {
            this.uid = id;
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            if (te instanceof StructureBlockTile) {
                ((StructureBlockTile)te).uid = this.uid;
            }
        }
    }

    private static final class StructureInterfaceCallback
    implements ChunkSplicedGenerationCache.TileCallback {
        private final DimensionStructureGenerator generator;
        private final HashMap<String, Object> data;

        private StructureInterfaceCallback(DimensionStructureGenerator gen, Object[] data) {
            this.generator = gen;
            HashMap hashMap = this.data = data != null ? new HashMap() : null;
            if (this.data != null) {
                for (int i = 0; i < data.length; i += 2) {
                    String s = (String)data[i];
                    this.data.put(s, data[i + 1]);
                }
            }
        }

        public void onTilePlaced(World world, int x, int y, int z, TileEntity te) {
            if (te instanceof BlockStructureDataStorage.StructureInterfaceTile) {
                ((BlockStructureDataStorage.StructureInterfaceTile)te).loadData(this.generator, this.data);
            }
        }
    }

    public static class DynamicPieceLocation {
        private final DynamicStructurePiece generator;
        private final int relX;
        private final int relZ;

        private DynamicPieceLocation(DynamicStructurePiece gen, int x, int z) {
            this.generator = gen;
            this.relX = ChunkSplicedGenerationCache.modAndAlign((int)x);
            this.relZ = ChunkSplicedGenerationCache.modAndAlign((int)z);
        }
    }

    public static enum DimensionStructureType {
        TDMAZE(ThreeDMazeGenerator.class, "Three-Dimensional Maze"),
        ALTAR(AltarGenerator.class, ""),
        SHIFTMAZE(ShiftMazeGenerator.class, "Shifting Maze"),
        LOCKS(LocksGenerator.class, "Locks and Keys"),
        MUSIC(MusicPuzzleGenerator.class, "Crystal Music"),
        NONEUCLID(NonEuclideanGenerator.class, "Complex Spaces"),
        GOL(GOLGenerator.class, "Cellular Automata"),
        ANTFARM(AntFarmGenerator.class, "Fading Light"),
        LASER(LaserPuzzleGenerator.class, "Chromatic Beams"),
        PINBALL(PinballGenerator.class, "Expanding Motion"),
        GRAVITY(GravityPuzzleGenerator.class, "Luma Bursts"),
        BRIDGE(BridgeGenerator.class, "Dynamic Bridges"),
        WATER(WaterPuzzleGenerator.class, "Channeled Flow"),
        TESSELLATION(TessellationGenerator.class, "Spatial Satisfaction"),
        LIGHTPANEL(LightPanelGenerator.class, "Glowing Logic"),
        PISTONTAPE(PistonTapeGenerator.class, "Filter Cycle"),
        RAYBLEND(RayBlendGenerator.class, "Crystal Interference"),
        TRACES(TracePuzzleGenerator.class, "Parallel Connections");

        private final Class generatorClass;
        private final String desc;
        private final boolean gennedCore;
        private static final String NBT_TAG = "structuresCompleted";
        public static final DimensionStructureType[] types;
        private final HashMap<UUID, DimensionStructureGenerator> generators = new HashMap();
        private static final HashMap<UUID, DimensionStructureType> generatorTypes;

        private DimensionStructureType(Class<? extends DimensionStructureGenerator> c, String s) {
            this.generatorClass = c;
            this.desc = s;
            DimensionStructureGenerator gen = this.createGenerator(false, -1);
            gen.startCalculate(CrystalElement.WHITE, 0, 0, new Random());
            this.gennedCore = gen.isComplete();
            gen.clear();
        }

        public DimensionStructureGenerator createGenerator(int idx) {
            return this.createGenerator(true, idx);
        }

        private DimensionStructureGenerator createGenerator(boolean doCache, int idx) {
            try {
                DimensionStructureGenerator generator = (DimensionStructureGenerator)this.generatorClass.newInstance();
                generator.structureType = this;
                generator.structureTypeIndex = idx;
                if (doCache) {
                    this.generators.put(generator.id, generator);
                    generatorTypes.put(generator.id, generator.getType());
                }
                return generator;
            }
            catch (Exception e) {
                throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Error creating a generator for structure type " + (Object)((Object)this));
            }
        }

        public void markPlayerCompleted(EntityPlayer ep) {
            NBTTagCompound tag = ChromaResearchManager.instance.getRootNBTTag(ep);
            NBTTagCompound dat = tag.func_74775_l(NBT_TAG);
            dat.func_74757_a("struct_" + this.ordinal(), true);
            tag.func_74782_a(NBT_TAG, (NBTBase)dat);
        }

        public boolean hasPlayerCompleted(EntityPlayer ep) {
            NBTTagCompound tag = ChromaResearchManager.instance.getRootNBTTag(ep);
            NBTTagCompound dat = tag.func_74775_l(NBT_TAG);
            return dat.func_74767_n("struct_" + this.ordinal());
        }

        public boolean isComplete() {
            return this.gennedCore;
        }

        public String getDisplayText() {
            return this.desc;
        }

        public DimensionStructureGenerator getGenerator(UUID uid) {
            return this.generators.get(uid);
        }

        public Collection<UUID> getUUIDs() {
            return Collections.unmodifiableCollection(this.generators.keySet());
        }

        public int getIconIndex() {
            return 8 + this.ordinal();
        }

        static {
            types = DimensionStructureType.values();
            generatorTypes = new HashMap();
        }
    }

    public static final class StructureTypeData {
        public final CrystalElement color;
        public final DimensionStructureType type;
        public final int generationIndex;

        public StructureTypeData(StructurePair p) {
            this(p.color, p.generator.getType(), p.generator.getGenerationIndex());
        }

        public StructureTypeData(DimensionStructureGenerator gen) {
            this(gen.genColor, gen.getType(), gen.getGenerationIndex());
        }

        public StructureTypeData(CrystalElement e, DimensionStructureType type, int idx) {
            this.color = e;
            this.type = type;
            this.generationIndex = idx;
        }

        public int getPassword(EntityPlayer ep) {
            int hash = (ep != null ? ep.func_110124_au() : DragonAPICore.Reika_UUID).toString().hashCode();
            hash ^= 3178531 * this.generationIndex;
            hash ^= 1780943 * this.type.ordinal();
            hash ^= 4702617 * ChromaOptions.getStructureDifficulty();
            return ReikaFileReader.HashType.SHA1.hash((Object)(hash ^= 3689507 * "1.7.10".hashCode())).hashCode();
        }
    }

    public static final class StructurePair {
        public final DimensionStructureGenerator generator;
        public final CrystalElement color;
        public int generatedDimension = -2147483647;

        public StructurePair(DimensionStructureGenerator gen, CrystalElement e) {
            this.generator = gen;
            this.color = e;
        }

        public int hashCode() {
            return this.color.ordinal() << 8 | this.generator.getType().ordinal();
        }

        public boolean equals(Object o) {
            if (o instanceof StructurePair) {
                StructurePair p = (StructurePair)o;
                return p.color == this.color && p.generator == this.generator;
            }
            return false;
        }

        public String toString() {
            return this.color.name() + " " + this.generator;
        }
    }
}

