/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base;

import Reika.ChromatiCraft.Base.ColoredStructureBase;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Worldgen.ChunkSplicedGenerationCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class GeneratedStructureBase
extends ColoredStructureBase {
    private final HashMap<Coordinate, ChunkSplicedGenerationCache.TileCallback> callbacks = new HashMap();
    private final MultiMap<Block, Coordinate> cache = new MultiMap(MultiMap.CollectionType.HASHSET);
    private boolean isPopulatingForWorldgen = false;
    private final ArrayList<Exception> failures = new ArrayList();

    @Override
    public void resetToDefaults() {
        super.resetToDefaults();
        this.callbacks.clear();
        this.cache.clear();
        this.isPopulatingForWorldgen = false;
        this.failures.clear();
    }

    public final void markForWorldgen() {
        if (this.isDisplay()) {
            throw new IllegalStateException("The structure cannot be both display and worldgen!");
        }
        this.isPopulatingForWorldgen = true;
    }

    public final boolean isWorldgen() {
        return this.isPopulatingForWorldgen;
    }

    public final Collection<Exception> getErrors() {
        return Collections.unmodifiableCollection(this.failures);
    }

    public final void addError(Exception e) {
        this.failures.add(e);
    }

    protected final void addCallback(int x, int y, int z, ChunkSplicedGenerationCache.TileCallback c) {
        this.addCallback(new Coordinate(x, y, z), c);
    }

    protected final void addCallback(Coordinate c, ChunkSplicedGenerationCache.TileCallback cl) {
        if (this.isWorldgen() && (c.yCoord < 0 || c.yCoord > 255)) {
            this.failures.add(new Exception("Tried to place a tile out of world bounds"));
            return;
        }
        this.callbacks.put(c, cl);
    }

    protected final void cache(int x, int y, int z, Block b) {
        this.cache(new Coordinate(x, y, z), b);
    }

    protected final void cache(Coordinate c, Block b) {
        this.cache.addValue((Object)b, (Object)c);
    }

    public final void runCallbacks(World world, Random rand) {
        this.preCallbacks(world, rand);
        for (Map.Entry<Coordinate, ChunkSplicedGenerationCache.TileCallback> e : this.callbacks.entrySet()) {
            Coordinate c = e.getKey();
            try {
                e.getValue().onTilePlaced(world, c.xCoord, c.yCoord, c.zCoord, c.getTileEntity((IBlockAccess)world));
            }
            catch (Exception ex) {
                this.failures.add(new Exception("Threw exception running tile callback @ " + e, ex));
            }
        }
    }

    protected void preCallbacks(World world, Random rand) {
    }

    public abstract int getStructureVersion();

    public final Collection<Coordinate> getCachedBlocks(Block b) {
        return Collections.unmodifiableCollection(this.cache.get((Object)b));
    }

    public final void offset(int x, int y, int z, FilledBlockArray arr) {
        arr.offset(x, y, z);
        HashMap<Coordinate, ChunkSplicedGenerationCache.TileCallback> map = new HashMap<Coordinate, ChunkSplicedGenerationCache.TileCallback>(this.callbacks);
        this.callbacks.clear();
        for (Map.Entry<Coordinate, ChunkSplicedGenerationCache.TileCallback> e : map.entrySet()) {
            this.callbacks.put(e.getKey().offset(x, y, z), e.getValue());
        }
        for (Block b : this.cache.keySet()) {
            Collection li = this.cache.get((Object)b);
            ArrayList li2 = new ArrayList(li);
            li.clear();
            for (Coordinate c : li2) {
                li.add(c.offset(x, y, z));
            }
        }
    }
}

