/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base;

import Reika.ChromatiCraft.Auxiliary.ChromaDescriptions;
import Reika.ChromatiCraft.Auxiliary.Render.ChromaFontRenderer;
import Reika.ChromatiCraft.Base.GuiScrollingPage;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Progression.ChromaResearchManager;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ProgressionManager;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.GUI.CustomSoundGuiButton;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Point;
import org.lwjgl.util.Rectangle;

public abstract class GuiProgressStages
extends GuiScrollingPage {
    private int randomIndex;
    private int clearLength;
    private ProgressStage active;
    protected int elementWidth = 0;
    protected int elementHeight = 20;
    protected static final int spacingX = 30;
    protected static final int spacingY = 15;
    private final EnumMap<ProgressStage, Point> renderPositions = new EnumMap(ProgressStage.class);
    private final EnumMap<ProgressStage, Rectangle> locations = new EnumMap(ProgressStage.class);

    public GuiProgressStages(ChromaGuis g, EntityPlayer ep) {
        super(g, ep, 256, 220, 242, 112);
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment()) {
            ChromaDescriptions.reload();
        }
    }

    protected final void initMap() {
        HashMap<Integer, Integer> offsets = new HashMap<Integer, Integer>();
        for (ProgressionManager.ProgressLink p : this.getProgress()) {
            int depth = this.getDepth(p);
            int d = offsets.containsKey(depth) ? (Integer)offsets.get(depth) : 0;
            int dx = d * (this.elementWidth + 30);
            int dy = depth * (this.elementHeight + 15);
            offsets.put(depth, d + 1);
            this.renderPositions.put(p.parent, new Point(dx, dy));
            this.elementWidth = 20;
            this.maxX = Math.max(this.maxX, dx + this.elementWidth);
            this.maxY = Math.max(this.maxY, dy + this.elementHeight);
        }
        this.maxX -= this.paneWidth - 15;
        this.maxY -= this.paneHeight - 15 - 30;
        if (this.maxX < 0) {
            this.maxX = 0;
        }
    }

    protected abstract int getDepth(ProgressionManager.ProgressLink var1);

    protected abstract Collection<ProgressionManager.ProgressLink> getProgress();

    protected final ProgressStage getActive() {
        return this.active;
    }

    protected final Point getRenderPosition(ProgressStage p) {
        return this.renderPositions.get(p);
    }

    @Override
    public final void func_73866_w_() {
        super.func_73866_w_();
        int j = (this.field_146294_l - this.xSize) / 2;
        int k = (this.field_146295_m - this.ySize) / 2;
        String file = "Textures/GUIs/Handbook/buttons.png";
        this.addAuxButton((GuiButton)new CustomSoundGuiButton.CustomSoundImagedGuiButton(10, j + this.xSize, k, 22, 39, 42, 126, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this), "Return");
        this.addAuxButton((GuiButton)new CustomSoundGuiButton.CustomSoundImagedGuiButton(20, j - 13, k - 7, 13, 35, 15, 185, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this), "Tree");
        this.addAuxButton((GuiButton)new CustomSoundGuiButton.CustomSoundImagedGuiButton(21, j - 13, k + 27, 13, 35, 15, 185, file, ChromatiCraft.class, (CustomSoundGuiButton.CustomSoundGui)this), "Levels");
    }

    @Override
    protected final void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 10) {
            this.goTo(ChromaGuis.BOOKNAV, null);
            this.resetOffset();
        } else if (button.field_146127_k >= 20) {
            ChromaGuis c = null;
            switch (button.field_146127_k) {
                case 20: {
                    c = ChromaGuis.PROGRESS;
                    break;
                }
                case 21: {
                    c = ChromaGuis.PROGRESSBYTIER;
                }
            }
            if (c != null && c != this.guiType) {
                this.goTo(c, null);
                this.resetOffset();
            }
        }
        this.func_73866_w_();
    }

    @Override
    public void func_73863_a(int x, int y, float f) {
        super.func_73863_a(x, y, f);
        this.locations.clear();
    }

    protected final void renderElements(int posX, int posY) {
        for (ProgressionManager.ProgressLink p : this.getProgress()) {
            int y;
            Point pt;
            int x;
            if (!this.elementOnScreen(p, posX, posY, x = -offsetX + posX + 12 + (pt = this.renderPositions.get(p.parent)).getX(), y = -offsetY + posY + 36 + pt.getY())) continue;
            this.renderElement(p, x, y);
        }
    }

    private boolean elementOnScreen(ProgressionManager.ProgressLink p, int posX, int posY, int x, int y) {
        return x >= posX + 8 && x <= posX + this.xSize - this.elementWidth - 8 && y >= posY + 24 + 1 && y - posY + this.elementHeight < this.ySize / 2 + 8;
    }

    private void renderElement(ProgressionManager.ProgressLink pl, int x, int y) {
        Collection<ChromaResearch> li;
        ProgressStage p = pl.parent;
        int color = 0xFFFFFF;
        boolean see = GuiProgressStages.renderClearText(p, this.player);
        GuiProgressStages.func_73734_a((int)x, (int)y, (int)(x + this.elementWidth), (int)(y + this.elementHeight), (int)-12303292);
        Rectangle rect = new Rectangle(x, y, this.elementWidth, this.elementHeight);
        boolean hover = rect.contains(api.getMouseRealX(), api.getMouseRealY());
        boolean near = p.isOneStepAway(this.player);
        int border = see ? 0xFFFF00 : 0xFF0000;
        boolean has = p.isPlayerAtStage(this.player);
        if (has) {
            border = 65280;
        }
        double t = ((double)System.currentTimeMillis() / 5.0 + (double)(p.hashCode() * 23)) % 360.0;
        border = ReikaColorAPI.mixColors((int)border, (int)0xFFFFFF, (float)(0.5f + 0.25f * (float)Math.sin(Math.toRadians(t))));
        api.drawRectFrame(x, y, this.elementWidth, this.elementHeight, border);
        if (!has && !(li = ChromaResearchManager.instance.getMissingResearch(this.player, p)).isEmpty()) {
            GL11.glPushAttrib((int)1048575);
            ReikaTextureHelper.bindTerrainTexture();
            GL11.glEnable((int)3042);
            GL11.glDepthMask((boolean)false);
            float s = (float)(0.55 + 0.15 * Math.sin(Math.toRadians(-t)));
            GL11.glColor4f((float)s, (float)s, (float)s, (float)1.0f);
            GL11.glDisable((int)2896);
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
            api.func_94065_a(x - 10, y - 10, ChromaIcons.ECLIPSEFLARE.getIcon(), this.elementWidth + 20, this.elementHeight + 20);
            GL11.glPopAttrib();
        }
        if (this.guiType == ChromaGuis.PROGRESSBYTIER) {
            GL11.glPushAttrib((int)1048575);
            ReikaTextureHelper.bindTerrainTexture();
            GL11.glEnable((int)3042);
            GL11.glDepthMask((boolean)false);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
            Collection<ProgressStage> par = ProgressionManager.instance.getPrereqs(p);
            if (par.isEmpty()) {
                GL11.glColor4f((float)0.1f, (float)0.5f, (float)1.0f, (float)1.0f);
                for (int i = 0; i < 3; ++i) {
                    api.func_94065_a(x - i * 0, y - i * 0, ChromaIcons.RIFTHALO.getIcon(), this.elementWidth + i * 0, this.elementHeight + i * 0);
                }
            } else {
                int cl = 0xFF0000;
                if (has) {
                    cl = 65280;
                } else {
                    for (ProgressStage p2 : par) {
                        if (!p2.isPlayerAtStage(this.player)) continue;
                        cl = 0xFFFF00;
                        break;
                    }
                }
                float r = (float)ReikaColorAPI.getRed((int)cl) / 255.0f;
                float g = (float)ReikaColorAPI.getGreen((int)cl) / 255.0f;
                float b = (float)ReikaColorAPI.getBlue((int)cl) / 255.0f;
                GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
                api.func_94065_a(x - 10, y - 10, ChromaIcons.ROSEFLARE.getIcon(), this.elementWidth + 20, this.elementHeight + 20);
            }
            GL11.glPopAttrib();
        }
        if (see || near) {
            String s;
            String string = s = see ? p.getTitleString() : EnumChatFormatting.OBFUSCATED.toString() + p.getTitleString();
            if (!see) {
                color = 0xB5B5B5;
            }
            int dx = (this.elementWidth - this.field_146289_q.func_78256_a(s)) / 2;
            int n = (this.elementHeight - this.field_146289_q.field_78288_b) / 2;
        } else {
            color = 0x888888;
        }
        if (see) {
            if (has || p.alwaysRenderFullBright()) {
                p.renderIcon(field_146296_j, this.field_146289_q, x + 2, y + 2);
                if (hover) {
                    this.renderHoverOverlay(x, y, true);
                }
            } else {
                GL11.glPushAttrib((int)1048575);
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GuiProgressStages.field_146296_j.field_77024_a = false;
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2884);
                p.renderIcon(field_146296_j, this.field_146289_q, x + 2, y + 2);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopAttrib();
                if (hover) {
                    this.renderHoverOverlay(x, y, false);
                }
            }
        } else {
            GL11.glPushAttrib((int)1048575);
            ReikaTextureHelper.bindTerrainTexture();
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.INVERTEDADD.apply();
            api.func_94065_a(x + 2, y + 2, ChromaIcons.QUESTION.getIcon(), 16, 16);
            GL11.glPopAttrib();
        }
        this.locations.put(p, rect);
    }

    private void renderHoverOverlay(int x, int y, boolean has) {
        ReikaTextureHelper.bindTerrainTexture();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int d = 2;
        api.drawRectFrame(x + d, y + d, this.elementWidth - d * 2, this.elementHeight - d * 2, 0xFFFFFF);
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.DEFAULT.apply();
        int z = 500;
        ReikaGuiAPI.instance.setZLevel((float)(z + 250));
        IIcon ico = has ? ChromaIcons.CHECK.getIcon() : ChromaIcons.X.getIcon();
        api.func_94065_a(x + this.elementWidth / 2 - 2 + d, y + this.elementHeight / 2 - 2 + d, ico, (this.elementWidth - d * 2) / 2, (this.elementHeight - d * 2) / 2);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        Tessellator.field_78398_a.func_78382_b();
        int a = 96 + (int)(32.0 * Math.sin((double)System.currentTimeMillis() / 180.0));
        Tessellator.field_78398_a.func_78384_a(0xFFFFFF, a);
        Tessellator.field_78398_a.func_78377_a((double)(x + d), (double)(y + this.elementHeight - d), (double)z);
        Tessellator.field_78398_a.func_78377_a((double)(x + this.elementWidth - d), (double)(y + this.elementHeight - d), (double)z);
        Tessellator.field_78398_a.func_78377_a((double)(x + this.elementWidth - d), (double)(y + d), (double)z);
        Tessellator.field_78398_a.func_78377_a((double)(x + d), (double)(y + d), (double)z);
        Tessellator.field_78398_a.func_78381_a();
        GL11.glPopAttrib();
    }

    public static boolean renderClearText(ProgressStage p, EntityPlayer player) {
        return p.isPlayerAtStage(player) || p.playerHasPrerequisites(player);
    }

    protected final void renderText(int posX, int posY) {
        int c = 0xFFFFFF;
        int px = posX + 8;
        if (this.active != null) {
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            ProgressStage p = this.active;
            if (p.isOneStepAway(this.player) || p.playerHasPrerequisites(this.player)) {
                this.field_146289_q.func_78279_b(p.getTitleString(), px, posY + 88 + 36, 242, 0xFFFFFF);
            } else {
                ChromaFontRenderer.FontType.OBFUSCATED.renderer.func_78279_b(p.getTitleString(), px, posY + 88 + 36, 242, 0xFFFFFF);
            }
            if (GuiProgressStages.renderClearText(p, this.player)) {
                this.field_146289_q.func_78279_b(p.getHintString(), px, posY + 88 + 36 + 20, 242, 0xFFFFFF);
            } else {
                ChromaFontRenderer.FontType.OBFUSCATED.renderer.func_78279_b(p.getHintString(), px, posY + 88 + 36 + 20, 242, 0xFFFFFF);
            }
            int dy = posY + 88 + 100 + 15;
            if (p.isPlayerAtStage(this.player)) {
                String s = p.getRevealedString();
                this.field_146289_q.func_78279_b(s, px, dy -= this.field_146289_q.field_78288_b * this.field_146289_q.func_78256_a(s) / 242, 242, 0xFFFFFF);
            } else {
                ChromaFontRenderer.FontType.OBFUSCATED.renderer.func_78279_b(this.getIncompleteText(), px, dy, 242, 0xFFFFFF);
            }
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
        }
    }

    @Override
    protected final void func_73864_a(int x, int y, int b) {
        super.func_73864_a(x, y, b);
        ProgressStage p = this.getUnderMouse(x, y);
        if (p != null) {
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.GUICLICK, (Entity)this.player, (float)0.33f, (float)1.0f);
            ChromaFontRenderer.FontType.OBFUSCATED.renderer.rerandomize();
        }
        this.active = p;
    }

    private ProgressStage getUnderMouse(int x, int y) {
        for (ProgressStage p : this.locations.keySet()) {
            Rectangle r = this.locations.get(p);
            if (!r.contains(x, y)) continue;
            return p;
        }
        return null;
    }

    private String getIncompleteText() {
        return this.getIncompleteString();
    }

    private String getIncompleteString() {
        return "There is still much to learn...";
    }

    private void randomizeString() {
        String s = this.getIncompleteString();
        this.randomIndex = rand.nextInt(s.length());
        this.clearLength = Math.min(Math.max(4, rand.nextInt(s.length())), Math.min(rand.nextInt(3) == 0 ? 12 : 6, s.length() - this.randomIndex));
    }
}

