/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base;

import Reika.ChromatiCraft.Base.ItemChromaTool;
import Reika.ChromatiCraft.Magic.Interfaces.PoweredItem;
import Reika.ChromatiCraft.Magic.ToolChargingSystem;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;

public abstract class ItemPoweredChromaTool
extends ItemChromaTool
implements PoweredItem {
    public ItemPoweredChromaTool(int index) {
        super(index);
    }

    @Override
    public abstract CrystalElement getColor(ItemStack var1);

    @Override
    public abstract int getMaxCharge();

    @Override
    public abstract int getChargeStates();

    protected abstract boolean isActivated(EntityPlayer var1, ItemStack var2, boolean var3);

    @Override
    public abstract int getChargeConsumptionRate(EntityPlayer var1, World var2, ItemStack var3);

    protected abstract boolean doTick(ItemStack var1, World var2, EntityPlayer var3, boolean var4);

    @Override
    public float getPlayerChargeCoefficient(ItemStack is) {
        return 0.0f;
    }

    @Override
    public int getPlayerBufferExtractionRate(ItemStack is) {
        return 0;
    }

    @Override
    public int getChargeRate(ItemStack is, int base) {
        return base;
    }

    @Override
    public int getChargeState(float frac) {
        return Math.round((float)(this.getChargeStates() - 1) * frac);
    }

    public final void func_150895_a(Item i, CreativeTabs c, List li) {
        li.add(ToolChargingSystem.instance.getChargedItem(this, 0));
        li.add(ToolChargingSystem.instance.getChargedItem(this, this.getMaxCharge()));
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        li.add(String.format("Energy: %.2f%s", Float.valueOf(100.0f * (float)ToolChargingSystem.instance.getCharge(is) / (float)this.getMaxCharge()), "%"));
    }

    public final void func_77663_a(ItemStack is, World world, Entity e, int slot, boolean held) {
        if (e instanceof EntityPlayer) {
            EntityPlayer ep = (EntityPlayer)e;
            ToolChargingSystem.instance.tryChargeFromPlayer(is, ep);
            if (this.isActivated(ep, is, held) && ToolChargingSystem.instance.getCharge(is) > 0 && this.doTick(is, world, ep, held) && !ep.field_71075_bZ.field_75098_d) {
                ToolChargingSystem.instance.removeCharge(is, this.getChargeConsumptionRate(ep, world, is), ep);
            }
        }
    }

    public final int getEntityLifespan(ItemStack is, World world) {
        return Integer.MAX_VALUE;
    }

    public final boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public final Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new ToolChargingSystem.EntityChargingTool(world, (EntityItem)location, itemstack);
    }

    public final boolean onEntityItemUpdate(EntityItem ei) {
        return ToolChargingSystem.instance.tickItem(ei);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doChargeFX(EntityItem ei, int charge) {
        ItemPoweredChromaTool.doStandardChargeFX(ei, charge);
    }

    @SideOnly(value=Side.CLIENT)
    public static void doStandardChargeFX(EntityItem ei, int charge) {
        ItemStack is = ei.func_92059_d();
        PoweredItem pi = (PoweredItem)is.func_77973_b();
        if (charge == pi.getMaxCharge()) {
            double ang = 360.0 * Math.sin((double)ei.field_70292_b / 50.0);
            for (int i = 0; i < 360; i += 60) {
                double v = 0.125 + 0.0625 * Math.sin((double)ei.field_70292_b / 250.0);
                double vx = v * Math.cos(Math.toRadians(ang + (double)i));
                double vz = v * Math.sin(Math.toRadians(ang + (double)i));
                EntityBlurFX fx = new EntityCCBlurFX(ei.field_70170_p, ei.field_70165_t, (double)((int)ei.field_70163_u) + 0.25, ei.field_70161_v, vx, 0.0, vz).setLife(40).setRapidExpand().setScale(1.5f);
                fx.setColor(pi.getColor(is).getColor());
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        } else {
            double v = ReikaRandomHelper.getRandomPlusMinus((double)0.125, (double)0.0625);
            double[] vel = ReikaPhysicsHelper.polarToCartesian((double)v, (double)(field_77697_d.nextDouble() * 360.0), (double)(field_77697_d.nextDouble() * 360.0));
            float s = 1.0f + field_77697_d.nextFloat();
            EntityBlurFX fx = new EntityCCBlurFX(ei.field_70170_p, ei.field_70165_t, (double)((int)ei.field_70163_u) + 0.25, ei.field_70161_v, vel[0], vel[1], vel[2]).setLife(40).setScale(s).setColliding();
            fx.setColor(pi.getColor(is).getColor());
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public int getItemSpriteIndex(ItemStack item) {
        return super.getItemSpriteIndex(item) + item.func_77960_j();
    }

    protected void renderExtraIcons(RenderItem ri, ItemStack is, IItemRenderer.ItemRenderType type) {
    }

    @Override
    public boolean hasChargeStates() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public final boolean onRender(RenderItem ri, ItemStack is, IItemRenderer.ItemRenderType type) {
        if (is.field_77990_d != null && is.field_77990_d.func_74767_n("tooltip")) {
            return false;
        }
        this.renderExtraIcons(ri, is, type);
        ToolChargingSystem.instance.renderItemAux(ri, is, type);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public final boolean doPreGLTransforms(ItemStack is, IItemRenderer.ItemRenderType type) {
        return true;
    }

    @Override
    public String getNotes(int subpage) {
        return "Requires charging with " + this.getColor((ItemStack)new ItemStack((Item)this)).displayName + " ambient energy to be used";
    }

    @Override
    public int getMaxSubpage() {
        return 1;
    }

    @Override
    public boolean replaceOriginal() {
        return false;
    }
}

