/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base;

import Reika.ChromatiCraft.Base.ItemChromaTool;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public abstract class ItemWithItemFilter
extends ItemChromaTool {
    public ItemWithItemFilter(int index) {
        super(index);
    }

    public final ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        if (ep.func_70093_af()) {
            Mode m = this.getMode(is).next();
            if (m == Mode.REVERSED && !this.canBeReversed(ep, is)) {
                m = m.next();
            }
            this.setMode(is, m);
        } else {
            ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.ITEMWITHFILTER.ordinal(), world, 0, 0, 0);
        }
        return is;
    }

    @Override
    public final int getItemSpriteIndex(ItemStack item) {
        int base = super.getItemSpriteIndex(item);
        return this.getMode(item) == Mode.REVERSED ? base + 1 : base;
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        if (is.field_77990_d != null) {
            Mode m = this.getMode(is);
            String s = this.getActionName(ep, is);
            switch (m) {
                case EVERYTHING: {
                    li.add(s + " all items");
                    break;
                }
                case NOTHING: {
                    li.add(s + " no items");
                    break;
                }
                case BLACKLIST: {
                    li.add(s + " everything except:");
                    break;
                }
                case WHITELIST: {
                    li.add(s + ":");
                    break;
                }
                case REVERSED: {
                    li.add(s);
                }
            }
            if (m.usesInventory() && is.field_77990_d.func_74764_b("items")) {
                if (Keyboard.isKeyDown((int)42)) {
                    for (Filter in : this.getItemList(is)) {
                        li.add(">>" + in.item.getCriteriaAsChatFormatting() + in.item.getItemStack().func_82833_r());
                    }
                } else {
                    li.add(EnumChatFormatting.GREEN + "Hold shift for item data");
                }
            }
        }
    }

    public final boolean matchesItem(EntityPlayer ep, ItemStack tool, ItemStack is) {
        return this.isCurrentlyEnabled(ep, tool) && this.getMode(tool).matchesItem(tool, is);
    }

    public abstract boolean isCurrentlyEnabled(EntityPlayer var1, ItemStack var2);

    public abstract boolean canBeReversed(EntityPlayer var1, ItemStack var2);

    public abstract String getActionName(EntityPlayer var1, ItemStack var2);

    public final Mode getMode(ItemStack tool) {
        if (tool.field_77990_d == null) {
            tool.field_77990_d = new NBTTagCompound();
        }
        return Mode.list[tool.field_77990_d.func_74762_e("mode")];
    }

    private final void setMode(ItemStack tool, Mode mode) {
        if (tool.field_77990_d == null) {
            tool.field_77990_d = new NBTTagCompound();
        }
        tool.field_77990_d.func_74768_a("mode", mode.ordinal());
    }

    public final ArrayList<Filter> getItemList(ItemStack tool) {
        if (tool.field_77990_d == null) {
            tool.field_77990_d = new NBTTagCompound();
        }
        if (tool.field_77990_d.func_74764_b("items")) {
            return this.loadItemList(tool.field_77990_d.func_150295_c("items", ReikaNBTHelper.NBTTypes.COMPOUND.ID));
        }
        return new ArrayList<Filter>();
    }

    private final ArrayList<Filter> loadItemList(NBTTagList tag) {
        ArrayList<Filter> li = new ArrayList<Filter>();
        for (NBTTagCompound nbt : tag.field_74747_a) {
            Filter f = new Filter();
            f.readFromNBT(nbt);
            li.add(f);
        }
        return li;
    }

    private final void saveItemList(NBTTagCompound tag, Filter[] set) {
        NBTTagList li = new NBTTagList();
        for (Filter is : set) {
            if (is == null) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            is.writeToNBT(nbt);
            li.func_74742_a((NBTBase)nbt);
        }
        tag.func_74782_a("items", (NBTBase)li);
    }

    public final void setItems(ItemStack is, Filter[] filters) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        this.saveItemList(is.field_77990_d, filters);
    }

    public static final class Filter {
        private KeyedItemStack item;

        public Filter() {
        }

        public Filter(ItemStack is) {
            this.item = Filter.key(is);
        }

        private static KeyedItemStack key(ItemStack is) {
            return new KeyedItemStack(is).setIgnoreMetadata(false).setSized(false).setIgnoreNBT(false).setSimpleHash(true);
        }

        public void writeToNBT(NBTTagCompound tag) {
            if (this.item != null) {
                this.item.writeToNBT(tag);
            }
            tag.func_74778_a("filterType", this.getClass().getName());
        }

        public void readFromNBT(NBTTagCompound tag) {
            this.item = KeyedItemStack.readFromNBT((NBTTagCompound)tag);
        }

        public void toggleNBT() {
            if (this.item != null) {
                this.item.setIgnoreNBT(this.item.hasNBT());
            }
        }

        public boolean hasNBT() {
            return this.item != null && this.item.hasNBT();
        }

        public ItemStack getDisplay() {
            return this.item == null ? null : this.item.getItemStack();
        }

        public boolean match(ItemStack is) {
            return this.item != null && this.item.match(is);
        }
    }

    public static enum Mode {
        WHITELIST,
        BLACKLIST,
        EVERYTHING,
        NOTHING,
        REVERSED;

        private static final Mode[] list;

        private boolean matchesItem(ItemStack tool, ItemStack is) {
            switch (this) {
                case BLACKLIST: {
                    return !WHITELIST.matchesItem(tool, is);
                }
                case WHITELIST: {
                    ItemWithItemFilter bag = (ItemWithItemFilter)tool.func_77973_b();
                    for (Filter f : bag.getItemList(tool)) {
                        if (!f.match(is)) continue;
                        return true;
                    }
                    return false;
                }
                case EVERYTHING: {
                    return true;
                }
                case NOTHING: {
                    return false;
                }
                case REVERSED: {
                    return false;
                }
            }
            return false;
        }

        public boolean usesInventory() {
            return this != EVERYTHING && this != NOTHING && this != REVERSED;
        }

        private Mode next() {
            return list[(this.ordinal() + 1) % list.length];
        }

        static {
            list = Mode.values();
        }
    }
}

