/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base.TileEntity;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import java.util.Locale;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@APIStripper.Strippable(value={"buildcraft.api.transport.IPipeConnection"})
public abstract class FluidIOChromaticBase
extends TileEntityChromaticBase
implements IFluidHandler,
IPipeConnection {
    protected final HybridTank output = new HybridTank(ReikaStringParser.stripSpaces((String)(this.getTEName().toLowerCase(Locale.ENGLISH) + "out")), this.getCapacity());
    protected final HybridTank input = new HybridTank(ReikaStringParser.stripSpaces((String)(this.getTEName().toLowerCase(Locale.ENGLISH) + "in")), this.getCapacity());

    public abstract int getCapacity();

    public final FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.output.drain(resource.amount, doDrain) : null;
    }

    public abstract Fluid getInputFluid();

    public final FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.canDrain(from, null)) {
            return this.output.drain(maxDrain, doDrain);
        }
        return null;
    }

    public final boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.canOutputTo(from) && ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.output);
    }

    public final FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.input.getInfo(), this.output.getInfo()};
    }

    public final int getInputLevel() {
        return this.input.getLevel();
    }

    public final int getOutputLevel() {
        return this.output.getLevel();
    }

    public final Fluid getFluidInInput() {
        return this.input.getActualFluid();
    }

    public final Fluid getFluidInOutput() {
        return this.output.getActualFluid();
    }

    public final void removeLiquid(int amt) {
        this.output.removeLiquid(amt);
    }

    public final void addLiquid(int amt) {
        this.input.addLiquid(amt, this.getInputFluid());
    }

    public final boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.canReceiveFrom(from) && this.isValidFluid(fluid);
    }

    public boolean isValidFluid(Fluid f) {
        return f.equals(this.getInputFluid());
    }

    public final int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        return this.input.fill(resource, doFill);
    }

    public abstract boolean canOutputTo(ForgeDirection var1);

    public abstract boolean canReceiveFrom(ForgeDirection var1);

    public final IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection side) {
        return type == IPipeTile.PipeType.FLUID ? (this.canOutputTo(side) || this.canReceiveFrom(side) ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT) : IPipeConnection.ConnectOverride.DEFAULT;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.input.readFromNBT(NBT);
        this.output.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.input.writeToNBT(NBT);
        this.output.writeToNBT(NBT);
    }
}

