/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base.TileEntity;

import Reika.ChromatiCraft.Auxiliary.Interfaces.NBTTile;
import Reika.ChromatiCraft.Auxiliary.Interfaces.SneakPop;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityWirelessPowered;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntitySparkleFX;
import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.MultiblockControllerFinder;
import Reika.DragonAPI.ModInteract.DeepInteract.TransvectorHandler;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityAdjacencyUpgrade
extends TileEntityWirelessPowered
implements NBTTile,
SneakPop {
    public static final int MAX_TIER = 8;
    private int tier;
    private boolean particles = true;
    private int soundtick = 0;

    public final int getTier() {
        return this.tier;
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return e == this.getColor() ? 6000 + (1 + this.tier) * (1 + this.tier) * 1000 : 0;
    }

    @Override
    protected int getReceiveRange(CrystalElement e) {
        return e == this.getColor() ? 16 : 0;
    }

    public final boolean hasSufficientEnergy() {
        return this.energy.getValue(this.getColor()) >= this.getConsumedEnergy();
    }

    public final int getConsumedEnergy() {
        return ChromaOptions.POWEREDACCEL.getState() ? Math.max(1, ReikaMathLibrary.intpow2((int)(this.tier + 1), (int)2) / 4) : 0;
    }

    public final void updateEntity(World world, int x, int y, int z, int meta) {
        if (!this.canRun(world, x, y, z)) {
            this.soundtick = 0;
            return;
        }
        if (this.particles && world.field_72995_K) {
            this.spawnParticles(world, x, y, z);
        }
        ++this.soundtick;
        float f = 1.0f + (float)(1 + this.getTier()) / 8.0f;
        int l = (int)(221.0f / f);
        if (this.soundtick % l == 0) {
            ChromaSounds.DRONE.playSoundAtBlock(world, x, y, z, 0.25f, f);
        }
        if (ChromaOptions.POWEREDACCEL.getState()) {
            CrystalElement e = this.getColor();
            if (this.getTicksExisted() % 8 == 0 && this.energy.getValue(e) < this.getMaxStorage(e)) {
                this.requestEnergy(this.getColor(), this.getMaxStorage(e) - this.energy.getValue(e));
            }
            if (this.hasSufficientEnergy()) {
                if (this.getTicksExisted() % 8 == 0) {
                    this.energy.subtract(e, this.getConsumedEnergy());
                }
            } else {
                return;
            }
        }
        if (this.ticksIndividually()) {
            long time = System.nanoTime();
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = this.dirs[i];
                EffectResult res = this.tickDirection(world, x, y, z, dir, time);
                if (res.didAction && world.field_72995_K && rand.nextInt(4) == 0) {
                    this.spawnActionParticles(world, x, y, z, dir);
                }
                if (res.shouldContinue) {
                    continue;
                }
                break;
            }
        } else {
            this.doCollectiveTick(world, x, y, z);
        }
    }

    protected final TileEntity getEffectiveTileOnSide(ForgeDirection dir) {
        TileEntity te = this.getAdjacentTileEntity(dir);
        if (ModList.THAUMICTINKER.isLoaded()) {
            te = TransvectorHandler.getRelayedTile((TileEntity)te);
        }
        if (te != null && MultiblockControllerFinder.instance.isMultiblockTile(te)) {
            return MultiblockControllerFinder.instance.getController(te);
        }
        return te;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnActionParticles(World world, int x, int y, int z, ForgeDirection dir) {
        double o = 0.0625;
        double px = (double)(x + dir.offsetX) - o + rand.nextDouble() * (1.0 + 2.0 * o);
        double py = (double)(y + dir.offsetY) - o + rand.nextDouble() * (1.0 + 2.0 * o);
        double pz = (double)(z + dir.offsetZ) - o + rand.nextDouble() * (1.0 + 2.0 * o);
        EntityCCBlurFX fx = new EntityCCBlurFX(world, px, py, pz);
        fx.setRapidExpand().setAlphaFading().setLife(ReikaRandomHelper.getRandomBetween((int)8, (int)40)).setColor(this.getColor().getColor());
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z) {
        int p2 = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (rand.nextInt(1 + p2) == 0) {
            int p = this.getTier() > 0 ? (this.getTier() + 1) / 2 : (rand.nextBoolean() ? 1 : 0);
            for (int i = 0; i < p; ++i) {
                double dx = rand.nextDouble();
                double dy = rand.nextDouble();
                double dz = rand.nextDouble();
                double v = 0.125;
                double vx = v * (dx - 0.5);
                double vy = v * (dy - 0.5);
                double vz = v * (dz - 0.5);
                dx = (double)(x - 2) + dx * 4.0;
                dy = (double)(y - 2) + dy * 4.0;
                dz = (double)(z - 2) + dz * 4.0;
                vx = -(dx - (double)x) / 8.0;
                vy = -(dy - (double)y) / 8.0;
                vz = -(dz - (double)z) / 8.0;
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntitySparkleFX(world, dx + 0.5, dy + 0.5, dz + 0.5, vx, vy, vz));
            }
        }
    }

    protected abstract EffectResult tickDirection(World var1, int var2, int var3, int var4, ForgeDirection var5, long var6);

    public boolean canRun(World world, int x, int y, int z) {
        return !this.hasRedstoneSignal();
    }

    protected boolean ticksIndividually() {
        return true;
    }

    protected void doCollectiveTick(World world, int x, int y, int z) {
    }

    public abstract CrystalElement getColor();

    @Override
    public final void setDataFromItemStackTag(ItemStack is) {
        super.setDataFromItemStackTag(is);
        if (ChromaItems.ADJACENCY.matchWith(is) && is.field_77990_d != null) {
            this.tier = is.field_77990_d.func_74762_e("tier");
        }
    }

    @Override
    public final void getTagsToWriteToStack(NBTTagCompound NBT) {
        super.getTagsToWriteToStack(NBT);
        NBT.func_74768_a("tier", this.getTier());
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tier = NBT.func_74762_e("tier");
        this.energy.readFromNBT("energy", NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("tier", this.tier);
    }

    @Override
    public final void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBT.func_74757_a("particle", this.particles);
    }

    @Override
    public final void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.particles = NBT.func_74767_n("particle");
    }

    @Override
    public final void drop() {
        ItemStack is = ChromaItems.ADJACENCY.getStackOf(this.getColor());
        is.field_77990_d = new NBTTagCompound();
        this.getTagsToWriteToStack(is.field_77990_d);
        ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)is);
        this.delete();
    }

    @Override
    public final boolean canDrop(EntityPlayer ep) {
        return ep.func_110124_au().equals(this.placerUUID);
    }

    @Override
    public boolean allowMining(EntityPlayer ep) {
        return true;
    }

    @Override
    public final ChromaTiles getTile() {
        return ChromaTiles.ADJACENCY;
    }

    public static int getAdjacentUpgrade(TileEntityBase core, CrystalElement color) {
        Integer ret = TileEntityAdjacencyUpgrade.getAdjacentUpgrades(core).get(color);
        return ret != null ? ret : 0;
    }

    public static HashMap<CrystalElement, Integer> getAdjacentUpgrades(TileEntityBase core) {
        HashMap<CrystalElement, Integer> set = new HashMap<CrystalElement, Integer>();
        for (int i = 0; i < 6; ++i) {
            TileEntityAdjacencyUpgrade ta;
            TileEntity te = core.getAdjacentTileEntity(ForgeDirection.VALID_DIRECTIONS[i]);
            if (te != null && ModList.THAUMICTINKER.isLoaded()) {
                te = TransvectorHandler.getRelayedTile((TileEntity)te);
            }
            if (!(te instanceof TileEntityAdjacencyUpgrade) || !(ta = (TileEntityAdjacencyUpgrade)te).canRun(ta.field_145850_b, ta.field_145851_c, ta.field_145848_d, ta.field_145849_e) || ChromaOptions.POWEREDACCEL.getState() && !ta.energy.containsAtLeast(ta.getColor(), 100)) continue;
            Integer get = set.get(ta.getColor());
            int has = get != null ? get : 0;
            set.put(ta.getColor(), Math.max(1 + ta.getTier(), has));
        }
        return set;
    }

    public static HashMap<CrystalElement, Integer> getAdjacentUpgrades(World world, int x, int y, int z) {
        HashMap<CrystalElement, Integer> set = new HashMap<CrystalElement, Integer>();
        for (int i = 0; i < 6; ++i) {
            TileEntityAdjacencyUpgrade ta;
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            TileEntity te = world.func_147438_o(dx, dy, dz);
            if (te != null && ModList.THAUMICTINKER.isLoaded()) {
                te = TransvectorHandler.getRelayedTile((TileEntity)te);
            }
            if (!(te instanceof TileEntityAdjacencyUpgrade) || !(ta = (TileEntityAdjacencyUpgrade)te).canRun(ta.field_145850_b, ta.field_145851_c, ta.field_145848_d, ta.field_145849_e) || ChromaOptions.POWEREDACCEL.getState() && !ta.energy.containsAtLeast(ta.getColor(), 100)) continue;
            Integer get = set.get(ta.getColor());
            int has = get != null ? get : 0;
            set.put(ta.getColor(), Math.max(1 + ta.getTier(), has));
        }
        return set;
    }

    protected static enum EffectResult {
        ACTION(true, true),
        FINAL_ACTION(true, false),
        CONTINUE(false, true),
        STOP(false, false);

        public boolean didAction;
        public boolean shouldContinue;

        private EffectResult(boolean act, boolean con) {
            this.didAction = act;
            this.shouldContinue = con;
        }
    }
}

