/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base.TileEntity;

import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Auxiliary.Render.ChromaRenderList;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Interfaces.TextureFetcher;
import Reika.DragonAPI.Interfaces.TileEntity.RenderFetcher;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.ModList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.UUID;
import li.cil.oc.api.network.Visibility;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public abstract class TileEntityChromaticBase
extends TileEntityBase
implements RenderFetcher {
    protected final HashSet<UUID> owners = new HashSet();

    public final TextureFetcher getRenderer() {
        if (this.getTile().hasRender()) {
            return ChromaRenderList.getRenderForMachine(this.getTile());
        }
        return null;
    }

    protected final void onSetPlacer(EntityPlayer ep) {
        this.addOwner(ep);
    }

    public final void addOwner(EntityPlayer ep) {
        this.owners.add(ep.func_110124_au());
    }

    public final boolean allowTickAcceleration() {
        return this.getTile().allowsAcceleration();
    }

    public final boolean canUpdate() {
        return this.isTickingTE() && !ChromatiCraft.instance.isLocked();
    }

    protected boolean isTickingTE() {
        return true;
    }

    public final Block getTileEntityBlockID() {
        return this.getTile().getBlock();
    }

    public final int getIndex() {
        return this.getTile().ordinal();
    }

    protected final String getTEName() {
        return ChromaTiles.TEList[this.getIndex()].getName();
    }

    public abstract ChromaTiles getTile();

    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
    }

    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
    }

    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBTTagList li = new NBTTagList();
        for (UUID uid : this.owners) {
            li.func_74742_a((NBTBase)new NBTTagString(uid.toString()));
        }
        NBT.func_74782_a("owners", (NBTBase)li);
    }

    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.owners.clear();
        NBTTagList li = NBT.func_150295_c("owners", ReikaNBTHelper.NBTTypes.STRING.ID);
        for (Object o : li.field_74747_a) {
            NBTTagString tag = (NBTTagString)o;
            UUID uid = UUID.fromString(tag.func_150285_a_());
            this.owners.add(uid);
        }
    }

    public boolean isThisTE(Block id, int meta) {
        return id == this.getTileEntityBlockID() && meta == this.getIndex();
    }

    public final boolean shouldRenderInPass(int pass) {
        ChromaTiles r = ChromaTiles.TEList[this.getIndex()];
        return pass == 0 || r.renderInPass1() && pass == 1;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @DependentMethodStripper.ModDependent(value={ModList.OPENCOMPUTERS})
    public final Visibility getOCNetworkVisibility() {
        return Visibility.Network;
    }

    public final boolean isOwnedByPlayer(EntityPlayer ep) {
        return this.isOwnedByPlayer(ep.func_110124_au());
    }

    public final boolean isOwnedByPlayer(UUID id) {
        return this.owners.isEmpty() || this.owners.contains(id);
    }

    public final Collection<EntityPlayer> getOwners(boolean allowFake) {
        ArrayList<EntityPlayer> c = new ArrayList<EntityPlayer>();
        for (UUID uid : this.owners) {
            EntityPlayer ep = this.field_145850_b.func_152378_a(uid);
            if (ep == null || !allowFake && ReikaPlayerAPI.isFake((EntityPlayer)ep)) continue;
            c.add(ep);
        }
        return c;
    }

    public boolean onlyAllowOwnersToUse() {
        return false;
    }

    public boolean onlyAllowOwnersToMine() {
        return true;
    }

    public boolean renderModelsInPass1() {
        return false;
    }

    protected final void writeOwnerData(NBTTagCompound NBT) {
        if (this instanceof OwnedTile && !this.owners.isEmpty()) {
            ReikaNBTHelper.writeCollectionToNBT(this.owners, (NBTTagCompound)NBT, (String)"owners", (ReikaNBTHelper.NBTIO)ReikaNBTHelper.UUIDConverter.instance);
        }
    }

    protected final void readOwnerData(ItemStack is) {
        if (ChromaItems.PLACER.matchWith(is) && is.func_77960_j() == this.getTile().ordinal() && is.field_77990_d != null && is.field_77990_d.func_74764_b("owners") && this instanceof OwnedTile) {
            ReikaNBTHelper.readCollectionFromNBT(this.owners, (NBTTagCompound)is.field_77990_d, (String)"owners", (ReikaNBTHelper.NBTIO)ReikaNBTHelper.UUIDConverter.instance);
        }
    }
}

