/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base.TileEntity;

import Reika.ChromatiCraft.Auxiliary.Interfaces.OwnedTile;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.TileEntity.AOE.TileEntityAuraPoint;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.ThreadSafeTileCache;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.NestedMap;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Interfaces.TileEntity.LocationCached;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class TileEntityLocusPoint
extends TileEntityChromaticBase
implements LocationCached,
OwnedTile {
    private static final NestedMap<Class<? extends TileEntityLocusPoint>, UUID, ThreadSafeTileCache> cache = new NestedMap();

    public void breakBlock() {
        ThreadSafeTileCache c = (ThreadSafeTileCache)cache.get(this.getClass(), (Object)this.placerUUID);
        if (c != null) {
            c.remove((Object)new WorldLocation((TileEntity)this));
        }
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (world.field_72995_K) {
            this.spawnParticles(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z) {
        double n = this instanceof TileEntityAuraPoint ? (double)(1 + rand.nextInt(4)) : 1.0;
        n *= 1.0 + 0.75 * Math.sin((double)(this.getTicksExisted() + this.hashCode()) / 8.0);
        int ps = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        switch (ps) {
            case 1: {
                n *= 0.5;
                break;
            }
            case 2: {
                n *= 0.25;
            }
        }
        double d = Math.max(1.0, Minecraft.func_71410_x().field_71439_g.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) / 1024.0);
        int num = n <= 1.0 ? (ReikaRandomHelper.doWithChance((double)n) ? 1 : 0) : (int)(n /= d);
        for (int i = 0; i < num; ++i) {
            int color = this.getRenderColor();
            double v = ReikaRandomHelper.getRandomPlusMinus((double)0.125, (double)0.0625);
            if (rand.nextInt(4) == 0) {
                v *= ReikaRandomHelper.getRandomPlusMinus((double)2.0, (double)0.5);
            }
            double theta = rand.nextDouble() * 360.0;
            double phi = rand.nextDouble() * 360.0;
            double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)v, (double)theta, (double)phi);
            int l = ReikaRandomHelper.getRandomPlusMinus((int)20, (int)10);
            EntityBlurFX fx = new EntityCCBlurFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, xyz[0], xyz[1], xyz[2]).setColor(color).setScale(2.0f).setLife(l);
            EntityBlurFX fx2 = new EntityCCBlurFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, xyz[0], xyz[1], xyz[2]).setColor(0xFFFFFF).setScale(1.1f).setLife(l);
            fx.field_70145_X = false;
            fx2.field_70145_X = false;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    public abstract int getRenderColor();

    protected void onFirstTick(World world, int x, int y, int z) {
        TileEntityLocusPoint.cacheTile(this);
    }

    private static void cacheTile(TileEntityLocusPoint te) {
        WorldLocation loc = new WorldLocation((TileEntity)te);
        Class<?> cl = te.getClass();
        ThreadSafeTileCache c = (ThreadSafeTileCache)cache.get(cl, (Object)te.placerUUID);
        if (c == null) {
            c = new ThreadSafeTileCache().setTileClass(TileEntityLocusPoint.class);
            cache.put(cl, (Object)te.placerUUID, (Object)c);
        }
        c.add((Object)loc);
    }

    public static Collection<WorldLocation> getCache(Class<? extends TileEntityLocusPoint> cl, EntityPlayer ep) {
        return TileEntityLocusPoint.getCache(cl, ep.func_110124_au());
    }

    public static boolean hasLoci(Class<? extends TileEntityLocusPoint> cl, UUID uid) {
        ThreadSafeTileCache c = (ThreadSafeTileCache)cache.get(cl, (Object)uid);
        return c != null && !c.isEmpty();
    }

    public static Collection<WorldLocation> getCache(Class<? extends TileEntityLocusPoint> cl, UUID uid) {
        Collection c = (Collection)cache.get(cl, (Object)uid);
        return c != null ? Collections.unmodifiableCollection(c) : null;
    }

    public static WorldLocation getMatchFromCache(Class<? extends TileEntityLocusPoint> cl, UUID uid, Function<WorldLocation, Boolean> check) {
        ThreadSafeTileCache c = (ThreadSafeTileCache)cache.get(cl, (Object)uid);
        if (c == null || c.isEmpty()) {
            return null;
        }
        return (WorldLocation)c.iterateAsSearch(check);
    }

    public static Collection<WorldLocation> getCaches(Class<? extends TileEntityLocusPoint> cl) {
        Map map = cache.getMap(cl);
        ArrayList<WorldLocation> ret = new ArrayList<WorldLocation>();
        if (map != null) {
            for (Collection c : map.values()) {
                ret.addAll(c);
            }
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public final double func_145833_n() {
        return 65536.0;
    }

    public static void clearCache() {
        cache.clear();
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        this.writeOwnerData(NBT);
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        this.readOwnerData(is);
    }
}

