/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base.TileEntity;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Data.Maps.CountMap;
import Reika.DragonAPI.Instantiable.InertItem;
import Reika.DragonAPI.Instantiable.ModInteract.BasicAEInterface;
import Reika.DragonAPI.Instantiable.ModInteract.MEWorkTracker;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.ConditionBreakDropsInventory;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.MESystemReader;
import Reika.DragonAPI.ModList;
import appeng.api.AEApi;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.storage.ICellProvider;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"appeng.api.networking.security.IActionHost"})
public abstract class TileEntityMassStorage
extends TileEntityChromaticBase
implements IInventory,
IActionHost,
BreakAction,
ConditionBreakDropsInventory {
    private static final HashMap<UUID, ArrayList<ItemStack>> itemData = new HashMap();
    private final CountMap<KeyedItemStack> types = new CountMap();
    private ItemStack pendingInput;
    private UUID identifier = UUID.randomUUID();
    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    private MESystemReader network;
    private Object aeGridBlock;
    private Object aeGridNode;
    private MEWorkTracker hasWork = new MEWorkTracker();
    private final ArrayList<ItemStack> MEStacks = new ArrayList();
    private final StepTimer updateTimer = new StepTimer(200);
    private static Class storageBusClass;
    private static Method storageBusSide;
    private static Method storageBusHost;

    protected TileEntityMassStorage() {
        if (ModList.APPENG.isLoaded()) {
            this.aeGridBlock = new BasicAEInterface((TileEntity)this, this.getTile().getCraftedProduct());
            this.aeGridNode = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? AEApi.instance().createGridNode((IGridBlock)this.aeGridBlock) : null;
        }
    }

    private static void loadItemData(NBTTagCompound data) {
        ChromatiCraft.logger.log((Object)("Loading tool crate data from disk: " + data));
        itemData.clear();
        NBTTagList list = data.func_150295_c("data", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : list.field_74747_a) {
            NBTTagCompound NBT = (NBTTagCompound)o;
            NBTTagList items = NBT.func_150295_c("Items", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (int i = 0; i < items.func_74745_c(); ++i) {
                NBTTagCompound tag = items.func_150305_b(i);
                li.add(ItemStack.func_77949_a((NBTTagCompound)tag));
            }
            UUID key = UUID.fromString(NBT.func_74779_i("id"));
            itemData.put(key, li);
        }
    }

    private static void saveItemData(NBTTagCompound data) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<UUID, ArrayList<ItemStack>> e : itemData.entrySet()) {
            NBTTagCompound NBT = new NBTTagCompound();
            UUID key = e.getKey();
            ArrayList<ItemStack> li = e.getValue();
            NBTTagList nbttaglist = new NBTTagList();
            for (ItemStack is : li) {
                NBTTagCompound tag = new NBTTagCompound();
                is.func_77955_b(tag);
                nbttaglist.func_74742_a((NBTBase)tag);
            }
            NBT.func_74782_a("Items", (NBTBase)nbttaglist);
            NBT.func_74778_a("id", key.toString());
            list.func_74742_a((NBTBase)NBT);
        }
        data.func_74782_a("data", (NBTBase)list);
    }

    protected final ArrayList<ItemStack> getItems() {
        return this.getOrCreateItemList();
    }

    private ArrayList<ItemStack> getOrCreateItemList() {
        ArrayList<Object> ret = itemData.get(this.identifier);
        if (ret == null) {
            ret = new ArrayList();
            itemData.put(this.identifier, ret);
        }
        return ret;
    }

    public final int func_70302_i_() {
        return this.getItems().size() + 1;
    }

    public final ItemStack func_70301_a(int slot) {
        ArrayList<ItemStack> li = this.getItems();
        if (slot > li.size()) {
            ChromatiCraft.logger.logError((Object)("Something tried pulling from an off-list slot #" + slot + "!"));
            Thread.dumpStack();
            return null;
        }
        return slot == 0 ? this.pendingInput : li.get(slot - 1);
    }

    public final ItemStack func_70298_a(int par1, int par2) {
        return ReikaInventoryHelper.decrStackSize((IInventory)this, (int)par1, (int)par2);
    }

    public final ItemStack func_70304_b(int par1) {
        return ReikaInventoryHelper.getStackInSlotOnClosing((IInventory)this, (int)par1);
    }

    public final void func_70299_a(int slot, ItemStack is) {
        if (slot == 0) {
            this.pendingInput = is;
        } else if (is == null) {
            this.removeItem(slot - 1);
        } else {
            throw new IllegalArgumentException("Something tried to insert into an invalid slot!");
        }
    }

    public final String func_145825_b() {
        return this.getTEName();
    }

    public final boolean func_145818_k_() {
        return true;
    }

    public final int func_70297_j_() {
        return 1;
    }

    public final boolean func_70300_a(EntityPlayer ep) {
        return this.isPlayerAccessible(ep);
    }

    public final void func_70295_k_() {
    }

    public final void func_70305_f() {
    }

    public final boolean func_94041_b(int slot, ItemStack is) {
        return slot == 0 && (this.pendingInput == null || ReikaItemHelper.areStacksCombinable((ItemStack)this.pendingInput, (ItemStack)is, (int)is.func_77976_d())) && this.isItemValid(is) && this.getItems().size() < this.maxItemCount();
    }

    public abstract InertItem getFilterItemRender();

    public abstract boolean isItemValid(ItemStack var1);

    public abstract int maxItemCount();

    protected final ItemStack getPendingInput() {
        return this.pendingInput;
    }

    public final void updateEntity(World world, int x, int y, int z, int meta) {
        if (this.pendingInput != null && !world.field_72995_K) {
            this.addItem(this.pendingInput);
            this.pendingInput = null;
        }
        this.onTick(world, x, y, z);
        this.updateTimer.update();
        if (this.updateTimer.checkCap() && !world.field_72995_K) {
            this.buildCache();
        }
        if (ModList.APPENG.isLoaded()) {
            if (this.network != null) {
                this.network.tick();
            }
            if (this.aeGridBlock != null && !world.field_72995_K) {
                ((BasicAEInterface)this.aeGridBlock).setPowerCost(1.0);
            }
            if (!world.field_72995_K && this.network != null && !this.MEStacks.isEmpty() && this.pendingInput == null) {
                this.hasWork.tick();
                if (this.hasWork.hasWork()) {
                    if (ModList.APPENG.isLoaded() && this.network != null && !this.network.isEmpty) {
                        this.hasWork.reset();
                    }
                    this.injectItems();
                }
            }
        }
    }

    protected void onTick(World world, int x, int y, int z) {
    }

    protected final void onFirstTick(World world, int x, int y, int z) {
        WorldToolCrateData.initItemData(world).func_76186_a(true);
        this.initTypeData();
    }

    private void initTypeData() {
        this.types.clear();
        for (ItemStack is : this.getItems()) {
            KeyedItemStack ks = this.key(is);
            this.types.increment((Object)ks, is.field_77994_a);
            this.onAddItem(is);
        }
    }

    private void injectItems() {
        int idx = rand.nextInt(this.MEStacks.size());
        ItemStack is = this.MEStacks.get(idx);
        ItemStack copy = is.func_77946_l();
        int ret = (int)this.network.removeItem(is = ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)is.func_77976_d()), false, true);
        if (ret > 0) {
            this.pendingInput = ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)ret);
            if (ret >= copy.field_77994_a) {
                this.MEStacks.remove(idx);
            } else {
                this.MEStacks.get((int)idx).field_77994_a -= ret;
            }
        }
    }

    protected final void resetWorkTimer() {
        this.MEStacks.clear();
        this.updateTimer.setTick(this.updateTimer.getCap() + 2);
    }

    private void buildCache() {
        if (ModList.APPENG.isLoaded()) {
            Object oldNode = this.aeGridNode;
            if (this.aeGridNode == null) {
                Object object = this.aeGridNode = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? AEApi.instance().createGridNode((IGridBlock)this.aeGridBlock) : null;
            }
            if (this.aeGridNode != null) {
                ((IGridNode)this.aeGridNode).updateState();
            }
            if (oldNode != this.aeGridNode || this.network == null) {
                this.network = this.aeGridNode == null ? null : (this.network == null ? new MESystemReader((IGridNode)this.aeGridNode, (IActionHost)this) : new MESystemReader((IGridNode)this.aeGridNode, this.network));
            }
            if (this.network != null && this.canPullFromME()) {
                this.network.clearCallbacks();
                this.network.addGlobalCallback((MESystemReader.ChangeCallback)this.hasWork);
                this.MEStacks.clear();
                ArrayList li = new ArrayList();
                IStorageGrid isg = (IStorageGrid)this.getActionableNode().getGrid().getCache(IStorageGrid.class);
                HashSet set = MESystemReader.getAllCellContainers((IStorageGrid)isg);
                if (set != null) {
                    for (ICellProvider icp : set) {
                        if (this.isStorageBusToSelf(icp)) continue;
                        List invs = icp.getCellArray(StorageChannel.ITEMS);
                        for (IMEInventoryHandler inv : invs) {
                            IItemList items = inv.getAvailableItems(StorageChannel.ITEMS.createList());
                            for (IAEItemStack iae : items) {
                                ItemStack is;
                                if (!iae.isItem() || !iae.isMeaningful() || !this.isItemValid(is = iae.getItemStack())) continue;
                                this.MEStacks.add(is);
                            }
                        }
                    }
                }
            }
        }
    }

    protected boolean canPullFromME() {
        return true;
    }

    private final boolean isStorageBusToSelf(ICellProvider icp) {
        try {
            if (icp.getClass() == storageBusClass) {
                IPart part = (IPart)icp;
                IPartHost block = (IPartHost)storageBusHost.invoke((Object)part, new Object[0]);
                ForgeDirection dir = (ForgeDirection)storageBusSide.invoke((Object)icp, new Object[0]);
                DimensionalCoord loc = block.getLocation();
                TileEntity tile = block.getTile().field_145850_b.func_147438_o(loc.x + dir.offsetX, loc.y + dir.offsetY, loc.z + dir.offsetZ);
                return tile == this;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected final void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        super.onInvalidateOrUnload(world, x, y, z, invalid);
        if (ModList.APPENG.isLoaded() && this.aeGridNode != null) {
            ((IGridNode)this.aeGridNode).destroy();
        }
    }

    private void addItem(ItemStack is) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.getItems().add(is);
        if (this.field_145850_b != null) {
            WorldToolCrateData.initItemData(this.field_145850_b).func_76186_a(true);
        }
        KeyedItemStack ks = this.key(is);
        this.types.increment((Object)ks, is.field_77994_a);
        this.onAddItem(is);
        if (this.field_145850_b != null) {
            this.syncAllData(false);
        }
    }

    protected void onAddItem(ItemStack is) {
    }

    protected void onRemoveItem(ItemStack is) {
    }

    private void removeItem(int slot) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack is = this.getItems().remove(slot);
        if (is == null) {
            return;
        }
        if (this.field_145850_b != null) {
            WorldToolCrateData.initItemData(this.field_145850_b).func_76186_a(true);
        }
        KeyedItemStack ks = this.key(is);
        this.types.subtract((Object)ks, is.field_77994_a);
        this.onRemoveItem(is);
        if (this.field_145850_b != null) {
            this.syncAllData(false);
        }
    }

    public final boolean isEmpty() {
        return this.getItems().isEmpty();
    }

    protected abstract KeyedItemStack key(ItemStack var1);

    public final Map<KeyedItemStack, Integer> getItemTypes() {
        return this.types.view();
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        if (this.pendingInput != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.pendingInput.func_77955_b(tag);
            NBT.func_74782_a("pending", (NBTBase)tag);
        }
        NBT.func_74778_a("boxid", this.identifier.toString());
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        if (NBT.func_74764_b("boxid")) {
            this.identifier = UUID.fromString(NBT.func_74779_i("boxid"));
        }
        if (NBT.func_74764_b("Items")) {
            NBTTagList li = NBT.func_150295_c("Items", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
            ChromatiCraft.logger.log((Object)("Loading legacy tool crate data from NBT: " + li));
            this.getItems().clear();
            this.types.clear();
            for (int i = 0; i < li.func_74745_c(); ++i) {
                NBTTagCompound tag = li.func_150305_b(i);
                this.addItem(ItemStack.func_77949_a((NBTTagCompound)tag));
            }
        }
        if (NBT.func_74764_b("pending")) {
            NBTTagCompound tag = NBT.func_74775_l("pending");
            this.pendingInput = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBTTagCompound tag = new NBTTagCompound();
        this.types.writeToNBT(tag, (ReikaNBTHelper.NBTIO)ReikaNBTHelper.KeyedItemStackConverter.instance);
        NBT.func_74782_a("types", (NBTBase)tag);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        if (NBT.func_74764_b("types")) {
            this.types.readFromNBT(NBT.func_74775_l("types"), (ReikaNBTHelper.NBTIO)ReikaNBTHelper.KeyedItemStackConverter.instance);
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public final IGridNode getGridNode(ForgeDirection dir) {
        return (IGridNode)this.aeGridNode;
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public final IGridNode getActionableNode() {
        return (IGridNode)this.aeGridNode;
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public final AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public final void securityBreak() {
    }

    public final void breakBlock() {
        ReikaItemHelper.dropItems((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), this.getItems());
        itemData.remove(this.identifier);
    }

    public final boolean dropsInventoryOnBroken() {
        return false;
    }

    public final ItemStack removeLastItem() {
        ArrayList<ItemStack> li = this.getItems();
        if (li.isEmpty()) {
            return null;
        }
        ItemStack is = li.get(li.size() - 1);
        this.removeItem(li.size() - 1);
        return is;
    }

    static {
        if (ModList.APPENG.isLoaded()) {
            try {
                storageBusClass = Class.forName("appeng.parts.misc.PartStorageBus");
                storageBusSide = storageBusClass.getMethod("getSide", new Class[0]);
                storageBusHost = storageBusClass.getMethod("getHost", new Class[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                ChromatiCraft.logger.logError((Object)"Could not load storage bus methods!");
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.APPENG, e);
            }
        }
    }

    public static class WorldToolCrateData
    extends WorldSavedData {
        private static final String IDENTIFIER = "ToolCrateItems";

        public WorldToolCrateData() {
            super(IDENTIFIER);
        }

        public WorldToolCrateData(String s) {
            super(s);
        }

        public void func_76184_a(NBTTagCompound NBT) {
            TileEntityMassStorage.loadItemData(NBT);
        }

        public void func_76187_b(NBTTagCompound NBT) {
            TileEntityMassStorage.saveItemData(NBT);
        }

        private static WorldToolCrateData initItemData(World world) {
            WorldToolCrateData data = (WorldToolCrateData)world.func_72943_a(WorldToolCrateData.class, IDENTIFIER);
            if (data == null) {
                data = new WorldToolCrateData();
                world.func_72823_a(IDENTIFIER, (WorldSavedData)data);
            }
            return data;
        }
    }
}

