/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base.TileEntity;

import Reika.ChromatiCraft.Auxiliary.Interfaces.NBTTile;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityAdjacencyUpgrade;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Interfaces.LumenTile;
import Reika.ChromatiCraft.Magic.Network.RelayNetworker;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ProgressionCatchupHandling;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.AOE.Effect.TileEntityEfficiencyUpgrade;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityRelaySource;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Interfaces.TileEntity.AdjacentUpdateWatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityRelayPowered
extends TileEntityChromaticBase
implements LumenTile,
NBTTile,
AdjacentUpdateWatcher {
    protected final ElementTagCompound energy = new ElementTagCompound();
    private int requestTimer = rand.nextInt(200);
    private long lastRequestDecrTime = -1L;
    private int efficiencyBoost;

    public final void onAdjacentUpdate(World world, int x, int y, int z, Block b) {
        this.calcEfficiency();
        this.syncAllData(false);
    }

    public int getEfficiencyBoost() {
        return this.efficiencyBoost;
    }

    protected final float getEnergyCostScale() {
        float f = 1.0f;
        int e = this.getEfficiencyBoost();
        if (e > 0) {
            f = (float)((double)f * TileEntityEfficiencyUpgrade.getCostFactor(e - 1));
        }
        return f;
    }

    private void calcEfficiency() {
        this.efficiencyBoost = TileEntityAdjacencyUpgrade.getAdjacentUpgrade(this, CrystalElement.BLACK);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        CrystalElement e;
        if (DragonAPICore.debugtest && !world.field_72995_K && this.isAcceptingColor(e = CrystalElement.randomElement())) {
            this.energy.addValueToColor(e, 500);
        }
        if (!world.field_72995_K && this.makeRequests()) {
            if (this.requestTimer == 0) {
                ElementTagCompound tag = this.getRequiredEnergy();
                for (CrystalElement e2 : tag.elementSet()) {
                    for (int i = 0; !(i >= 6 || this.canReceiveFrom(e2, this.dirs[i]) && this.requestEnergy(e2, this.getRemainingSpace(e2), this.dirs[i])); ++i) {
                    }
                }
                this.requestTimer = 200;
            } else {
                long time = world.func_82737_E();
                if (this.lastRequestDecrTime != time) {
                    --this.requestTimer;
                }
                this.lastRequestDecrTime = time;
            }
        }
    }

    protected boolean makeRequests() {
        return true;
    }

    protected abstract boolean canReceiveFrom(CrystalElement var1, ForgeDirection var2);

    public abstract ElementTagCompound getRequiredEnergy();

    private final boolean requestEnergy(CrystalElement e, int amt, ForgeDirection dir) {
        TileEntityRelaySource te = RelayNetworker.instance.findRelaySource(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, dir, e, amt, 128);
        if (te != null) {
            int has = te.getEnergy(e);
            int trans = Math.min(Math.min(amt, has), this.getMaxStorage(e) - this.energy.getValue(e));
            te.drainEnergy(e, trans);
            te.onDrain(e, trans);
            this.energy.addValueToColor(e, trans);
            ProgressStage.RELAYS.stepPlayerTo(this.getPlacer());
            if (this.field_145850_b.field_72995_K) {
                ProgressionCatchupHandling.instance.attemptSync(this, 8.0, ProgressStage.RELAYS, true);
            }
            return has >= amt;
        }
        return false;
    }

    private final int addEnergy(CrystalElement e, int amt) {
        if (e == null || !this.isAcceptingColor(e)) {
            return 0;
        }
        int diff = Math.min(amt, this.getRemainingSpace(e));
        this.energy.addValueToColor(e, diff);
        return diff;
    }

    public abstract boolean isAcceptingColor(CrystalElement var1);

    public final int getEnergyScaled(CrystalElement e, int a) {
        return a * this.getEnergy(e) / this.getMaxStorage(e);
    }

    @Override
    public final int getEnergy(CrystalElement e) {
        return this.energy.getValue(e);
    }

    public final int getRemainingSpace(CrystalElement e) {
        return this.getMaxStorage(e) - this.getEnergy(e);
    }

    @Override
    public abstract int getMaxStorage(CrystalElement var1);

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.energy.readFromNBT("energy", NBT);
        this.efficiencyBoost = NBT.func_74762_e("eff");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.energy.writeToNBT("energy", NBT);
        NBT.func_74768_a("eff", this.efficiencyBoost);
    }

    protected final void drainEnergy(CrystalElement e, int amt) {
        if (this.allowsEfficiencyBoost()) {
            amt = (int)Math.max(1.0f, (float)amt * this.getEnergyCostScale());
        }
        this.energy.subtract(e, amt);
    }

    protected final void drainEnergy(ElementTagCompound tag) {
        if (this.allowsEfficiencyBoost()) {
            tag = tag.copy();
            tag.scale(this.getEnergyCostScale());
        }
        this.energy.subtract(tag);
    }

    protected boolean allowsEfficiencyBoost() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public final void setEnergyClient(CrystalElement e, int lvl) {
        this.energy.setTag(e, lvl);
    }

    @Override
    public final ElementTagCompound getEnergy() {
        return this.energy.copy();
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        this.writeOwnerData(NBT);
        this.energy.writeToNBT("energy", NBT);
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        this.readOwnerData(is);
        if (is.field_77990_d == null) {
            return;
        }
        this.energy.readFromNBT("energy", is.field_77990_d);
    }
}

