/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Base.TileEntity;

import Reika.ChromatiCraft.Auxiliary.Interfaces.NBTTile;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Interfaces.LumenTile;
import Reika.ChromatiCraft.Magic.Interfaces.WirelessSource;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.AOE.TileEntityAuraPoint;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class TileEntityWirelessPowered
extends TileEntityChromaticBase
implements LumenTile,
NBTTile {
    protected final ElementTagCompound energy = new ElementTagCompound();

    protected final boolean requestEnergy(CrystalElement e, int amt) {
        if (DragonAPICore.debugtest && !this.field_145850_b.field_72995_K) {
            this.energy.addValueToColor(e, amt);
        }
        int r = this.getReceiveRange(e);
        if (TileEntityAuraPoint.hasAuraPoints(this.placerUUID)) {
            r = (int)((double)r * 1.5);
        }
        Collection<WirelessSource> c = CrystalNetworker.instance.getNearTilesOfType(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, WirelessSource.class, r);
        for (WirelessSource s : c) {
            int ret;
            if (!s.canConduct() || !s.canTransmitTo(this) || (ret = s.request(e, amt, this.field_145851_c, this.field_145848_d, this.field_145849_e)) <= 0) continue;
            this.energy.addValueToColor(e, ret);
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.WIRELESS.ordinal(), (TileEntity)this, (int)64, (int[])new int[]{s.getX(), s.getY(), s.getZ(), e.ordinal(), ret});
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public final void doEnergyRequestClient(World world, int x, int y, int z, int dx, int dy, int dz, CrystalElement e, int amt) {
    }

    @Override
    public final int getEnergy(CrystalElement e) {
        return this.energy.getValue(e);
    }

    protected abstract int getReceiveRange(CrystalElement var1);

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.energy.readFromNBT("energy", NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.energy.writeToNBT("energy", NBT);
    }

    protected final void drainEnergy(CrystalElement e, int amt) {
        this.energy.subtract(e, amt);
    }

    protected final void drainEnergy(ElementTagCompound tag) {
        this.energy.subtract(tag);
    }

    @SideOnly(value=Side.CLIENT)
    public final void setEnergyClient(CrystalElement e, int lvl) {
        this.energy.setTag(e, lvl);
    }

    @Override
    public final ElementTagCompound getEnergy() {
        return this.energy.copy();
    }

    @Override
    public void getTagsToWriteToStack(NBTTagCompound NBT) {
        this.writeOwnerData(NBT);
        this.energy.writeToNBT("energy", NBT);
    }

    @Override
    public void setDataFromItemStackTag(ItemStack is) {
        this.readOwnerData(is);
        if (is.field_77990_d == null) {
            return;
        }
        this.energy.readFromNBT("energy", is.field_77990_d);
    }
}

