/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.Block.BlockLiquidChroma;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class BlockActiveChroma
extends BlockLiquidChroma {
    public BlockActiveChroma(Fluid fluid, Material material) {
        super(fluid, material);
    }

    public boolean hasTileEntity(int meta) {
        return meta == 0;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return meta == 0 ? new TileEntityChroma() : null;
    }

    @Override
    protected String getIcon() {
        return "activechroma";
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != this) {
            return 0xFFFFFF;
        }
        if (world.func_147439_a(x, y + 1, z) == this) {
            int c = this.func_149720_d(world, x, y + 1, z);
            return c;
        }
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            TileEntityChroma te = (TileEntityChroma)world.func_147438_o(x, y, z);
            return te != null ? te.getColor() : 0xFFFFFF;
        }
        for (int i = 2; i < 6; ++i) {
            int color;
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            if (world.func_147439_a(dx, dy, dz) != this) continue;
            if (world.func_147439_a(dx, dy + 1, dz) == this) {
                int c = this.func_149720_d(world, dx, dy + 1, dz);
                return c;
            }
            int meta2 = world.func_72805_g(dx, dy, dz);
            if (meta2 == 0) {
                return this.func_149720_d(world, dx, dy, dz);
            }
            if (meta2 >= meta || (color = this.func_149720_d(world, dx, dy, dz)) == 0xFFFFFF) continue;
            return color;
        }
        return 0xFFFFFF;
    }

    public static int getColor(CrystalElement e, int berries) {
        return ReikaColorAPI.mixColors((int)e.getColor(), (int)0xFFFFFF, (float)((float)berries / 24.0f));
    }

    public static float getDoublingChance(int ether) {
        return (float)(Math.pow(ether, 2.0) / Math.pow(16.0, 2.0));
    }

    public static int getSpeedMultiplier(int ether) {
        return (int)(1.0f + (float)(4 * ether) / 16.0f);
    }

    @Override
    public Fluid getFluid() {
        return FluidRegistry.getFluid((String)"chroma");
    }

    public static class TileEntityChroma
    extends TileEntity {
        public static final int BERRY_SATURATION = 24;
        public static final int ETHER_SATURATION = 16;
        private int berryCount;
        private CrystalElement element;
        private int etherCount;
        private boolean elementalBoost;

        public int activate(CrystalElement e, int amt) {
            int add = Math.min(24 - this.berryCount, amt);
            if (add > 0) {
                if (e == this.element || this.element == null) {
                    this.berryCount += add;
                    this.element = e;
                    this.update();
                } else {
                    add = 0;
                }
            }
            return add;
        }

        public int etherize(int amt) {
            int add = Math.min(16 - this.etherCount, amt);
            if (add > 0) {
                this.etherCount += add;
                this.update();
            }
            return add;
        }

        public boolean addElementalStone(CrystalElement e) {
            if (this.element != null && this.element == e && !this.elementalBoost) {
                this.elementalBoost = true;
                this.update();
                return true;
            }
            return false;
        }

        private void update() {
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147471_g(this.field_145851_c - 16, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147471_g(this.field_145851_c + 16, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e - 16);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e + 16);
            this.field_145850_b.func_147471_g(this.field_145851_c - 16, this.field_145848_d, this.field_145849_e - 16);
            this.field_145850_b.func_147471_g(this.field_145851_c + 16, this.field_145848_d, this.field_145849_e - 16);
            this.field_145850_b.func_147471_g(this.field_145851_c - 16, this.field_145848_d, this.field_145849_e + 16);
            this.field_145850_b.func_147471_g(this.field_145851_c + 16, this.field_145848_d, this.field_145849_e + 16);
        }

        public int getColor() {
            return this.element != null ? BlockActiveChroma.getColor(this.element, this.berryCount) : 0xFFFFFF;
        }

        public CrystalElement getElement() {
            return this.element;
        }

        public boolean canUpdate() {
            return false;
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBT.func_74768_a("count", this.berryCount);
            NBT.func_74768_a("ether", this.etherCount);
            NBT.func_74768_a("elem", this.element != null ? this.element.ordinal() : -1);
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.berryCount = NBT.func_74762_e("count");
            this.etherCount = NBT.func_74762_e("ether");
            int ord = NBT.func_74762_e("elem");
            this.element = ord >= 0 ? CrystalElement.elements[ord] : null;
        }

        public Packet func_145844_m() {
            NBTTagCompound NBT = new NBTTagCompound();
            this.func_145841_b(NBT);
            S35PacketUpdateTileEntity pack = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, NBT);
            return pack;
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity p) {
            this.func_145839_a(p.field_148860_e);
        }

        public boolean isFullyActive() {
            return this.berryCount == 24 && this.element != null;
        }

        public void clear() {
            this.berryCount = 0;
            this.etherCount = 0;
            this.element = null;
            this.update();
        }

        public int getEtherCount() {
            return this.etherCount;
        }

        public int getBerryCount() {
            return this.berryCount;
        }
    }
}

