/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.Auxiliary.Interfaces.SneakPop;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.StructuredBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Block.SemiUnbreakable;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.ModList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"mcp.mobius.waila.api.IWailaDataProvider"})
public class BlockChromaDoor
extends BlockContainer
implements SemiUnbreakable,
IWailaDataProvider {
    private final IIcon[] icons = new IIcon[2];

    public BlockChromaDoor(Material mat) {
        super(mat);
        this.func_149752_b(600000.0f);
        this.func_149722_s();
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChroma);
    }

    public int getLightValue(IBlockAccess iba, int x, int y, int z) {
        return iba instanceof World && ((World)iba).field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue() ? 0 : 12;
    }

    public float func_149737_a(EntityPlayer ep, World world, int x, int y, int z) {
        TileEntityChromaDoor te = (TileEntityChromaDoor)world.func_147438_o(x, y, z);
        return te.isOwner(ep) ? super.func_149737_a(ep, world, x, y, z) : -1.0f;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityChromaDoor();
    }

    public static void setOpen(World world, int x, int y, int z, boolean open) {
        BlockChromaDoor.setOpen(world, x, y, z, open, 0);
    }

    public static void setOpen(World world, int x, int y, int z, boolean open, int delay) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityChromaDoor) {
            if (open) {
                ((TileEntityChromaDoor)te).open(delay);
            } else {
                ((TileEntityChromaDoor)te).close();
            }
        }
    }

    public static boolean isOpen(IBlockAccess iba, int x, int y, int z) {
        return BlockChromaDoor.getBitflag(iba, x, y, z, 1);
    }

    public static boolean dealDamage(IBlockAccess iba, int x, int y, int z) {
        return BlockChromaDoor.getBitflag(iba, x, y, z, 2);
    }

    public static boolean consumeKey(IBlockAccess iba, int x, int y, int z) {
        return BlockChromaDoor.getBitflag(iba, x, y, z, 4);
    }

    public static boolean stayOpen(IBlockAccess iba, int x, int y, int z) {
        return BlockChromaDoor.getBitflag(iba, x, y, z, 8);
    }

    private static boolean getBitflag(IBlockAccess iba, int x, int y, int z, int bit) {
        return (iba.func_72805_g(x, y, z) & bit) != 0;
    }

    public static int getMetadata(boolean open, boolean damage, boolean oneuse, boolean stay) {
        return (open ? 1 : 0) | (damage ? 2 : 0) | (oneuse ? 4 : 0) | (stay ? 8 : 0);
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float in;
        float minx = in = 0.375f;
        float miny = in;
        float minz = in;
        float maxx = 1.0f - in;
        float maxy = 1.0f - in;
        float maxz = 1.0f - in;
        if (this.connectToBlock(world, x, y + 1, z, ForgeDirection.DOWN)) {
            maxy = 1.0f;
        }
        if (this.connectToBlock(world, x, y - 1, z, ForgeDirection.UP)) {
            miny = 0.0f;
        }
        if (this.connectToBlock(world, x + 1, y, z, ForgeDirection.WEST)) {
            maxx = 1.0f;
        }
        if (this.connectToBlock(world, x - 1, y, z, ForgeDirection.EAST)) {
            minx = 0.0f;
        }
        if (this.connectToBlock(world, x, y, z + 1, ForgeDirection.NORTH)) {
            maxz = 1.0f;
        }
        if (this.connectToBlock(world, x, y, z - 1, ForgeDirection.SOUTH)) {
            minz = 0.0f;
        }
        this.func_149676_a(minx, miny, minz, maxx, maxy, maxz);
    }

    private boolean connectToBlock(IBlockAccess world, int x, int y, int z, ForgeDirection s) {
        Block b = world.func_147439_a(x, y, z);
        if (b == this) {
            return true;
        }
        if (b == ChromaBlocks.PYLON.getBlockInstance() || b == ChromaBlocks.HOVER.getBlockInstance()) {
            return false;
        }
        if (b.func_149662_c() || b.func_149645_b() == 0) {
            return true;
        }
        if (b instanceof BlockStructureShield) {
            return true;
        }
        return b.isSideSolid(world, x, y, z, s);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase e, ItemStack is) {
        if (e instanceof EntityPlayer) {
            ((TileEntityChromaDoor)world.func_147438_o(x, y, z)).setPlacer((EntityPlayer)e);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return BlockChromaDoor.isOpen((IBlockAccess)world, x, y, z) ? null : super.func_149668_a(world, x, y, z);
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        return false;
    }

    public void func_149674_a(World world, int x, int y, int z, Random r) {
        if (world.func_147439_a(x, y, z) == this) {
            ((TileEntityChromaDoor)world.func_147438_o(x, y, z)).close();
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity e) {
        if (!BlockChromaDoor.isOpen((IBlockAccess)world, x, y, z)) {
            TileEntityChromaDoor te = (TileEntityChromaDoor)world.func_147438_o(x, y, z);
            if (BlockChromaDoor.dealDamage((IBlockAccess)world, x, y, z)) {
                e.func_70097_a(DamageSource.field_76376_m, 5.0f);
                ReikaEntityHelper.knockbackEntityFromPos((double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (Entity)e, (double)2.0);
                e.func_70024_g(0.0, 0.03125, 0.0);
                ChromaSounds.DISCHARGE.playSoundAtBlock(world, x, y, z, 0.5f, 2.0f);
            }
        }
    }

    public int func_149645_b() {
        return 0;
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.icons[meta % 2];
    }

    public void func_149651_a(IIconRegister ico) {
        this.icons[0] = ico.func_94245_a("chromaticraft:basic/door_closed");
        this.icons[1] = ico.func_94245_a("chromaticraft:basic/door_open");
    }

    public boolean func_149646_a(IBlockAccess iba, int x, int y, int z, int s) {
        return super.func_149646_a(iba, x, y, z, s) && iba.func_147439_a(x, y, z) != this;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isUnbreakable(World world, int x, int y, int z, int meta) {
        return true;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public final ItemStack getWailaStack(IWailaDataAccessor acc, IWailaConfigHandler cfg) {
        return null;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public final List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public final List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        TileEntityChromaDoor te = (TileEntityChromaDoor)acc.getTileEntity();
        if (te.uid != null) {
            currenttip.add("ID: " + te.uid);
        } else {
            currenttip.add("No ID");
        }
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public final List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public final NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return tag;
    }

    public static class TileEntityChromaDoor
    extends TileEntity
    implements SneakPop {
        private UUID uid;
        private UUID placer;
        private int lastAutoOpenDuration = 20;
        private boolean autoOpen;

        public void func_145845_h() {
            EntityPlayer ep;
            boolean flag = false;
            if (!this.field_145850_b.field_72995_K && this.autoOpen && !BlockChromaDoor.isOpen((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) != this.func_145838_q() && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) != this.func_145838_q() && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) != this.func_145838_q() && (ep = this.field_145850_b.func_152378_a(this.placer)) != null) {
                double d = ep.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d, (double)this.field_145849_e + 0.5);
                if (Math.abs(ep.field_70163_u - (double)this.field_145848_d) < 1.0 && d < 9.0 && (d < 2.0 || ReikaEntityHelper.isLookingAt((EntityLivingBase)ep, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d - 1.5), (double)((double)this.field_145849_e + 0.5)) || ReikaEntityHelper.isLookingAt((EntityLivingBase)ep, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5)))) {
                    this.lastAutoOpenDuration = Math.min(this.lastAutoOpenDuration + 10, 200);
                    this.open(this.lastAutoOpenDuration);
                    flag = true;
                }
            }
            if (!flag) {
                this.lastAutoOpenDuration = Math.max(this.lastAutoOpenDuration - 10, 20);
            }
        }

        public boolean canUpdate() {
            return true;
        }

        public boolean isOwner(EntityPlayer ep) {
            return ep.func_110124_au().equals(this.placer);
        }

        public boolean isOwned() {
            return this.placer != null;
        }

        public boolean canOpen(EntityPlayer ep, UUID uid) {
            return uid.equals(this.uid);
        }

        public void openClick() {
            this.open(50);
        }

        public void open(int delay) {
            this.setStates(true);
            ChromaSounds.ITEMSTAND.playSoundAtBlock(this, 1.0f, 2.0f);
            ChromaSounds.ITEMSTAND.playSoundAtBlock(this, 1.0f, 1.0f);
            if (delay > 0 && !BlockChromaDoor.stayOpen((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), delay);
            }
        }

        public void close() {
            this.setStates(false);
            ChromaSounds.ITEMSTAND.playSoundAtBlock(this, 1.0f, 0.5f);
        }

        private void setStates(boolean open) {
            for (Coordinate c : this.getDoorBlocks()) {
                if (!TileEntityChromaDoor.matchUIDs(this, (TileEntityChromaDoor)c.getTileEntity((IBlockAccess)this.field_145850_b))) continue;
                c.setBlockMetadata(this.field_145850_b, c.getBlockMetadata((IBlockAccess)this.field_145850_b) & 0xE | (open ? 1 : 0));
            }
        }

        private Collection<Coordinate> getDoorBlocks() {
            StructuredBlockArray b = new StructuredBlockArray(this.field_145850_b);
            b.recursiveAddWithBounds((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), this.field_145851_c - 8, this.field_145848_d - 8, this.field_145849_e - 8, this.field_145851_c + 8, this.field_145848_d + 8, this.field_145849_e + 8);
            return b.keySet();
        }

        private static boolean matchUIDs(TileEntityChromaDoor te1, TileEntityChromaDoor te2) {
            if (te1 == null || te2 == null) {
                ReikaJavaLibrary.pConsole((Object)"NULL TILE");
                return false;
            }
            if (te1.uid == te2.uid) {
                return true;
            }
            if (te1.uid == null || te2.uid == null) {
                return false;
            }
            return te1.uid.equals(te2.uid);
        }

        public void bindUUID(EntityPlayer ep, UUID id, int flags) {
            for (Coordinate c : this.getDoorBlocks()) {
                TileEntityChromaDoor te = (TileEntityChromaDoor)c.getTileEntity((IBlockAccess)this.field_145850_b);
                if (te == null) {
                    te = new TileEntityChromaDoor();
                    this.field_145850_b.func_147455_a(c.xCoord, c.yCoord, c.zCoord, (TileEntity)te);
                }
                if (ep != null && !te.isOwner(ep)) continue;
                te.uid = id;
                te.autoOpen = (flags & 1) > 0;
            }
        }

        public void setPlacer(EntityPlayer ep) {
            this.placer = ep.func_110124_au();
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            if (this.uid != null) {
                NBT.func_74778_a("uid", this.uid.toString());
            }
            if (this.placer != null) {
                NBT.func_74778_a("ep", this.placer.toString());
            }
            NBT.func_74757_a("auto", this.autoOpen);
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            if (NBT.func_74764_b("uid")) {
                this.uid = UUID.fromString(NBT.func_74779_i("uid"));
            }
            if (NBT.func_74764_b("ep")) {
                this.placer = UUID.fromString(NBT.func_74779_i("ep"));
            }
            this.autoOpen = NBT.func_74767_n("auto");
        }

        @Override
        public void drop() {
            this.func_145838_q().func_149697_b(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 0);
            this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a);
        }

        @Override
        public boolean canDrop(EntityPlayer ep) {
            return this.isOwner(ep);
        }

        @Override
        public boolean allowMining(EntityPlayer ep) {
            return this.isOwner(ep);
        }
    }
}

