/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.Auxiliary.Interfaces.NBTTile;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.TileEntity.TileEntityCrystalConsole;
import Reika.DragonAPI.Interfaces.Block.ConnectedTextureGlass;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCrystalConsole
extends BlockContainer
implements ConnectedTextureGlass {
    private final ArrayList<Integer> allDirs = new ArrayList();
    private final IIcon[] edges = new IIcon[10];
    private IIcon side;
    private IIcon screen;
    private IIcon invalid;

    public BlockCrystalConsole(Material mat) {
        super(mat);
        this.func_149711_c(1.0f);
        this.func_149752_b(6000.0f);
        for (int i = 1; i < 10; ++i) {
            this.allDirs.add(i);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        TileEntityCrystalConsole te = (TileEntityCrystalConsole)world.func_147438_o(x, y, z);
        ForgeDirection dir = te.getConsoleFace();
        if (s == dir.ordinal()) {
            int idx = this.getClickedButton(te, dir, a, c);
            if (idx >= 0) {
                if (idx >= 100) {
                    if (idx >= 200) {
                        idx -= 200;
                        te = (TileEntityCrystalConsole)te.getRightBlock();
                    } else {
                        idx -= 100;
                        te = (TileEntityCrystalConsole)te.getLeftBlock();
                    }
                }
                if (ReikaMathLibrary.isValueInsideBoundsIncl((double)0.5, (double)0.6875, (double)b)) {
                    te.toggle(idx, true);
                } else if (ReikaMathLibrary.isValueInsideBoundsIncl((double)0.3125, (double)0.5, (double)b)) {
                    te.toggle(idx, false);
                }
            }
            return true;
        }
        return false;
    }

    private int getClickedButton(TileEntityCrystalConsole te, ForgeDirection dir, float a, float c) {
        boolean pos;
        double d = dir.offsetX == 0 ? (double)a : (double)c;
        boolean bl = pos = dir.offsetX + dir.offsetZ > 0;
        if (pos) {
            d = 1.0 - d;
        }
        if (dir == ForgeDirection.NORTH) {
            d = 1.0 - d;
        }
        if (dir.offsetX + dir.offsetZ == 1) {
            ReikaJavaLibrary.pConsole((Object)d);
        }
        if (ReikaMathLibrary.isValueInsideBoundsIncl((double)0.15625, (double)0.34375, (double)d)) {
            return 0;
        }
        if (ReikaMathLibrary.isValueInsideBoundsIncl((double)0.40625, (double)0.59375, (double)d)) {
            return 1;
        }
        if (ReikaMathLibrary.isValueInsideBoundsIncl((double)0.65625, (double)0.84375, (double)d)) {
            return 2;
        }
        if (ReikaMathLibrary.isValueInsideBoundsIncl((double)0.90625, (double)1.0, (double)d)) {
            if (pos) {
                TileEntity te2 = te.getRightBlock();
                if (te2 instanceof TileEntityCrystalConsole && ((TileEntityCrystalConsole)te2).getSlotCount() == 4) {
                    return 200;
                }
            } else if (te.getSlotCount() == 4) {
                return 3;
            }
        } else if (ReikaMathLibrary.isValueInsideBoundsIncl((double)0.0, (double)0.09375, (double)d)) {
            if (pos) {
                if (te.getSlotCount() == 4) {
                    return 0;
                }
            } else {
                TileEntity te2 = te.getLeftBlock();
                if (te2 instanceof TileEntityCrystalConsole && ((TileEntityCrystalConsole)te2).getSlotCount() == 4) {
                    return 103;
                }
            }
        }
        return -1;
    }

    public final ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int meta = world.func_72805_g(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        ChromaTiles m = ChromaTiles.getTileFromIDandMetadata((Block)this, meta);
        if (m == null) {
            return null;
        }
        TileEntity tile = world.func_147438_o(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        ItemStack core = m.getCraftedProduct();
        if (core != null && m.hasNBTVariants()) {
            NBTTile nb = (NBTTile)tile;
            NBTTagCompound nbt = new NBTTagCompound();
            nb.getTagsToWriteToStack(nbt);
            core.field_77990_d = nbt.func_82582_d() ? null : (NBTTagCompound)nbt.func_74737_b();
        }
        return core;
    }

    public final boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean harvest) {
        if (this.canHarvest(world, player, x, y, z)) {
            this.func_149636_a(world, player, x, y, z, 0);
        }
        return world.func_147468_f(x, y, z);
    }

    private boolean canHarvest(World world, EntityPlayer ep, int x, int y, int z) {
        return !ep.field_71075_bZ.field_75098_d;
    }

    public void func_149636_a(World world, EntityPlayer ep, int x, int y, int z, int meta) {
        if (!this.canHarvest(world, ep, x, y, z)) {
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        ChromaTiles m = ChromaTiles.getTile((IBlockAccess)world, x, y, z);
        if (m != null) {
            ItemStack is = m.getCraftedProduct();
            ArrayList li = new ArrayList();
            if (is != null && m.hasNBTVariants()) {
                NBTTagCompound nbt = new NBTTagCompound();
                ((NBTTile)te).getTagsToWriteToStack(nbt);
                is.field_77990_d = (NBTTagCompound)(!nbt.func_82582_d() ? nbt.func_74737_b() : null);
            }
            if (is != null) {
                li = ReikaJavaLibrary.makeListFrom((Object)is);
            }
            ReikaItemHelper.dropItems((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (Collection)li);
        }
    }

    public final void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        TileEntityCrystalConsole te = (TileEntityCrystalConsole)world.func_147438_o(x, y, z);
        ReikaItemHelper.dropInventory((World)world, (int)x, (int)y, (int)z);
        te.breakBlock();
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    public IIcon func_149691_a(int s, int meta) {
        return s <= 1 ? this.side : this.screen;
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int s) {
        TileEntityCrystalConsole te = (TileEntityCrystalConsole)world.func_147438_o(x, y, z);
        if (!te.isValid()) {
            return this.invalid;
        }
        if (s == te.getConsoleFace().ordinal()) {
            return this.screen;
        }
        return this.side;
    }

    public void func_149651_a(IIconRegister ico) {
        this.side = ico.func_94245_a("chromaticraft:console/side");
        this.screen = ico.func_94245_a("chromaticraft:console/screen");
        this.invalid = ico.func_94245_a("chromaticraft:console/invalid");
        for (int i = 0; i < 10; ++i) {
            this.edges[i] = ico.func_94245_a("chromaticraft:console/glass_" + i);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCrystalConsole();
    }

    public int func_149645_b() {
        return ChromaISBRH.console.getRenderID();
    }

    public int func_149701_w() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInPass(int pass) {
        ChromaISBRH.console.setRenderPass(pass);
        return pass <= 1;
    }

    public HashSet<Integer> getEdgesForFace(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        HashSet<Integer> li = new HashSet<Integer>();
        li.addAll(this.allDirs);
        TileEntityCrystalConsole te = (TileEntityCrystalConsole)world.func_147438_o(x, y, z);
        if (face != te.getConsoleFace()) {
            li.remove(5);
        }
        if (face.offsetX != 0) {
            if (world.func_147439_a(x, y, z + 1) == this) {
                li.remove(2);
            }
            if (world.func_147439_a(x, y, z - 1) == this) {
                li.remove(8);
            }
            if (world.func_147439_a(x, y + 1, z) == this) {
                li.remove(4);
            }
            if (world.func_147439_a(x, y - 1, z) == this) {
                li.remove(6);
            }
            if (world.func_147439_a(x, y + 1, z + 1) == this && !li.contains(4) && !li.contains(2)) {
                li.remove(1);
            }
            if (world.func_147439_a(x, y - 1, z - 1) == this && !li.contains(6) && !li.contains(8)) {
                li.remove(9);
            }
            if (world.func_147439_a(x, y + 1, z - 1) == this && !li.contains(4) && !li.contains(8)) {
                li.remove(7);
            }
            if (world.func_147439_a(x, y - 1, z + 1) == this && !li.contains(2) && !li.contains(6)) {
                li.remove(3);
            }
        }
        if (face.offsetY != 0) {
            if (world.func_147439_a(x, y, z + 1) == this) {
                li.remove(2);
            }
            if (world.func_147439_a(x, y, z - 1) == this) {
                li.remove(8);
            }
            if (world.func_147439_a(x + 1, y, z) == this) {
                li.remove(4);
            }
            if (world.func_147439_a(x - 1, y, z) == this) {
                li.remove(6);
            }
            if (world.func_147439_a(x + 1, y, z + 1) == this && !li.contains(4) && !li.contains(2)) {
                li.remove(1);
            }
            if (world.func_147439_a(x - 1, y, z - 1) == this && !li.contains(6) && !li.contains(8)) {
                li.remove(9);
            }
            if (world.func_147439_a(x + 1, y, z - 1) == this && !li.contains(4) && !li.contains(8)) {
                li.remove(7);
            }
            if (world.func_147439_a(x - 1, y, z + 1) == this && !li.contains(2) && !li.contains(6)) {
                li.remove(3);
            }
        }
        if (face.offsetZ != 0) {
            if (world.func_147439_a(x, y + 1, z) == this) {
                li.remove(4);
            }
            if (world.func_147439_a(x, y - 1, z) == this) {
                li.remove(6);
            }
            if (world.func_147439_a(x + 1, y, z) == this) {
                li.remove(2);
            }
            if (world.func_147439_a(x - 1, y, z) == this) {
                li.remove(8);
            }
            if (world.func_147439_a(x + 1, y + 1, z) == this && !li.contains(2) && !li.contains(4)) {
                li.remove(1);
            }
            if (world.func_147439_a(x - 1, y - 1, z) == this && !li.contains(8) && !li.contains(6)) {
                li.remove(9);
            }
            if (world.func_147439_a(x + 1, y - 1, z) == this && !li.contains(2) && !li.contains(6)) {
                li.remove(3);
            }
            if (world.func_147439_a(x - 1, y + 1, z) == this && !li.contains(4) && !li.contains(8)) {
                li.remove(7);
            }
        }
        return li;
    }

    public IIcon getIconForEdge(IBlockAccess world, int x, int y, int z, int edge) {
        return this.edges[edge];
    }

    public IIcon getIconForEdge(int itemMeta, int edge) {
        return this.edges[edge];
    }

    public boolean renderCentralTextureForItem(int meta) {
        return true;
    }

    public boolean func_149646_a(IBlockAccess iba, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[side];
        return iba.func_147439_a(x, y, z) != this;
    }
}

