/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.API.Interfaces.MinerBlock;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.ModInterface.Bees.CrystalBees;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.ModInteract.Bees.BeeSpecies;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeType;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCrystalHive
extends Block
implements MinerBlock {
    private static final Random rand = new Random();
    private final IIcon[][] icons = new IIcon[16][6];

    public BlockCrystalHive(Material par2Material) {
        super(par2Material);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChromaGen);
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity e) {
        return !(e instanceof EntityDragon) && super.canEntityDestroy(world, x, y, z, e);
    }

    public boolean func_149700_E() {
        return false;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            ProgressStage.HIVE.stepPlayerTo(player);
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        if (!ModList.FORESTRY.isLoaded()) {
            return li;
        }
        BeeSpecies bee = this.getBeeForMeta(metadata);
        if (bee != null) {
            float chance = Math.min(0.95f, (float)(1 + fortune) * 0.25f);
            int drones = ReikaRandomHelper.doWithChance((double)chance) ? 2 : 1;
            for (int i = 0; i < drones; ++i) {
                li.add(bee.getBeeItem(world, EnumBeeType.DRONE));
            }
            ItemStack pr = bee.getBeeItem(world, EnumBeeType.PRINCESS);
            double ch = bee == CrystalBees.getPureBee() ? (double)(15 + 5 * fortune * fortune) : (double)(10 + 5 * fortune);
            ch = Math.min(bee == CrystalBees.getPureBee() ? 95.0 : 80.0, ch);
            ReikaBeeHelper.setPristine((ItemStack)pr, (boolean)ReikaRandomHelper.doWithChance((double)ch));
            li.add(pr);
        }
        return li;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return new ItemStack(ChromaBlocks.HIVE.getBlockInstance(), 1, meta);
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    private BeeSpecies getBeeForMeta(int meta) {
        switch (meta) {
            case 0: {
                return CrystalBees.getCrystalBee();
            }
            case 1: {
                return CrystalBees.getPureBee();
            }
        }
        return null;
    }

    public void func_149734_b(World world, int x, int y, int z, Random r) {
        int meta = world.func_72805_g(x, y, z);
        ReikaParticleHelper p = meta == 0 ? ReikaParticleHelper.AMBIENTMOBSPELL : ReikaParticleHelper.ENCHANTMENT;
        int dy = meta == 0 ? y : y + 1;
        p.spawnAroundBlock(world, x, dy, z, 8);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ico) {
        int i;
        for (i = 0; i < 2; ++i) {
            this.icons[0][i] = ico.func_94245_a("chromaticraft:hives/crystal_top");
        }
        for (i = 2; i < 6; ++i) {
            this.icons[0][i] = ico.func_94245_a("chromaticraft:hives/crystal_side");
        }
        for (i = 0; i < 2; ++i) {
            this.icons[1][i] = ico.func_94245_a("chromaticraft:hives/pure_top");
        }
        for (i = 2; i < 6; ++i) {
            this.icons[1][i] = ico.func_94245_a("chromaticraft:hives/pure_side");
        }
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.icons[meta][s];
    }

    @Override
    public boolean isMineable(int meta) {
        return true;
    }

    @Override
    public ArrayList<ItemStack> getHarvestItems(World world, int x, int y, int z, int meta, int fortune) {
        return this.getDrops(world, x, y, z, meta, fortune);
    }

    @Override
    public MinerBlock.MineralCategory getCategory() {
        return MinerBlock.MineralCategory.MISC_UNDERGROUND;
    }

    @Override
    public Block getReplacedBlock(World world, int x, int y, int z) {
        return Blocks.field_150350_a;
    }

    @Override
    public boolean allowSilkTouch(int meta) {
        return false;
    }
}

