/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.Interfaces.ProgressionTrigger;
import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Block.BlockCrystalTile;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Interfaces.NaturalNetworkTile;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntitySkypeater;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityWeakRepeater;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityDimensionCore;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityStructControl;
import Reika.ChromatiCraft.TileEntity.TileEntityPersonalCharger;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Interfaces.Block.SemiUnbreakable;
import Reika.DragonAPI.Interfaces.TileEntity.PlayerBreakHook;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.ModList;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import vazkii.botania.api.mana.ILaputaImmobile;

@APIStripper.Strippable(value={"vazkii.botania.api.mana.ILaputaImmobile"})
public class BlockCrystalPylon
extends BlockCrystalTile
implements ProgressionTrigger,
SemiUnbreakable,
ILaputaImmobile {
    private IIcon burnedWeakRepeater;
    private IIcon weakRepeaterFrame;

    public BlockCrystalPylon(Material mat) {
        super(mat);
    }

    @Override
    public int func_149701_w() {
        return 1;
    }

    @Override
    public final int getLightValue(IBlockAccess iba, int x, int y, int z) {
        TileEntity te = iba.func_147438_o(x, y, z);
        int color = te instanceof TileEntityCrystalPylon ? ((TileEntityCrystalPylon)te).getColor().getColor() : 0xFFFFFF;
        color = te instanceof TileEntityDimensionCore ? ((TileEntityDimensionCore)te).getColor().getColor() : color;
        color = te instanceof TileEntityPersonalCharger ? ((TileEntityPersonalCharger)te).getColor().getColor() : color;
        int b = te instanceof TileEntityStructControl ? ((TileEntityStructControl)te).getBrightness() : 15;
        b = te instanceof TileEntitySkypeater ? 0 : b;
        return ModList.COLORLIGHT.isLoaded() ? ReikaColorAPI.getPackedIntForColoredLight((int)color, (int)b) : b;
    }

    @Override
    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        ChromaTiles c = ChromaTiles.getTile((IBlockAccess)world, x, y, z);
        if (c == null) {
            return null;
        }
        switch (c) {
            case PYLON: 
            case STRUCTCONTROL: 
            case AURAPOINT: 
            case DIMENSIONCORE: 
            case PERSONAL: 
            case SKYPEATER: {
                return null;
            }
        }
        return this.getBlockAABB(x, y, z);
    }

    @Override
    public float func_149737_a(EntityPlayer ep, World world, int x, int y, int z) {
        TileEntityBase te = (TileEntityBase)world.func_147438_o(x, y, z);
        if (te instanceof NaturalNetworkTile) {
            return -1.0f;
        }
        if (te instanceof PlayerBreakHook && !((PlayerBreakHook)te).isBreakable(ep)) {
            return -1.0f;
        }
        if (te instanceof TileEntityStructControl) {
            return super.func_149737_a(ep, world, x, y, z) * 32.0f;
        }
        if (te instanceof TileEntityDimensionCore) {
            return super.func_149737_a(ep, world, x, y, z) * 8.0f;
        }
        return super.func_149737_a(ep, world, x, y, z);
    }

    @Override
    protected boolean isFullyHarvestable(World world, int x, int y, int z, int meta, EntityPlayer ep, ChromaTiles c, TileEntityChromaticBase te) {
        TileEntityWeakRepeater tile;
        if (c == ChromaTiles.WEAKREPEATER && (tile = (TileEntityWeakRepeater)te).isRuptured()) {
            return false;
        }
        return super.isFullyHarvestable(world, x, y, z, meta, ep, c, te);
    }

    @Override
    public ArrayList<ItemStack> getPieces(World world, int x, int y, int z) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        switch (ChromaTiles.getTile((IBlockAccess)world, x, y, z)) {
            case WEAKREPEATER: {
                int i;
                int n = ReikaRandomHelper.getRandomBetween((int)3, (int)8);
                for (i = 0; i < n; ++i) {
                    li.add(new ItemStack(Items.field_151055_y));
                }
                n = ReikaRandomHelper.getRandomBetween((int)1, (int)3);
                for (i = 0; i < n; ++i) {
                    li.add(ChromaStacks.crystalPowder);
                }
                if (!world.field_73012_v.nextBoolean()) break;
                li.add(new ItemStack(Items.field_151114_aO));
                break;
            }
        }
        return li;
    }

    @Override
    public void func_149651_a(IIconRegister ico) {
        super.func_149651_a(ico);
        this.weakRepeaterFrame = ico.func_94245_a("chromaticraft:basic/weakrepeater_frame");
        this.burnedWeakRepeater = ico.func_94245_a("chromaticraft:basic/weakrepeater_frame_burned");
    }

    @Override
    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        TileEntityWeakRepeater te;
        int meta = iba.func_72805_g(x, y, z);
        if (ChromaTiles.getTileFromIDandMetadata((Block)this, meta) == ChromaTiles.WEAKREPEATER && (te = (TileEntityWeakRepeater)iba.func_147438_o(x, y, z)).isRuptured()) {
            return s == 0 ? this.weakRepeaterFrame : (s == 1 ? ChromaIcons.TRANSPARENT.getIcon() : this.burnedWeakRepeater);
        }
        return this.func_149691_a(s, meta);
    }

    @Override
    public IIcon func_149691_a(int s, int meta) {
        switch (meta) {
            case 0: {
                return ChromaIcons.TRANSPARENT.getIcon();
            }
            case 1: {
                return ChromaIcons.REPEATER.getIcon();
            }
            case 2: {
                return ChromaIcons.MULTIREPEATER.getIcon();
            }
            case 3: {
                return ChromaIcons.TRANSPARENT.getIcon();
            }
            case 4: {
                return ChromaIcons.CHROMA.getIcon();
            }
            case 5: {
                return ChromaIcons.TRANSPARENT.getIcon();
            }
            case 6: {
                return ChromaIcons.TRANSPARENT.getIcon();
            }
            case 7: {
                return ChromaIcons.TRANSPARENT.getIcon();
            }
            case 8: {
                return ChromaIcons.BROADCAST.getIcon();
            }
            case 9: {
                return ChromaIcons.WEAKREPEATER.getIcon();
            }
            case 11: {
                return ChromaIcons.TRANSPARENT.getIcon();
            }
        }
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }

    @Override
    public ProgressStage[] getTriggers(EntityPlayer ep, World world, int x, int y, int z) {
        ProgressStage[] progressStageArray;
        boolean pylon;
        ChromaTiles c = ChromaTiles.getTile((IBlockAccess)world, x, y, z);
        boolean bl = pylon = c == ChromaTiles.PYLON && ((TileEntityCrystalPylon)world.func_147438_o(x, y, z)).canConduct();
        if (pylon) {
            ProgressStage[] progressStageArray2 = new ProgressStage[1];
            progressStageArray = progressStageArray2;
            progressStageArray2[0] = ProgressStage.PYLON;
        } else {
            progressStageArray = null;
        }
        return progressStageArray;
    }

    public boolean isUnbreakable(World world, int x, int y, int z, int meta) {
        TileEntityBase te = (TileEntityBase)world.func_147438_o(x, y, z);
        if (te instanceof NaturalNetworkTile) {
            return true;
        }
        if (te instanceof PlayerBreakHook) {
            return !((PlayerBreakHook)te).isBreakable(null);
        }
        return false;
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        return ChromaTiles.getTile((IBlockAccess)world, x, y, z) == ChromaTiles.WEAKREPEATER && side == ForgeDirection.UP;
    }

    @Override
    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        ChromaTiles c = ChromaTiles.getTile(world, x, y, z);
        if (c == null) {
            ChromatiCraft.logger.logError((Object)"Something requested isSideSolid with invalid positions:");
            ChromatiCraft.logger.log((Object)("Location: " + x + ", " + y + ", " + z));
            ChromatiCraft.logger.log((Object)("Block: " + world.func_147439_a(x, y, z)));
            ChromatiCraft.logger.log((Object)("TileEntity: " + world.func_147438_o(x, y, z)));
            return false;
        }
        switch (c) {
            case WEAKREPEATER: 
            case REPEATER: 
            case COMPOUND: {
                return dir == ForgeDirection.UP;
            }
        }
        return false;
    }

    public final boolean canMove(World world, int x, int y, int z) {
        return false;
    }
}

