/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.API.Interfaces.CrystalTank;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.TileEntity.Storage.TileEntityCrystalTank;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Block.ConnectedTextureGlass;
import Reika.DragonAPI.Interfaces.Registry.TileEnum;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.ModList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

@APIStripper.Strippable(value={"mcp.mobius.waila.api.IWailaDataProvider"})
public class BlockCrystalTank
extends Block
implements IWailaDataProvider,
ConnectedTextureGlass {
    private final ArrayList<Integer> allDirs = new ArrayList();
    private IIcon[] edges = new IIcon[10];

    public BlockCrystalTank(Material mat) {
        super(mat);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChroma);
        this.func_149711_c(1.0f);
        this.func_149752_b(600.0f);
        for (int i = 1; i < 10; ++i) {
            this.allDirs.add(i);
        }
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new CrystalTankAuxTile();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public int func_149692_a(int meta) {
        return meta - meta % 2;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        ItemStack is = ep.func_71045_bC();
        if (ChromaBlocks.TANK.match(is)) {
            return false;
        }
        if (ChromaItems.TRANSITION.matchWith(is)) {
            return false;
        }
        CrystalTankAuxTile te = (CrystalTankAuxTile)world.func_147438_o(x, y, z);
        TileEntityCrystalTank tk = te.getTankController();
        if (tk == null) {
            return false;
        }
        if (is != null && is.field_77994_a == 1) {
            FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)is);
            if (fs != null) {
                int drain = tk.fill(null, fs, false);
                if (drain == fs.amount) {
                    tk.fill(null, fs, true);
                    if (!ep.field_71075_bZ.field_75098_d) {
                        ItemStack is2 = FluidContainerRegistry.drainFluidContainer((ItemStack)is);
                        ep.func_70062_b(0, is2);
                    }
                }
                return true;
            }
            if (FluidContainerRegistry.isEmptyContainer((ItemStack)is)) {
                ItemStack fill;
                FluidStack rem = tk.drain(null, tk.getCurrentFluidLevel(), false);
                if (rem != null && (fill = FluidContainerRegistry.fillFluidContainer((FluidStack)rem, (ItemStack)is)) != null) {
                    FluidStack removed = FluidContainerRegistry.getFluidForFilledItem((ItemStack)fill);
                    tk.drain(null, removed.amount, true);
                    if (!ep.field_71075_bZ.field_75098_d) {
                        ep.func_70062_b(0, fill);
                    }
                }
                return true;
            }
        }
        ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.TILE.ordinal(), world, tk.field_145851_c, tk.field_145848_d, tk.field_145849_e);
        return true;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        CrystalTankAuxTile tile = (CrystalTankAuxTile)world.func_147438_o(x, y, z);
        return tile.getLightValue();
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.edges[0];
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ico.func_94245_a("chromaticraft:basic/tank2");
        for (int i = 0; i < 10; ++i) {
            this.edges[i] = ico.func_94245_a("chromaticraft:tank/tank_" + i);
        }
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return ChromaISBRH.tank.getRenderID();
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        ChromaISBRH.tank.setRenderPass(pass);
        return pass <= 1;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        CrystalTankAuxTile tile;
        CrystalTankAuxTile te = new CrystalTankAuxTile();
        world.func_147455_a(x, y, z, (TileEntity)te);
        TileEntityCrystalTank con = null;
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            ChromaTiles c = ChromaTiles.getTile((IBlockAccess)world, dx, dy, dz);
            if (c == ChromaTiles.TANK) {
                TileEntityCrystalTank tank = (TileEntityCrystalTank)world.func_147438_o(dx, dy, dz);
                te.setTile(tank);
                te.markComplete();
                te.addToTank();
                con = tank;
                continue;
            }
            if (world.func_147439_a(dx, dy, dz) != this || !(tile = (CrystalTankAuxTile)world.func_147438_o(dx, dy, dz)).hasTile()) continue;
            te.setTile(tile.getTankController());
            tile.markComplete();
            te.addToTank();
            con = tile.getTankController();
        }
        if (con != null) {
            BlockArray blocks = new BlockArray();
            blocks.recursiveAddWithBounds((IBlockAccess)world, x, y, z, (Block)this, x - 32, y - 32, z - 32, x + 32, y + 32, z + 32);
            for (int i = 0; i < blocks.getSize(); ++i) {
                Coordinate c = blocks.getNthBlock(i);
                int dx = c.xCoord;
                int dy = c.yCoord;
                int dz = c.zCoord;
                tile = (CrystalTankAuxTile)world.func_147438_o(dx, dy, dz);
                tile.setTile(con);
                tile.markComplete();
                tile.addToTank();
            }
        }
    }

    private void confirmHasController(World world, int x, int y, int z) {
        BlockArray blocks = new BlockArray();
        Set li = ReikaJavaLibrary.getSet((Object[])new BlockKey[]{new BlockKey((Block)this), new BlockKey((TileEnum)ChromaTiles.TANK)});
        blocks.recursiveAddMultipleWithBounds((IBlockAccess)world, x, y, z, li, x - 32, y - 32, z - 32, x + 32, y + 32, z + 32);
        Object con = null;
        int count = 0;
        for (int i = 0; i < blocks.getSize(); ++i) {
            Coordinate c = blocks.getNthBlock(i);
            int dx = c.xCoord;
            int dy = c.yCoord;
            int dz = c.zCoord;
            ChromaTiles ct = ChromaTiles.getTile((IBlockAccess)world, dx, dy, dz);
            if (ct != ChromaTiles.TANK) continue;
            ++count;
        }
        if (count != 1) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof CrystalTankAuxTile) {
                ((CrystalTankAuxTile)te).removeFromTank();
            }
            for (int i = 0; i < blocks.getSize(); ++i) {
                Coordinate c = blocks.getNthBlock(i);
                int dx = c.xCoord;
                int dy = c.yCoord;
                int dz = c.zCoord;
                TileEntity te2 = world.func_147438_o(dx, dy, dz);
                if (!(te2 instanceof CrystalTankAuxTile)) continue;
                ((CrystalTankAuxTile)te2).removeFromTank();
            }
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block old, int oldmeta) {
        CrystalTankAuxTile te = (CrystalTankAuxTile)world.func_147438_o(x, y, z);
        if (te != null) {
            te.removeFromTank(oldmeta);
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            this.confirmHasController(world, dx, dy, dz);
        }
        super.func_149749_a(world, x, y, z, old, oldmeta);
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public ItemStack getWailaStack(IWailaDataAccessor acc, IWailaConfigHandler cfg) {
        return null;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public List<String> getWailaBody(ItemStack is, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler cfg) {
        CrystalTankAuxTile te = (CrystalTankAuxTile)acc.getTileEntity();
        TileEntityCrystalTank tank = te.getTankController();
        if (tank != null) {
            tank.syncAllData(false);
            int amt = tank.getCurrentFluidLevel();
            int capacity = tank.getCapacity();
            Fluid f = tank.getCurrentFluid();
            if (amt > 0 && f != null) {
                currenttip.add(String.format("Tank: %dmB/%dmB of %s", amt, capacity, f.getLocalizedName()));
            } else {
                currenttip.add(String.format("Tank: Empty (Capacity %dmB)", capacity));
            }
        } else {
            currenttip.add("No Tank");
        }
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public List<String> getWailaTail(ItemStack is, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler cfg) {
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public final NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return tag;
    }

    public boolean func_149646_a(IBlockAccess iba, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[side];
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        return iba.func_147439_a(dx, dy, dz) != this && ChromaTiles.getTile(iba, dx, dy, dz) != ChromaTiles.TANK;
    }

    public HashSet<Integer> getEdgesForFace(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        HashSet<Integer> li = new HashSet<Integer>();
        li.addAll(this.allDirs);
        if (world.func_72805_g(x, y, z) % 2 == 0) {
            return li;
        }
        if (face.offsetX != 0) {
            if (world.func_147439_a(x, y, z + 1) == this || ChromaTiles.getTile(world, x, y, z + 1) == ChromaTiles.TANK) {
                li.remove(2);
            }
            if (world.func_147439_a(x, y, z - 1) == this || ChromaTiles.getTile(world, x, y, z - 1) == ChromaTiles.TANK) {
                li.remove(8);
            }
            if (world.func_147439_a(x, y + 1, z) == this || ChromaTiles.getTile(world, x, y + 1, z) == ChromaTiles.TANK) {
                li.remove(4);
            }
            if (world.func_147439_a(x, y - 1, z) == this || ChromaTiles.getTile(world, x, y - 1, z) == ChromaTiles.TANK) {
                li.remove(6);
            }
            if (world.func_147439_a(x, y + 1, z + 1) == this && !li.contains(4) && !li.contains(2)) {
                li.remove(1);
            }
            if (world.func_147439_a(x, y - 1, z - 1) == this && !li.contains(6) && !li.contains(8)) {
                li.remove(9);
            }
            if (world.func_147439_a(x, y + 1, z - 1) == this && !li.contains(4) && !li.contains(8)) {
                li.remove(7);
            }
            if (world.func_147439_a(x, y - 1, z + 1) == this && !li.contains(2) && !li.contains(6)) {
                li.remove(3);
            }
        }
        if (face.offsetY != 0) {
            if (world.func_147439_a(x, y, z + 1) == this || ChromaTiles.getTile(world, x, y, z + 1) == ChromaTiles.TANK) {
                li.remove(2);
            }
            if (world.func_147439_a(x, y, z - 1) == this || ChromaTiles.getTile(world, x, y, z - 1) == ChromaTiles.TANK) {
                li.remove(8);
            }
            if (world.func_147439_a(x + 1, y, z) == this || ChromaTiles.getTile(world, x + 1, y, z) == ChromaTiles.TANK) {
                li.remove(4);
            }
            if (world.func_147439_a(x - 1, y, z) == this || ChromaTiles.getTile(world, x - 1, y, z) == ChromaTiles.TANK) {
                li.remove(6);
            }
            if (world.func_147439_a(x + 1, y, z + 1) == this && !li.contains(4) && !li.contains(2)) {
                li.remove(1);
            }
            if (world.func_147439_a(x - 1, y, z - 1) == this && !li.contains(6) && !li.contains(8)) {
                li.remove(9);
            }
            if (world.func_147439_a(x + 1, y, z - 1) == this && !li.contains(4) && !li.contains(8)) {
                li.remove(7);
            }
            if (world.func_147439_a(x - 1, y, z + 1) == this && !li.contains(2) && !li.contains(6)) {
                li.remove(3);
            }
        }
        if (face.offsetZ != 0) {
            if (world.func_147439_a(x, y + 1, z) == this || ChromaTiles.getTile(world, x, y + 1, z) == ChromaTiles.TANK) {
                li.remove(4);
            }
            if (world.func_147439_a(x, y - 1, z) == this || ChromaTiles.getTile(world, x, y - 1, z) == ChromaTiles.TANK) {
                li.remove(6);
            }
            if (world.func_147439_a(x + 1, y, z) == this || ChromaTiles.getTile(world, x + 1, y, z) == ChromaTiles.TANK) {
                li.remove(2);
            }
            if (world.func_147439_a(x - 1, y, z) == this || ChromaTiles.getTile(world, x - 1, y, z) == ChromaTiles.TANK) {
                li.remove(8);
            }
            if (world.func_147439_a(x + 1, y + 1, z) == this && !li.contains(2) && !li.contains(4)) {
                li.remove(1);
            }
            if (world.func_147439_a(x - 1, y - 1, z) == this && !li.contains(8) && !li.contains(6)) {
                li.remove(9);
            }
            if (world.func_147439_a(x + 1, y - 1, z) == this && !li.contains(2) && !li.contains(6)) {
                li.remove(3);
            }
            if (world.func_147439_a(x - 1, y + 1, z) == this && !li.contains(4) && !li.contains(8)) {
                li.remove(7);
            }
        }
        if (!(li.contains(2) || li.contains(4) || li.contains(6) || li.contains(8) || (x + z) % 2 == 0)) {
            li.remove(5);
        }
        return li;
    }

    public IIcon getIconForEdge(IBlockAccess world, int x, int y, int z, int edge) {
        return this.edges[edge];
    }

    public IIcon getIconForEdge(int itemMeta, int edge) {
        return this.edges[edge];
    }

    public boolean renderCentralTextureForItem(int meta) {
        return false;
    }

    public int func_149709_b(IBlockAccess iba, int x, int y, int z, int par5) {
        CrystalTankAuxTile te = (CrystalTankAuxTile)iba.func_147438_o(x, y, z);
        TileEntityCrystalTank te2 = te.getTankController();
        return te2 != null && te2.getCurrentFluid() == FluidRegistry.getFluid((String)"redstone") ? (int)Math.round(te2.getFillPercentage() * 15.0) : 0;
    }

    public final boolean func_149740_M() {
        return true;
    }

    public final int func_149736_g(World world, int x, int y, int z, int par5) {
        CrystalTankAuxTile te = (CrystalTankAuxTile)world.func_147438_o(x, y, z);
        TileEntityCrystalTank con = te.getTankController();
        return con != null ? con.getRedstoneOverride() : 0;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    public static class CrystalTankAuxTile
    extends TileEntity
    implements CrystalTank {
        private boolean isLit;
        private Coordinate controller = null;

        public boolean canUpdate() {
            return false;
        }

        public int getLightValue() {
            if (this.isLit) {
                return 15;
            }
            TileEntityCrystalTank te = this.getTankController();
            return te != null && te.getCurrentFluid() != null ? te.getCurrentFluid().getLuminosity() : 0;
        }

        public void setTile(TileEntityCrystalTank te) {
            this.controller = new Coordinate((TileEntity)te);
        }

        public void addToTank() {
            TileEntityCrystalTank te = this.getTankController();
            if (te != null) {
                te.addCoordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getBaseMetadata());
            }
        }

        public void removeFromTank() {
            this.removeFromTank(this.getBaseMetadata());
        }

        public void removeFromTank(int oldmeta) {
            TileEntityCrystalTank te = this.getTankController();
            if (te != null) {
                te.removeCoordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e, oldmeta - oldmeta % 2);
            }
            this.reset();
        }

        public void markComplete() {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getBaseMetadata() + 1, 3);
        }

        public void reset() {
            this.controller = null;
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getBaseMetadata(), 3);
        }

        public int getBaseMetadata() {
            return this.func_145832_p() - this.func_145832_p() % 2;
        }

        public int func_145832_p() {
            return this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public boolean hasTile() {
            return this.controller != null && this.getTankController() != null;
        }

        public TileEntityCrystalTank getTankController() {
            if (this.controller == null) {
                return null;
            }
            TileEntity te = this.controller.getTileEntity((IBlockAccess)this.field_145850_b);
            return te instanceof TileEntityCrystalTank ? (TileEntityCrystalTank)te : null;
        }

        public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
            TileEntityCrystalTank te = this.getTankController();
            return te != null ? te.fill(from, resource, doFill) : 0;
        }

        public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
            TileEntityCrystalTank te = this.getTankController();
            return te != null ? te.drain(from, resource, doDrain) : null;
        }

        public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
            TileEntityCrystalTank te = this.getTankController();
            return te != null ? te.drain(from, maxDrain, doDrain) : null;
        }

        public boolean canFill(ForgeDirection from, Fluid fluid) {
            TileEntityCrystalTank te = this.getTankController();
            return te != null && te.canFill(from, fluid);
        }

        public boolean canDrain(ForgeDirection from, Fluid fluid) {
            TileEntityCrystalTank te = this.getTankController();
            return te != null && te.canDrain(from, fluid);
        }

        public FluidTankInfo[] getTankInfo(ForgeDirection from) {
            TileEntityCrystalTank te = this.getTankController();
            return te != null ? te.getTankInfo(from) : new FluidTankInfo[]{};
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            if (this.controller != null) {
                NBT.func_74768_a("tx", this.controller.xCoord);
                NBT.func_74768_a("ty", this.controller.yCoord);
                NBT.func_74768_a("tz", this.controller.zCoord);
                this.controller.writeToNBT("controller", NBT);
            }
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            if (NBT.func_74764_b("controller")) {
                this.controller = Coordinate.readFromNBT((String)"controller", (NBTTagCompound)NBT);
            } else if (NBT.func_74764_b("tx")) {
                int x = NBT.func_74762_e("tx");
                int y = NBT.func_74762_e("ty");
                int z = NBT.func_74762_e("tz");
                this.controller = new Coordinate(x, y, z);
            }
        }

        public Packet func_145844_m() {
            NBTTagCompound NBT = new NBTTagCompound();
            this.func_145841_b(NBT);
            S35PacketUpdateTileEntity pack = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, NBT);
            return pack;
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity p) {
            this.func_145839_a(p.field_148860_e);
        }

        public void setFlags(ItemStack is) {
            if (is.field_77990_d == null) {
                return;
            }
            this.isLit = is.field_77990_d.func_74767_n("lit");
        }

        @Override
        public CrystalTank getController() {
            TileEntity te = this.controller != null ? this.controller.getTileEntity((IBlockAccess)this.field_145850_b) : null;
            return te instanceof CrystalTank ? (CrystalTank)te : null;
        }

        @Override
        public boolean isController() {
            return false;
        }

        @Override
        public Fluid getCurrentFluid() {
            return null;
        }

        @Override
        public int getCurrentFluidLevel() {
            return 0;
        }

        @Override
        public int getCapacity() {
            return 0;
        }

        @Override
        public int addFluid(Fluid f, int amt) {
            return 0;
        }
    }
}

