/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.Base.CrystalTypeBlock;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockEncrustedCrystal
extends CrystalTypeBlock {
    public static IIcon basicIcon;
    public static IIcon specialIcon;

    public BlockEncrustedCrystal(Material mat) {
        super(mat);
        if (DragonAPICore.isReikasComputer()) {
            this.func_149647_a((CreativeTabs)ChromatiCraft.tabChromaGen);
        } else {
            this.func_149647_a(null);
        }
        this.func_149711_c(0.6f);
        this.func_149752_b(5.0f);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase e, ItemStack is) {
        super.func_149689_a(world, x, y, z, e, is);
        TileCrystalEncrusted te = (TileCrystalEncrusted)world.func_147438_o(x, y, z);
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            if (!CrystalGrowth.canExist(world, x, y, z, dir)) continue;
            te.addGrowth(dir, 1 + world.field_73012_v.nextInt(8));
        }
        te.markReady();
        te.updateSides(world, x, y, z);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        TileCrystalEncrusted te = (TileCrystalEncrusted)world.func_147438_o(x, y, z);
        te.markReady();
        te.grow(world, x, y, z);
        te.updateSides(world, x, y, z);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileCrystalEncrusted();
    }

    @Override
    public int getBrightness(IBlockAccess iba, int x, int y, int z) {
        return 0;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        ChromaISBRH.encrusted.setRenderPass(pass);
        return pass <= 1;
    }

    public final int func_149645_b() {
        return ChromaISBRH.encrusted.getRenderID();
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        TileCrystalEncrusted te = (TileCrystalEncrusted)world.func_147438_o(x, y, z);
        te.updateSides(world, x, y, z);
    }

    public void func_149651_a(IIconRegister ico) {
        basicIcon = ico.func_94245_a("chromaticraft:crystal/encrusted");
        specialIcon = ico.func_94245_a("chromaticraft:crystal/encrusted_special");
    }

    public IIcon func_149691_a(int s, int meta) {
        return basicIcon;
    }

    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int side) {
        TileEntity te = iba.func_147438_o(x, y, z);
        if (te instanceof TileCrystalEncrusted) {
            TileCrystalEncrusted tile = (TileCrystalEncrusted)te;
            return tile.isSpecial() ? specialIcon : basicIcon;
        }
        return basicIcon;
    }

    public final boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean harvest) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.func_149636_a(world, player, x, y, z, world.func_72805_g(x, y, z));
        }
        return world.func_147468_f(x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileCrystalEncrusted te = (TileCrystalEncrusted)world.func_147438_o(x, y, z);
        if (te != null) {
            for (CrystalGrowth g : te.getGrowths()) {
                ret.add(g.getDrop(world.field_73012_v));
            }
        }
        return ret;
    }

    public final boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    public void func_149719_a(IBlockAccess iba, int x, int y, int z) {
        super.func_149719_a(iba, x, y, z);
        TileEntity te = iba.func_147438_o(x, y, z);
        if (te instanceof TileCrystalEncrusted) {
            TileCrystalEncrusted tile = (TileCrystalEncrusted)te;
            HashSet<ForgeDirection> set = tile.getSides();
            float x1 = 0.5f;
            float x2 = 0.5f;
            float y1 = 0.5f;
            float y2 = 0.5f;
            float z1 = 0.5f;
            float z2 = 0.5f;
            if (set.contains(ForgeDirection.UP) || set.contains(ForgeDirection.DOWN)) {
                x1 = 0.0f;
                x2 = 1.0f;
                z1 = 0.0f;
                z2 = 1.0f;
            }
            if (set.contains(ForgeDirection.EAST) || set.contains(ForgeDirection.WEST)) {
                y1 = 0.0f;
                y2 = 1.0f;
                z1 = 0.0f;
                z2 = 1.0f;
            }
            if (set.contains(ForgeDirection.NORTH) || set.contains(ForgeDirection.SOUTH)) {
                x1 = 0.0f;
                x2 = 1.0f;
                y1 = 0.0f;
                y2 = 1.0f;
            }
            if (set.contains(ForgeDirection.UP)) {
                y2 = 1.0f;
            }
            if (set.contains(ForgeDirection.DOWN)) {
                y1 = 0.0f;
            }
            if (set.contains(ForgeDirection.EAST)) {
                x2 = 1.0f;
            }
            if (set.contains(ForgeDirection.WEST)) {
                x1 = 0.0f;
            }
            if (set.contains(ForgeDirection.SOUTH)) {
                z2 = 1.0f;
            }
            if (set.contains(ForgeDirection.NORTH)) {
                z1 = 0.0f;
            }
            this.func_149676_a(x1, y1, z1, x2, y2, z2);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static void setColor(World world, int x, int y, int z, CrystalElement e) {
        world.func_72921_c(x, y, z, e.ordinal(), 3);
        TileCrystalEncrusted te = (TileCrystalEncrusted)world.func_147438_o(x, y, z);
        te.setColor(e);
    }

    public static class CrystalGrowth {
        public final ForgeDirection side;
        public final CrystalElement color;
        public final boolean special;
        private int growthStage;

        private CrystalGrowth(CrystalElement e, ForgeDirection dir, boolean sp) {
            this.side = dir;
            this.color = e;
            this.special = sp;
        }

        public CrystalGrowth getWithColor(CrystalElement e) {
            CrystalGrowth gr = new CrystalGrowth(e, this.side, this.special);
            gr.growthStage = this.growthStage;
            return gr;
        }

        private void setGrowth(World world, int x, int y, int z, int amt) {
            this.growthStage = Math.min(amt, this.getMaxGrowth(world, x, y, z));
        }

        public boolean grow(World world, int x, int y, int z) {
            if (this.growthStage < this.getMaxGrowth(world, x, y, z)) {
                ++this.growthStage;
                world.func_147471_g(x, y, z);
                return true;
            }
            return false;
        }

        private int getMaxGrowth(World world, int x, int y, int z) {
            return 6;
        }

        public ItemStack getDrop(Random rand) {
            int amt = Math.max(1 + this.growthStage, rand.nextInt(this.growthStage * 2 + 1));
            return ReikaItemHelper.getSizedItemStack((ItemStack)ChromaItems.SHARD.getStackOf(this.color), (int)amt);
        }

        public static boolean canExist(World world, int x, int y, int z, ForgeDirection side) {
            int dx = x + side.offsetX;
            int dy = y + side.offsetY;
            int dz = z + side.offsetZ;
            Block b = world.func_147439_a(dx, dy, dz);
            return b == ChromaBlocks.STRUCTSHIELD.getBlockInstance() || b.isSideSolid((IBlockAccess)world, dx, dy, dz, side.getOpposite());
        }

        private void writeToNBT(NBTTagCompound NBT) {
            NBT.func_74768_a("grow", this.growthStage);
            NBT.func_74757_a("special", this.special);
            NBT.func_74768_a("dir", this.side != null ? this.side.ordinal() : -1);
            NBT.func_74768_a("color", this.color.ordinal());
        }

        private static CrystalGrowth readFromNBT(NBTTagCompound NBT) {
            int dir = NBT.func_74762_e("dir");
            int elem = NBT.func_74762_e("color");
            ForgeDirection face = dir >= 0 ? ForgeDirection.VALID_DIRECTIONS[dir] : null;
            CrystalGrowth g = new CrystalGrowth(CrystalElement.elements[elem], face, NBT.func_74767_n("special"));
            g.growthStage = NBT.func_74762_e("grow");
            return g;
        }

        public int getGrowth() {
            return this.growthStage;
        }
    }

    public static class TileCrystalEncrusted
    extends TileEntity {
        private CrystalGrowth[] sides = new CrystalGrowth[6];
        private boolean isSpecial;
        private boolean isReadyToUpdate;

        public boolean canUpdate() {
            return false;
        }

        public void setColor(CrystalElement e) {
            for (int i = 0; i < this.sides.length; ++i) {
                if (this.sides[i] == null) continue;
                this.sides[i] = this.sides[i].getWithColor(e);
            }
        }

        public void markReady() {
            this.isReadyToUpdate = true;
        }

        public void makeSpecial() {
            this.isSpecial = true;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public boolean isSpecial() {
            return this.isSpecial;
        }

        public boolean grow(World world, int x, int y, int z) {
            CrystalGrowth g;
            int i;
            CrystalTypeBlock.ding(world, x, y, z);
            if (world.field_73012_v.nextInt(4) > 0) {
                for (i = 0; i < 6; ++i) {
                    g = this.sides[i];
                    if (g == null || !g.grow(world, x, y, z)) continue;
                    return true;
                }
            }
            for (i = 0; i < 6; ++i) {
                ForgeDirection dir;
                g = this.sides[i];
                if (g != null || !CrystalGrowth.canExist(world, x, y, z, dir = ForgeDirection.VALID_DIRECTIONS[i])) continue;
                this.addGrowth(dir);
                return true;
            }
            return false;
        }

        public void updateSides(World world, int x, int y, int z) {
            if (!this.isReadyToUpdate) {
                return;
            }
            for (int i = 0; i < 6; ++i) {
                CrystalGrowth g = this.sides[i];
                if (g == null) continue;
                if (CrystalGrowth.canExist(world, x, y, z, ForgeDirection.VALID_DIRECTIONS[i])) continue;
                ItemStack drop = g.getDrop(world.field_73012_v);
                ReikaItemHelper.dropItem((World)world, (double)((double)x + world.field_73012_v.nextDouble()), (double)((double)y + world.field_73012_v.nextDouble()), (double)((double)z + world.field_73012_v.nextDouble()), (ItemStack)drop);
                this.sides[i] = null;
            }
            if (this.getGrowths().isEmpty()) {
                world.func_147468_f(x, y, z);
            }
            world.func_147471_g(x, y, z);
        }

        public void addGrowth(ForgeDirection dir) {
            this.addGrowth(dir, 0);
        }

        public void addGrowth(ForgeDirection dir, int amt) {
            this.sides[dir.ordinal()] = new CrystalGrowth(this.getColor(), dir, this.isSpecial);
            this.sides[dir.ordinal()].setGrowth(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, amt);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public CrystalElement getColor() {
            return CrystalElement.elements[this.func_145832_p()];
        }

        public CrystalElement getInternalColor() {
            return CrystalElement.elements[this.func_145832_p()];
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            for (int i = 0; i < 6; ++i) {
                CrystalGrowth g = this.sides[i];
                if (g == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                g.writeToNBT(tag);
                NBT.func_74782_a("side_" + i, (NBTBase)tag);
            }
            NBT.func_74757_a("special", this.isSpecial);
            NBT.func_74757_a("ready", this.isReadyToUpdate);
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            for (int i = 0; i < 6; ++i) {
                this.sides[i] = null;
                if (!NBT.func_74764_b("side_" + i)) continue;
                NBTTagCompound tag = NBT.func_74775_l("side_" + i);
                this.sides[i] = CrystalGrowth.readFromNBT(tag);
            }
            this.isSpecial = NBT.func_74767_n("special");
            this.isReadyToUpdate = NBT.func_74767_n("ready");
        }

        public Packet func_145844_m() {
            NBTTagCompound NBT = new NBTTagCompound();
            this.func_145841_b(NBT);
            S35PacketUpdateTileEntity pack = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, NBT);
            return pack;
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity p) {
            this.func_145839_a(p.field_148860_e);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public HashSet<ForgeDirection> getSides() {
            HashSet<ForgeDirection> set = new HashSet<ForgeDirection>();
            for (int i = 0; i < 6; ++i) {
                if (this.sides[i] == null) continue;
                set.add(ForgeDirection.VALID_DIRECTIONS[i]);
            }
            return set;
        }

        public Collection<CrystalGrowth> getGrowths() {
            ArrayList<CrystalGrowth> li = new ArrayList<CrystalGrowth>();
            for (int i = 0; i < 6; ++i) {
                if (this.sides[i] == null) continue;
                li.add(this.sides[i]);
            }
            return li;
        }
    }
}

