/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.Auxiliary.GuardianStoneManager;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.FlyingBlocksExplosion;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class BlockEnderTNT
extends Block {
    private IIcon top;
    private IIcon side;
    private IIcon bottom;
    private IIcon active;

    public BlockEnderTNT(Material mat) {
        super(mat);
        this.field_149782_v = 1.0f;
        this.field_149781_w = 5.0f;
        this.field_149762_H = field_149769_e;
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChroma);
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityEnderTNT();
    }

    public IIcon func_149691_a(int s, int meta) {
        switch (s) {
            case 0: {
                return this.bottom;
            }
            case 1: {
                return this.top;
            }
        }
        return meta > 0 ? this.active : this.side;
    }

    public void func_149651_a(IIconRegister ico) {
        this.side = ico.func_94245_a("chromaticraft:basic/enderbomb_side");
        this.top = ico.func_94245_a("chromaticraft:basic/enderbomb_top");
        this.bottom = ico.func_94245_a("chromaticraft:basic/enderbomb_bottom");
        this.active = ico.func_94245_a("chromaticraft:basic/enderbomb_active");
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        if (ep.func_71045_bC() != null && ep.func_71045_bC().func_77973_b() == Items.field_151033_d) {
            ((TileEntityEnderTNT)world.func_147438_o(x, y, z)).prime(100);
        } else {
            ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.TILE.ordinal(), world, x, y, z);
        }
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityEnderTNT) {
            ((TileEntityEnderTNT)te).testDetonation();
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityEnderTNT) {
            ((TileEntityEnderTNT)te).testDetonation();
        }
    }

    public static class TileEntityEnderTNT
    extends TileEntity
    implements GuiController {
        private WorldLocation target = null;
        private int countdown = -1;
        private int existed = 0;
        private String owner = null;
        private int fuse;

        public void testDetonation() {
            if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.prime(200);
            }
        }

        public void prime(int delay) {
            if (this.target != null && this.owner != null) {
                this.countdown = this.fuse = delay;
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 3);
                ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"game.tnt.primed");
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }

        public void func_145845_h() {
            if (this.existed == 0) {
                if (this.target == null) {
                    this.target = new WorldLocation((TileEntity)this);
                }
                this.testDetonation();
            }
            ++this.existed;
            if (this.countdown == 0) {
                this.detonate();
            } else if (this.countdown > 0) {
                --this.countdown;
            }
            if (this.countdown > 0) {
                ReikaParticleHelper.SMOKE.spawnAt(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5);
                if (this.countdown % 10 == 0 || this.countdown <= this.fuse * 2 / 5 && this.countdown % 5 == 0 || this.countdown <= this.fuse / 10) {
                    float p = this.countdown <= this.fuse / 10 ? 1.5f : (this.countdown < this.fuse * 2 / 5 ? 1.25f : (this.countdown % 20 == 0 ? 1.0f : 1.25f));
                    ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"random.click", (float)1.0f, (float)p);
                }
            }
        }

        private void detonate() {
            if (this.target != null && this.target.getWorld() != null && !this.target.getWorld().field_72995_K) {
                World w = this.target.dimensionID == this.field_145850_b.field_73011_w.field_76574_g ? this.field_145850_b : this.target.getWorld();
                new FlyingBlocksExplosion(w, (double)this.target.xCoord + 0.5, (double)this.target.yCoord + 0.5, (double)this.target.zCoord + 0.5, 4.0f).doExplosion();
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_72876_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 4.0f, true);
                }
                String s = this.owner + " has just detonated Ender TNT at " + this.target;
                ChromatiCraft.logger.log((Object)s);
                ReikaPlayerAPI.notifyAdmins((String)s);
            }
        }

        public void setTarget(EntityPlayer ep, int dim, int x, int y, int z) {
            WorldServer ws = DimensionManager.getWorld((int)dim);
            if (ep instanceof EntityPlayerMP && ws != null && GuardianStoneManager.instance.doesPlayerHavePermissions((World)ws, x, y, z, ep)) {
                this.target = new WorldLocation(dim, x, y, z);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.owner = ep.func_70005_c_();
            }
        }

        public int getCountdown() {
            return this.countdown;
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBT.func_74768_a("tick", this.countdown);
            if (this.target != null) {
                this.target.writeToNBT("loc", NBT);
            }
            if (this.owner != null && !this.owner.isEmpty()) {
                NBT.func_74778_a("owner", this.owner);
            }
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.target = WorldLocation.readFromNBT((String)"loc", (NBTTagCompound)NBT);
            this.countdown = NBT.func_74762_e("tick");
            this.owner = NBT.func_74779_i("owner");
        }

        public Packet func_145844_m() {
            NBTTagCompound NBT = new NBTTagCompound();
            this.func_145841_b(NBT);
            S35PacketUpdateTileEntity pack = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, NBT);
            return pack;
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity p) {
            this.func_145839_a(p.field_148860_e);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public WorldLocation getTarget() {
            return this.target;
        }
    }
}

