/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class BlockFakeSky
extends Block {
    private static final SkyCache skyCache = new SkyCache();

    public BlockFakeSky(Material mat) {
        super(mat);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChroma);
        this.func_149711_c(0.5f);
        this.func_149713_g(0);
        this.func_149752_b(600000.0f);
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ico.func_94245_a("chromaticraft:blank");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null && mc.field_71439_g != null) {
            return ReikaColorAPI.fromVec3((Vec3)mc.field_71441_e.func_72833_a((Entity)mc.field_71439_g, ReikaRenderHelper.getPartialTickTime()));
        }
        return 5624063;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess iba, int x, int y, int z) {
        return this.func_149741_i(iba.func_72805_g(x, y, z));
    }

    public boolean hasTileEntity(int meta) {
        return meta == 1;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return meta == 1 ? new TileEntityFakeSkyController() : null;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase e, ItemStack is) {
        world.func_72921_c(x, y, z, 1, 3);
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldb, int oldmeta) {
        super.func_149749_a(world, x, y, z, oldb, oldmeta);
        BlockFakeSky.skyCache.remove(new WorldLocation(world, x, y, z));
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            BlockArray arr = new BlockArray();
            arr.recursiveAddWithBounds((IBlockAccess)world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, (Block)this, x - 64, y - 12, z - 64, x + 64, y + 12, z + 64);
            for (Coordinate c : arr.keySet()) {
                c.setBlockMetadata(world, 0);
            }
            if (arr.isEmpty()) continue;
            arr.getNthBlock(0).setBlockMetadata(world, 1);
        }
        world.func_72975_g(x, z, 0, y);
    }

    public static void updateColumn(World world, int x, int y, int z) {
        skyCache.updateColumn(world, x, y, z);
    }

    public static boolean isForcedSky(World world, int x, int y, int z) {
        return skyCache.isForcedSky(world, x, y, z);
    }

    public static void clearCache() {
        skyCache.data.clear();
        skyCache.skySections.clear();
    }

    @SideOnly(value=Side.CLIENT)
    public static void doSkyRendering() {
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        Collection c = BlockFakeSky.skyCache.getSkySections(ep.field_70170_p);
        if (c != null) {
            GL11.glPushAttrib((int)1048575);
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3553);
            ReikaRenderHelper.disableEntityLighting();
            GL11.glTranslated((double)(-RenderManager.field_78725_b), (double)(-RenderManager.field_78726_c), (double)(-RenderManager.field_78723_d));
            Vec3 clr = ep.field_70170_p.func_72833_a((Entity)ep, ReikaRenderHelper.getPartialTickTime());
            Tessellator v5 = Tessellator.field_78398_a;
            v5.func_78382_b();
            v5.func_78386_a((float)clr.field_72450_a, (float)clr.field_72448_b, (float)clr.field_72449_c);
            double o = 0.0075;
            for (BlockArray arr : c) {
                v5.func_78377_a((double)arr.getMinX() - o, (double)arr.getMinY() - o, (double)arr.getMinZ() - o);
                v5.func_78377_a((double)(arr.getMaxX() + 1) + o, (double)arr.getMinY() - o, (double)arr.getMinZ() - o);
                v5.func_78377_a((double)(arr.getMaxX() + 1) + o, (double)arr.getMinY() - o, (double)(arr.getMaxZ() + 1) + o);
                v5.func_78377_a((double)arr.getMinX() - o, (double)arr.getMinY() - o, (double)(arr.getMaxZ() + 1) + o);
                v5.func_78377_a((double)arr.getMinX() - o, (double)(arr.getMaxY() + 1) + o, (double)(arr.getMaxZ() + 1) + o);
                v5.func_78377_a((double)(arr.getMaxX() + 1) + o, (double)(arr.getMaxY() + 1) + o, (double)(arr.getMaxZ() + 1) + o);
                v5.func_78377_a((double)(arr.getMaxX() + 1) + o, (double)(arr.getMaxY() + 1) + o, (double)arr.getMinZ() - o);
                v5.func_78377_a((double)arr.getMinX() - o, (double)(arr.getMaxY() + 1) + o, (double)arr.getMinZ() - o);
                v5.func_78377_a((double)arr.getMinX() - o, (double)arr.getMinY() - o, (double)(arr.getMaxZ() + 1) + o);
                v5.func_78377_a((double)arr.getMinX() - o, (double)(arr.getMaxY() + 1) + o, (double)(arr.getMaxZ() + 1) + o);
                v5.func_78377_a((double)arr.getMinX() - o, (double)(arr.getMaxY() + 1) + o, (double)arr.getMinZ() - o);
                v5.func_78377_a((double)arr.getMinX() - o, (double)arr.getMinY() - o, (double)arr.getMinZ() - o);
                v5.func_78377_a((double)(arr.getMaxX() + 1) + o, (double)arr.getMinY() - o, (double)arr.getMinZ() - o);
                v5.func_78377_a((double)(arr.getMaxX() + 1) + o, (double)(arr.getMaxY() + 1) + o, (double)arr.getMinZ() - o);
                v5.func_78377_a((double)(arr.getMaxX() + 1) + o, (double)(arr.getMaxY() + 1) + o, (double)(arr.getMaxZ() + 1) + o);
                v5.func_78377_a((double)(arr.getMaxX() + 1) + o, (double)arr.getMinY() - o, (double)(arr.getMaxZ() + 1) + o);
                v5.func_78377_a((double)arr.getMinX() - o, (double)(arr.getMaxY() + 1) + o, (double)arr.getMinZ() - o);
                v5.func_78377_a((double)(arr.getMaxX() + 1) + o, (double)(arr.getMaxY() + 1) + o, (double)arr.getMinZ() - o);
                v5.func_78377_a((double)(arr.getMaxX() + 1) + o, (double)arr.getMinY() - o, (double)arr.getMinZ() - o);
                v5.func_78377_a((double)arr.getMinX() - o, (double)arr.getMinY() - o, (double)arr.getMinZ() - o);
                v5.func_78377_a((double)arr.getMinX() - o, (double)arr.getMinY() - o, (double)(arr.getMaxZ() + 1) + o);
                v5.func_78377_a((double)(arr.getMaxX() + 1) + o, (double)arr.getMinY() - o, (double)(arr.getMaxZ() + 1) + o);
                v5.func_78377_a((double)(arr.getMaxX() + 1) + o, (double)(arr.getMaxY() + 1) + o, (double)(arr.getMaxZ() + 1) + o);
                v5.func_78377_a((double)arr.getMinX() - o, (double)(arr.getMaxY() + 1) + o, (double)(arr.getMaxZ() + 1) + o);
            }
            v5.func_78381_a();
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        }
    }

    private static class SkyShunt {
        private final int dimensionID;
        private final Coordinate skyBlock;
        private int minY;

        private SkyShunt(Coordinate c, World world) {
            this.skyBlock = c;
            this.dimensionID = world.field_73011_w.field_76574_g;
            this.calcMinY(world);
        }

        public boolean includesY(int y) {
            return y >= this.minY && y < this.skyBlock.yCoord;
        }

        private void calcMinY(World world) {
            int y = this.skyBlock.yCoord - 1;
            while (world.func_147439_a(this.skyBlock.xCoord, y, this.skyBlock.zCoord).getLightOpacity((IBlockAccess)world, this.skyBlock.xCoord, y, this.skyBlock.zCoord) == 0) {
                --y;
            }
            this.minY = y + 1;
        }

        private void update(World world) {
            this.calcMinY(world);
        }

        public int hashCode() {
            return this.skyBlock.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof SkyShunt && ((SkyShunt)o).skyBlock.equals((Object)this.skyBlock);
        }
    }

    private static class SkyCache {
        private final MultiMap<WorldLocation, SkyShunt> data = new MultiMap().setNullEmpty();
        private MultiMap<Integer, BlockArray> skySections = new MultiMap().setNullEmpty();

        private SkyCache() {
        }

        public boolean isForcedSky(World world, int x, int y, int z) {
            WorldLocation c = new WorldLocation(world, x, 0, z);
            Collection li = this.data.get((Object)c);
            if (li == null) {
                return false;
            }
            for (SkyShunt s : li) {
                if (!s.includesY(y)) continue;
                return true;
            }
            return false;
        }

        public void updateColumn(World world, int x, int y, int z) {
            WorldLocation c = new WorldLocation(world, x, 0, z);
            Collection li = this.data.get((Object)c);
            if (li == null) {
                return;
            }
            for (SkyShunt s : li) {
                if (!s.includesY(y)) continue;
                s.update(world);
            }
        }

        private void remove(WorldLocation c) {
            Collection li = this.data.get((Object)c.to2D());
            if (li != null) {
                Iterator it = li.iterator();
                while (it.hasNext()) {
                    SkyShunt s = (SkyShunt)it.next();
                    if (!s.skyBlock.equals((Object)new Coordinate(c))) continue;
                    it.remove();
                    break;
                }
                if (li.isEmpty()) {
                    this.data.remove((Object)c.to2D());
                }
            }
            this.recalcBlocks();
        }

        private void add(Coordinate c, World world) {
            this.data.addValue((Object)new WorldLocation(world, c.to2D()), (Object)new SkyShunt(c, world));
            this.recalcBlocks();
        }

        private void recalcBlocks() {
            MultiMap replSky = new MultiMap().setNullEmpty();
            HashSet<WorldLocation> set = new HashSet<WorldLocation>();
            for (Collection c : this.data.values()) {
                for (SkyShunt s : c) {
                    set.add(new WorldLocation(s.dimensionID, s.skyBlock));
                }
            }
            while (!set.isEmpty()) {
                WorldLocation c = (WorldLocation)ReikaJavaLibrary.getRandomCollectionEntry((Random)DragonAPICore.rand, set);
                BlockArray arr = new BlockArray();
                arr.recursiveAdd((IBlockAccess)new CacheAccess(c.dimensionID, set), c.xCoord, c.yCoord, c.zCoord, ChromaBlocks.FAKESKY.getBlockInstance());
                for (Coordinate loc : arr.keySet()) {
                    set.remove(new WorldLocation(c.dimensionID, loc));
                }
                for (BlockArray arr2 : arr.splitToRectangles()) {
                    replSky.addValue((Object)c.dimensionID, (Object)arr2);
                }
            }
            this.skySections = replSky;
        }

        private Collection<BlockArray> getSkySections(World world) {
            return this.skySections.get((Object)world.field_73011_w.field_76574_g);
        }

        private class CacheAccess
        implements IBlockAccess {
            private final int dimensionID;
            private HashSet<WorldLocation> set;

            private CacheAccess(int dim, HashSet<WorldLocation> set) {
                this.dimensionID = dim;
                this.set = set;
            }

            public Block func_147439_a(int x, int y, int z) {
                return this.set.contains(new WorldLocation(this.dimensionID, x, y, z)) ? ChromaBlocks.FAKESKY.getBlockInstance() : Blocks.field_150350_a;
            }

            public TileEntity func_147438_o(int x, int y, int z) {
                return null;
            }

            @SideOnly(value=Side.CLIENT)
            public int func_72802_i(int x, int y, int z, int l) {
                return 0;
            }

            public int func_72805_g(int x, int y, int z) {
                return 0;
            }

            public int func_72879_k(int x, int y, int z, int s) {
                return 0;
            }

            public boolean func_147437_c(int x, int y, int z) {
                return false;
            }

            @SideOnly(value=Side.CLIENT)
            public BiomeGenBase func_72807_a(int x, int z) {
                return BiomeGenBase.field_76771_b;
            }

            @SideOnly(value=Side.CLIENT)
            public int func_72800_K() {
                return 0;
            }

            @SideOnly(value=Side.CLIENT)
            public boolean func_72806_N() {
                return false;
            }

            public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
                return false;
            }
        }
    }

    public static class TileEntityFakeSkyController
    extends TileEntity {
        private boolean cached = false;

        public void func_145845_h() {
            if (!this.cached) {
                this.addToCache();
                this.cached = true;
            }
        }

        private void addToCache() {
            BlockArray arr = new BlockArray();
            arr.recursiveAddWithBounds((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), this.field_145851_c - 64, this.field_145848_d - 12, this.field_145849_e - 64, this.field_145851_c + 64, this.field_145848_d + 12, this.field_145849_e + 64);
            for (Coordinate c : arr.keySet()) {
                if (!c.equals(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                    c.setBlockMetadata(this.field_145850_b, 0);
                }
                skyCache.add(c, this.field_145850_b);
            }
        }
    }
}

