/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.Auxiliary.Interfaces.SidedBlock;
import Reika.ChromatiCraft.Base.BlockAttachableMini;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredOre;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityLaserFX;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Interfaces.TileEntity.ThermalTile;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.MultiblockControllerFinder;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.TinkerSmelteryHandler;
import Reika.DragonAPI.ModInteract.Power.ReikaRailCraftHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import Reika.ReactorCraft.Auxiliary.ReactorCoreTE;
import Reika.RotaryCraft.API.Interfaces.BasicTemperatureMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.tile.IHeatSource;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tuhljin.automagy.api.essentia.IEssentiaDistillery;

public class BlockHeatLamp
extends BlockAttachableMini {
    private IIcon coldIcon;

    public BlockHeatLamp(Material mat) {
        super(mat);
    }

    public void func_149666_a(Item item, CreativeTabs c, List li) {
        li.add(ChromaBlocks.HEATLAMP.getStackOfMetadata(0));
        li.add(ChromaBlocks.HEATLAMP.getStackOfMetadata(8));
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ((BlockTieredOre)ChromaBlocks.TIEREDORE.getBlockInstance()).getGeodeIcon(6);
        this.coldIcon = ico.func_94245_a("chromaticraft:coldlamp");
    }

    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        return BlockHeatLamp.isCold(iba, x, y, z) ? this.coldIcon : super.func_149673_e(iba, x, y, z, s);
    }

    public IIcon func_149691_a(int s, int meta) {
        return meta >= 8 ? this.coldIcon : this.field_149761_L;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void createFX(World world, int x, int y, int z, double dx, double dy, double dz, Random r) {
        CrystalElement e = BlockHeatLamp.isCold((IBlockAccess)world, x, y, z) ? CrystalElement.WHITE : CrystalElement.ORANGE;
        EntityFX fx = new EntityCenterBlurFX(e, world, dx, dy, dz, 0.0, 0.0, 0.0).setScale(2.0f + r.nextFloat() * 2.0f);
        if (r.nextInt(4) == 0) {
            fx = new EntityLaserFX(e, world, dx, dy, dz, 0.0, 0.0, 0.0).setScale(2.0f + r.nextFloat() * 2.0f);
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.TILE.ordinal(), world, x, y, z);
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityHeatLamp();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    @Override
    public int getColor(IBlockAccess iba, int x, int y, int z) {
        return BlockHeatLamp.isCold(iba, x, y, z) ? 9482495 : 0xFFAA00;
    }

    private static boolean isCold(IBlockAccess iba, int x, int y, int z) {
        return iba.func_72805_g(x, y, z) >= 8;
    }

    @APIStripper.Strippable(value={"ic2.api.energy.tile.IHeatSource"})
    public static class TileEntityHeatLamp
    extends TileEntity
    implements GuiController,
    IHeatSource {
        public int temperature;
        public static final int MAXTEMP = 615;
        public static final int MAXTEMP_COLD = 15;
        public static final int MINTEMP = 20;
        public static final int MINTEMP_COLD = -60;

        public boolean canUpdate() {
            return true;
        }

        public void func_145845_h() {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            this.temperature = Math.max(this.isCold() ? -60 : 20, Math.min(this.isCold() ? 15 : 615, this.temperature));
            ForgeDirection dir = ((BlockHeatLamp)this.func_145838_q()).getSide((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e).getOpposite();
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (te instanceof ThermalTile) {
                ThermalTile tl = (ThermalTile)te;
                if (this.canHeat(tl)) {
                    if (this.isCold() ? this.temperature < tl.getTemperature() : this.temperature > tl.getTemperature()) {
                        tl.setTemperature(tl.getTemperature() + (this.isCold() ? -1 : 1));
                        if (ModList.ROTARYCRAFT.isLoaded() && te instanceof BasicTemperatureMachine) {
                            ((BasicTemperatureMachine)te).resetAmbientTemperatureTimer();
                        }
                    }
                } else {
                    ((BlockHeatLamp)this.func_145838_q()).drop(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            } else if (!this.isCold() && te instanceof TileEntityFurnace) {
                TileEntityFurnace tf = (TileEntityFurnace)te;
                if (this.temperature >= 200) {
                    double c = Math.min(1.0, 1.25 * (double)this.temperature / 1000.0);
                    if (ReikaRandomHelper.doWithChance((double)c)) {
                        if (tf.field_145956_a == 0 && ReikaRandomHelper.doWithChance((double)c)) {
                            tf.field_145956_a = 20;
                        }
                        te.func_145845_h();
                    }
                } else {
                    tf.field_145961_j = this.temperature;
                    tf.field_145956_a = 2;
                }
            } else if (ModList.TINKERER.isLoaded() && !this.isCold() && TinkerSmelteryHandler.isSmelteryController((TileEntity)te)) {
                TinkerSmelteryHandler.SmelteryWrapper s = new TinkerSmelteryHandler.SmelteryWrapper(te);
                s.fuelLevel = 4000;
                s.meltPower = this.temperature * 1500 / 615;
                s.write(te);
            } else if (ModList.TINKERER.isLoaded() && this.isCold() && TinkerSmelteryHandler.isCastingBlock((TileEntity)te)) {
                int d;
                TinkerSmelteryHandler.CastingBlockWrapper s = new TinkerSmelteryHandler.CastingBlockWrapper(te);
                if (s.timer > 1 && (d = -this.temperature / 15) > 0) {
                    s.timer = Math.max(1, s.timer - d);
                }
                s.write(te);
            } else if (ModList.RAILCRAFT.isLoaded() && !this.isCold() && ReikaRailCraftHelper.isSolidFirebox((TileEntity)te)) {
                te = MultiblockControllerFinder.instance.getController(te);
                ReikaRailCraftHelper.FireboxWrapper s = new ReikaRailCraftHelper.FireboxWrapper(te);
                s.load(te);
                if (s.temperature < 99.0) {
                    s.setBurning(5);
                }
                s.write(te);
            } else if (ModList.THAUMCRAFT.isLoaded() && !this.isCold() && this.temperature >= 200 && ReikaThaumHelper.isAlchemicalFurnace((TileEntity)te)) {
                ReikaThaumHelper.setAlchemicalBurnTime((TileEntity)te, (int)(this.temperature / 50));
            } else if (ModList.THAUMCRAFT.isLoaded() && !this.isCold() && this.temperature >= 200 && ReikaThaumHelper.isAlchemicalFurnace((TileEntity)te)) {
                ReikaThaumHelper.setAlchemicalBurnTime((TileEntity)te, (int)(this.temperature / 50));
            } else if (Loader.isModLoaded((String)"Automagy") && !this.isCold() && this.temperature >= 200 && InterfaceCache.ESSENTIADISTILL.instanceOf((Object)te)) {
                this.setEssentiaDistillery(te);
            } else if (this.isCold() && ModList.IC2.isLoaded() && (InterfaceCache.IC2NUKE.instanceOf((Object)te) || InterfaceCache.IC2NUKECHAMBER.instanceOf((Object)te))) {
                this.setIC2Reactor(te);
            }
        }

        @DependentMethodStripper.ModDependent(value={ModList.IC2})
        private void setIC2Reactor(TileEntity te) {
            if (te instanceof IReactorChamber) {
                te = (TileEntity)((IReactorChamber)te).getReactor();
            }
            int rem = Math.max(0, -this.temperature / 10);
            ((IReactor)te).addHeat(-rem);
        }

        @DependentMethodStripper.ClassDependent(value="tuhljin.automagy.api.essentia.IEssentiaDistillery")
        private void setEssentiaDistillery(TileEntity te) {
            IEssentiaDistillery ied = (IEssentiaDistillery)te;
            ied.setFurnaceBurnTime(Math.max(ied.getFurnaceBurnTime(), this.temperature / 50));
        }

        private boolean isCold() {
            return BlockHeatLamp.isCold((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        private boolean canHeat(ThermalTile tl) {
            if (ModList.ROTARYCRAFT.isLoaded() && this.isRotaryHeatTile(tl)) {
                return false;
            }
            return !ModList.REACTORCRAFT.isLoaded() || !this.isReactorTile(tl);
        }

        @DependentMethodStripper.ModDependent(value={ModList.ROTARYCRAFT})
        private boolean isRotaryHeatTile(ThermalTile tl) {
            return tl instanceof TemperatureTE && !(!this.isCold() ? ((TemperatureTE)tl).allowExternalHeating() : ((TemperatureTE)tl).canBeCooledWithFins());
        }

        @DependentMethodStripper.ModDependent(value={ModList.REACTORCRAFT})
        private boolean isReactorTile(ThermalTile tl) {
            return tl instanceof ReactorCoreTE;
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBT.func_74768_a("temperature", this.temperature);
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.temperature = NBT.func_74762_e("temperature");
        }

        public Packet func_145844_m() {
            NBTTagCompound NBT = new NBTTagCompound();
            this.func_145841_b(NBT);
            S35PacketUpdateTileEntity pack = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, NBT);
            return pack;
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity p) {
            this.func_145839_a(p.field_148860_e);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public AxisAlignedBB getRenderBoundingBox() {
            return ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        }

        public int maxrequestHeatTick(ForgeDirection dir) {
            return !this.isCold() && ((SidedBlock)this.func_145838_q()).getSide((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) == dir.getOpposite() ? Math.min(10, this.temperature / 50) : 0;
        }

        public int requestHeat(ForgeDirection dir, int amt) {
            return Math.min(this.maxrequestHeatTick(dir), amt);
        }
    }
}

