/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.ModList;
import Reika.GeoStrata.GeoStrata;
import Reika.GeoStrata.Registry.RockShapes;
import Reika.GeoStrata.Registry.RockTypes;
import java.util.HashSet;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPath
extends Block {
    private IIcon[][] icons = new IIcon[PathType.list.length][3];

    public BlockPath(Material mat) {
        super(mat);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChroma);
        this.field_149762_H = field_149769_e;
        this.field_149765_K = 1.5f;
    }

    public int getLightValue(IBlockAccess iba, int x, int y, int z) {
        return iba.func_72805_g(x, y, z) == PathType.GLOW.ordinal() ? 12 : 0;
    }

    public float getExplosionResistance(Entity e, World world, int x, int y, int z, double eX, double eY, double eZ) {
        return world.func_72805_g(x, y, z) == PathType.FIRE.ordinal() ? 6000.0f : super.getExplosionResistance(e, world, x, y, z, eX, eY, eZ);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.icons[meta][2];
    }

    public void func_149651_a(IIconRegister ico) {
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i][0] = ico.func_94245_a("chromaticraft:path/" + PathType.list[i].name.toLowerCase(Locale.ENGLISH) + "_back");
            this.icons[i][1] = ico.func_94245_a("chromaticraft:path/" + PathType.list[i].name.toLowerCase(Locale.ENGLISH) + "_front");
            this.icons[i][2] = ico.func_94245_a("chromaticraft:path/path_" + i);
        }
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) != PathType.RAINBOW.ordinal() ? 0xFFFFFF : (ModList.GEOSTRATA.isLoaded() ? this.getOpalColor(world, x, y, z) : this.getBasicRainbowColor(world, x, y, z));
    }

    private int getBasicRainbowColor(IBlockAccess world, int x, int y, int z) {
        return CrystalElement.getBlendedColor(x, 10);
    }

    @DependentMethodStripper.ModDependent(value={ModList.GEOSTRATA})
    private int getOpalColor(IBlockAccess world, int x, int y, int z) {
        return GeoStrata.getOpalPositionColor((IBlockAccess)world, (double)x, (double)y, (double)z);
    }

    public void func_149724_b(World world, int x, int y, int z, Entity e) {
        this.field_149765_K = 0.95f;
        if (e instanceof EntityLivingBase) {
            EntityLivingBase el = (EntityLivingBase)e;
            float max = 0.6f;
            int meta = world.func_72805_g(x, y, z);
            if (meta == PathType.EMERALD.ordinal()) {
                max = 0.8f;
            }
            if (meta == PathType.BASIC.ordinal()) {
                max = 0.3f;
            }
            HashSet<ForgeDirection> set = this.getPathDirectionsAt(world, x, y, z, meta);
            double curV = ReikaMathLibrary.py3d((double)el.field_70159_w, (double)0.0, (double)el.field_70179_y);
            double v = Math.min(curV + 0.125, (double)max) * 2.0;
            double[] xz = ReikaPhysicsHelper.polarToCartesian((double)1.0, (double)0.0, (double)(el.field_70759_as + 90.0f));
            if (xz[0] < 0.0 && !set.contains(ForgeDirection.WEST)) {
                xz[0] = 0.0;
            }
            if (xz[0] > 0.0 && !set.contains(ForgeDirection.EAST)) {
                xz[0] = 0.0;
            }
            if (xz[1] < 0.0 && !set.contains(ForgeDirection.NORTH)) {
                xz[1] = 0.0;
            }
            if (xz[1] > 0.0 && !set.contains(ForgeDirection.SOUTH)) {
                xz[1] = 0.0;
            }
            el.field_70159_w = xz[0] * v;
            el.field_70179_y = xz[2] * v;
            el.field_70133_I = true;
            el.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 1, 2));
            if (meta == PathType.FIRE.ordinal()) {
                el.func_70066_B();
            }
        }
    }

    private HashSet<ForgeDirection> getPathDirectionsAt(World world, int x, int y, int z, int meta) {
        HashSet<ForgeDirection> set = new HashSet<ForgeDirection>();
        for (int d = 0; d < 12; ++d) {
            for (int i = 2; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                int dx = x + d * dir.offsetX;
                int dz = z + d * dir.offsetZ;
                if (world.func_147439_a(dx, y, dz) != this || world.func_72805_g(dx, y, dz) != meta) continue;
                set.add(dir);
            }
            if (set.size() == 4 && world.func_147439_a(x - d, y, z - d) == this && world.func_72805_g(x - d, y, z - d) == meta && world.func_147439_a(x + d, y, z - d) == this && world.func_72805_g(x + d, y, z - d) == meta && world.func_147439_a(x - d, y, z + d) == this && world.func_72805_g(x - d, y, z + d) == meta && world.func_147439_a(x + d, y, z + d) == this && world.func_72805_g(x + d, y, z + d) == meta) {
                set.clear();
            }
            if (!set.isEmpty()) break;
        }
        return set;
    }

    public static enum PathType {
        BASIC("Basic", Blocks.field_150347_e),
        SMOOTH("Smooth", Blocks.field_150348_b),
        BRICK("Brick", Blocks.field_150336_V),
        GLOW("Glowing", Blocks.field_150426_aN),
        FIRE("Fiery", Blocks.field_150343_Z),
        EMERALD("Rich", Blocks.field_150475_bE),
        RAINBOW("Opalized", Blocks.field_150368_y);

        public final String name;
        private final Block addition;
        public static final PathType[] list;

        private PathType(String s, Block b) {
            this.name = s;
            this.addition = b;
        }

        public ItemStack getBlock() {
            if (this == RAINBOW && ModList.GEOSTRATA.isLoaded()) {
                return PathType.getOpal();
            }
            return new ItemStack(this.addition);
        }

        @DependentMethodStripper.ModDependent(value={ModList.GEOSTRATA})
        private static ItemStack getOpal() {
            return RockTypes.OPAL.getItem(RockShapes.SMOOTH);
        }

        static {
            list = PathType.values();
        }
    }
}

