/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block;

import Reika.ChromatiCraft.Auxiliary.Interfaces.MultiBlockChromaTile;
import Reika.ChromatiCraft.Base.BlockProtectedByStructure;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaStructures;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalRepeater;
import Reika.ChromatiCraft.TileEntity.Storage.TileEntityPowerTree;
import Reika.DragonAPI.Auxiliary.Trackers.SpecialDayTracker;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.StructuredBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Interfaces.Block.ConnectedTextureGlass;
import Reika.DragonAPI.Interfaces.Block.CraftableStone;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPylonStructure
extends BlockProtectedByStructure
implements ConnectedTextureGlass,
CraftableStone {
    private final ArrayList<Integer> allDirs = new ArrayList();
    private final IIcon[][] icons = new IIcon[16][16];
    private final IIcon[] edges = new IIcon[10];
    private final int[] variants = ReikaArrayHelper.getArrayOf((int)1, (int)16);
    private static IIcon redstoneTorch;
    private static IIcon redstoneTorchOff;

    public BlockPylonStructure(Material mat) {
        super(mat);
        int i;
        this.func_149711_c(3.0f);
        this.func_149752_b(12.0f);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChroma);
        this.allDirs.add(5);
        for (i = 1; i < 10; ++i) {
            if (i == 5) continue;
            this.allDirs.add(i);
        }
        this.variants[StoneTypes.BEAM.ordinal()] = 3;
        this.variants[StoneTypes.GLOWBEAM.ordinal()] = 3;
        this.variants[StoneTypes.CORNER.ordinal()] = 4;
        this.variants[StoneTypes.RESORING.ordinal()] = 2;
        for (i = 0; i < StoneTypes.list.length; ++i) {
            StoneTypes s = StoneTypes.list[i];
            if (!s.glows()) continue;
            int n = i;
            this.variants[n] = this.variants[n] * 2;
        }
    }

    public IIcon func_149691_a(int s, int meta) {
        int idx = this.getIconIndex(s, meta);
        if (s < 2 && meta < 6) {
            return this.icons[0][idx];
        }
        return this.icons[meta][idx];
    }

    private int getIconIndex(int s, int meta) {
        return 0;
    }

    public int func_149645_b() {
        return ChromaISBRH.crystalStone.getRenderID();
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        ChromaISBRH.crystalStone.setRenderPass(pass);
        return pass <= 1;
    }

    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        int meta = this.getWrappedMeta(s, iba.func_72805_g(x, y, z));
        int idx = this.getIconIndex(iba, x, y, z, s, meta);
        return idx >= 0 ? this.icons[meta][idx] : super.func_149673_e(iba, x, y, z, s);
    }

    private int getWrappedMeta(int s, int meta) {
        StoneTypes m = StoneTypes.list[meta];
        if (m.isBeam() && s <= 1) {
            return StoneTypes.BEAM.ordinal();
        }
        if (m.isColumn() && s <= 1) {
            return StoneTypes.COLUMN.ordinal();
        }
        return meta;
    }

    private int getIconIndex(IBlockAccess iba, int x, int y, int z, int s, int meta) {
        StoneTypes m = StoneTypes.list[meta];
        if (m == StoneTypes.RESORING) {
            if (s <= 1) {
                if (iba.func_147439_a(x + 1, y, z) == this && iba.func_72805_g(x + 1, y, z) == meta) {
                    return 0;
                }
                if (iba.func_147439_a(x - 1, y, z) == this && iba.func_72805_g(x - 1, y, z) == meta) {
                    return 0;
                }
                if (iba.func_147439_a(x, y, z + 1) == this && iba.func_72805_g(x, y, z + 1) == meta) {
                    return 1;
                }
                if (iba.func_147439_a(x, y, z - 1) == this && iba.func_72805_g(x, y, z - 1) == meta) {
                    return 1;
                }
            }
            if (iba.func_147439_a(x, y + 1, z) == this && iba.func_72805_g(x, y + 1, z) == meta) {
                return 1;
            }
            if (iba.func_147439_a(x, y - 1, z) == this && iba.func_72805_g(x, y - 1, z) == meta) {
                return 1;
            }
            boolean flag = true;
            boolean flag2 = false;
            boolean flag3 = false;
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                if (iba.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) != this) continue;
                if (iba.func_72805_g(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) == meta) {
                    flag = false;
                }
                if (dir.offsetY != 0) continue;
                flag2 = true;
                if (dir.offsetZ != 0) continue;
                flag3 = true;
            }
            if (flag && flag2 && (s > 1 || flag3)) {
                return 1;
            }
        }
        if (m.isBeam() && s <= 1) {
            if (iba.func_147439_a(x + 1, y, z) == this && this.getWrappedMeta(s, iba.func_72805_g(x + 1, y, z)) == meta) {
                return 2;
            }
            if (iba.func_147439_a(x - 1, y, z) == this && this.getWrappedMeta(s, iba.func_72805_g(x - 1, y, z)) == meta) {
                return 2;
            }
            if (iba.func_147439_a(x, y, z + 1) == this && this.getWrappedMeta(s, iba.func_72805_g(x, y, z + 1)) == meta) {
                return 1;
            }
            if (iba.func_147439_a(x, y, z - 1) == this && this.getWrappedMeta(s, iba.func_72805_g(x, y, z - 1)) == meta) {
                return 1;
            }
        }
        if (m == StoneTypes.CORNER) {
            switch (s) {
                case 0: 
                case 1: {
                    if (iba.func_147439_a(x + 1, y, z) == this && iba.func_147439_a(x, y, z + 1) == this) {
                        return 0;
                    }
                    if (iba.func_147439_a(x - 1, y, z) == this && iba.func_147439_a(x, y, z + 1) == this) {
                        return 1;
                    }
                    if (iba.func_147439_a(x + 1, y, z) == this && iba.func_147439_a(x, y, z - 1) == this) {
                        return 3;
                    }
                    if (iba.func_147439_a(x - 1, y, z) != this || iba.func_147439_a(x, y, z - 1) != this) break;
                    return 2;
                }
                case 2: {
                    if (iba.func_147439_a(x, y - 1, z) == this && iba.func_147439_a(x + 1, y, z) == this) {
                        return 1;
                    }
                    if (iba.func_147439_a(x, y - 1, z) == this && iba.func_147439_a(x - 1, y, z) == this) {
                        return 0;
                    }
                    if (iba.func_147439_a(x, y + 1, z) == this && iba.func_147439_a(x + 1, y, z) == this) {
                        return 2;
                    }
                    if (iba.func_147439_a(x, y + 1, z) != this || iba.func_147439_a(x - 1, y, z) != this) break;
                    return 3;
                }
                case 3: {
                    if (iba.func_147439_a(x, y - 1, z) == this && iba.func_147439_a(x + 1, y, z) == this) {
                        return 0;
                    }
                    if (iba.func_147439_a(x, y - 1, z) == this && iba.func_147439_a(x - 1, y, z) == this) {
                        return 1;
                    }
                    if (iba.func_147439_a(x, y + 1, z) == this && iba.func_147439_a(x + 1, y, z) == this) {
                        return 3;
                    }
                    if (iba.func_147439_a(x, y + 1, z) != this || iba.func_147439_a(x - 1, y, z) != this) break;
                    return 2;
                }
                case 4: {
                    if (iba.func_147439_a(x, y - 1, z) == this && iba.func_147439_a(x, y, z + 1) == this) {
                        return 0;
                    }
                    if (iba.func_147439_a(x, y - 1, z) == this && iba.func_147439_a(x, y, z - 1) == this) {
                        return 1;
                    }
                    if (iba.func_147439_a(x, y + 1, z) == this && iba.func_147439_a(x, y, z + 1) == this) {
                        return 3;
                    }
                    if (iba.func_147439_a(x, y + 1, z) != this || iba.func_147439_a(x, y, z - 1) != this) break;
                    return 2;
                }
                case 5: {
                    if (iba.func_147439_a(x, y - 1, z) == this && iba.func_147439_a(x, y, z + 1) == this) {
                        return 1;
                    }
                    if (iba.func_147439_a(x, y - 1, z) == this && iba.func_147439_a(x, y, z - 1) == this) {
                        return 0;
                    }
                    if (iba.func_147439_a(x, y + 1, z) == this && iba.func_147439_a(x, y, z + 1) == this) {
                        return 2;
                    }
                    if (iba.func_147439_a(x, y + 1, z) != this || iba.func_147439_a(x, y, z - 1) != this) break;
                    return 3;
                }
            }
        }
        return -1;
    }

    public IIcon getBrightOverlay(IBlockAccess iba, int x, int y, int z, int s) {
        int meta = iba.func_72805_g(x, y, z);
        switch (StoneTypes.list[meta]) {
            case GLOWCOL: 
            case GLOWBEAM: 
            case FOCUS: {
                if (s <= 1) {
                    return null;
                }
            }
            case RESORING: 
            case MULTICHROMIC: 
            case STABILIZER: {
                return this.icons[meta][this.variants[meta] / 2 + Math.max(0, this.getIconIndex(iba, x, y, z, s, meta))];
            }
        }
        return null;
    }

    public IIcon getBrightOverlay(int meta, int s) {
        switch (StoneTypes.list[meta]) {
            case GLOWCOL: 
            case GLOWBEAM: 
            case FOCUS: {
                if (s <= 1) {
                    return null;
                }
            }
            case RESORING: 
            case MULTICHROMIC: 
            case STABILIZER: {
                return this.icons[meta][this.variants[meta] / 2 + Math.max(0, this.getIconIndex(s, meta))];
            }
        }
        return null;
    }

    public void func_149651_a(IIconRegister ico) {
        int i;
        for (i = 0; i < 16; ++i) {
            for (int k = 0; k < this.variants[i]; ++k) {
                String suff;
                String string = suff = k > 0 ? String.valueOf(i + "-" + (k + 1)) : String.valueOf(i);
                if (StoneTypes.list[i].isColumn() && k == 0 && SpecialDayTracker.instance.loadXmasTextures()) {
                    suff = suff + "_xm";
                }
                this.icons[i][k] = ico.func_94245_a("chromaticraft:pylon/block_" + suff);
            }
        }
        for (i = 0; i < 10; ++i) {
            this.edges[i] = ico.func_94245_a("chromaticraft:pylon/connected/side_" + i);
        }
        redstoneTorch = ico.func_94245_a("chromaticraft:crystaltorch_on");
        redstoneTorchOff = ico.func_94245_a("chromaticraft:crystaltorch_off");
    }

    public int func_149692_a(int meta) {
        switch (StoneTypes.list[meta]) {
            case GLOWCOL: {
                return StoneTypes.COLUMN.ordinal();
            }
            case GLOWBEAM: {
                return StoneTypes.BEAM.ordinal();
            }
            case FOCUS: {
                return StoneTypes.FOCUSFRAME.ordinal();
            }
        }
        return meta;
    }

    public boolean func_149700_E() {
        return true;
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion e) {
        int r = 12;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    int dx = x + i;
                    int dy = y + j;
                    int dz = z + k;
                    TileEntity te = world.func_147438_o(dx, dy, dz);
                    if (te instanceof TileEntityCrystalPylon) {
                        ((TileEntityCrystalPylon)te).invalidateMultiblock();
                    }
                    if (!(te instanceof TileEntityCrystalRepeater)) continue;
                    ((TileEntityCrystalRepeater)te).validateStructure();
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (SpecialDayTracker.instance.loadXmasTextures() && StoneTypes.list[world.func_72805_g(x, y, z)].isColumn()) {
            double o = 0.0625;
            int d = 2 + rand.nextInt(4);
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[d];
            double px = 0.5;
            double pz = 0.5;
            if (dir.offsetX != 0) {
                px += (double)dir.offsetX / 2.0 + o * (double)dir.offsetX;
                pz = rand.nextDouble() * (1.0 + o * 2.0) - o;
            } else {
                pz += (double)dir.offsetZ / 2.0 + o * (double)dir.offsetZ;
                px = rand.nextDouble() * (1.0 + o * 2.0) - o;
            }
            EntityCCBlurFX fx = new EntityCCBlurFX(world, (double)x + px, (double)y + rand.nextDouble(), (double)z + pz);
            int rgb = ReikaColorAPI.RGBtoHex((int)(rand.nextBoolean() ? 255 : 0), (int)(rand.nextBoolean() ? 255 : 0), (int)(rand.nextBoolean() ? 255 : 0));
            fx.setIcon(ChromaIcons.CENTER).setColor(rgb).setAlphaFading().setRapidExpand();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block oldB, int oldM) {
        this.triggerBreakCheck(world, x, y, z);
        super.func_149749_a(world, x, y, z, oldB, oldM);
    }

    void triggerBreakCheck(World world, int x, int y, int z) {
        StructuredBlockArray blocks = new StructuredBlockArray(world);
        blocks.extraSpread = true;
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            blocks.recursiveAddWithBounds((IBlockAccess)world, dx, dy, dz, (Block)this, x - 16, y - 32, z - 16, x + 16, y + 32, z + 16);
        }
        int mx = blocks.getMidX();
        int my = blocks.getMinY();
        int mz = blocks.getMidZ();
        for (int h = 9; h < 16; ++h) {
            TileEntity te = world.func_147438_o(mx, my + h, mz);
            if (!(te instanceof TileEntityCrystalPylon) || ChromaStructures.PYLON.getArray(world, mx, my + h, mz, ((TileEntityCrystalPylon)te).getColor()).matchInWorld()) continue;
            ((TileEntityCrystalPylon)te).invalidateMultiblock();
            break;
        }
        for (int i = 0; i <= 23; ++i) {
            TileEntity te = world.func_147438_o(mx, my + i, mz);
            if (!(te instanceof MultiBlockChromaTile)) continue;
            ((MultiBlockChromaTile)te).validateStructure();
        }
        for (int k = 0; k < 6; ++k) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[k];
            for (int i = 1; i <= 5; ++i) {
                TileEntity te = world.func_147438_o(x + dir.offsetX * i, y + dir.offsetY * i, z + dir.offsetZ * i);
                if (!(te instanceof TileEntityCrystalRepeater)) continue;
                ((TileEntityCrystalRepeater)te).validateStructure();
            }
        }
        TileEntity te = world.func_147438_o(blocks.getMidX() - 1, blocks.getMaxY() + 1, blocks.getMidZ());
        if (te instanceof TileEntityPowerTree) {
            ((TileEntityPowerTree)te).validateStructure();
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        BlockPylonStructure.triggerAddCheck(world, x, y, z);
        super.func_149726_b(world, x, y, z);
    }

    public static void triggerAddCheck(World world, int x, int y, int z) {
        TileEntity te;
        StructuredBlockArray blocks = new StructuredBlockArray(world);
        blocks.extraSpread = true;
        blocks.recursiveAddWithBounds((IBlockAccess)world, x, y, z, ChromaBlocks.PYLONSTRUCT.getBlockInstance(), x - 16, y - 32, z - 16, x + 16, y + 32, z + 16);
        int mx = blocks.getMidX();
        int my = blocks.getMinY();
        int mz = blocks.getMidZ();
        for (int h = 9; h < 16; ++h) {
            FilledBlockArray f;
            te = world.func_147438_o(mx, my + h, mz);
            if (!(te instanceof TileEntityCrystalPylon) || !(f = ChromaStructures.PYLON.getArray(world, mx, my + h, mz, ((TileEntityCrystalPylon)te).getColor())).matchInWorld()) continue;
            ((TileEntityCrystalPylon)te).validateMultiblock(f);
            break;
        }
        for (int i = 0; i <= 23; ++i) {
            te = world.func_147438_o(mx, my + i, mz);
            if (!(te instanceof MultiBlockChromaTile)) continue;
            ((MultiBlockChromaTile)te).validateStructure();
        }
        for (int k = 0; k < 6; ++k) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[k];
            for (int i = 1; i <= 5; ++i) {
                TileEntity te2 = world.func_147438_o(x + dir.offsetX * i, y + dir.offsetY * i, z + dir.offsetZ * i);
                if (!(te2 instanceof TileEntityCrystalRepeater)) continue;
                ((TileEntityCrystalRepeater)te2).validateStructure();
            }
        }
        TileEntity te3 = world.func_147438_o(blocks.getMidX() - 1, blocks.getMaxY() + 1, blocks.getMidZ());
        if (te3 instanceof TileEntityPowerTree) {
            ((TileEntityPowerTree)te3).validateStructure();
        }
    }

    public HashSet<Integer> getEdgesForFace(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        HashSet<Integer> li = new HashSet<Integer>();
        li.addAll(this.allDirs);
        int meta = world.func_72805_g(x, y, z);
        if (face.offsetX != 0) {
            if (this.connectTo(world, x, y, z + 1, meta)) {
                li.remove(2);
            }
            if (this.connectTo(world, x, y, z - 1, meta)) {
                li.remove(8);
            }
            if (this.connectTo(world, x, y + 1, z, meta)) {
                li.remove(4);
            }
            if (this.connectTo(world, x, y - 1, z, meta)) {
                li.remove(6);
            }
            if (this.connectTo(world, x, y + 1, z + 1, meta) && !li.contains(4) && !li.contains(2)) {
                li.remove(1);
            }
            if (this.connectTo(world, x, y - 1, z - 1, meta) && !li.contains(6) && !li.contains(8)) {
                li.remove(9);
            }
            if (this.connectTo(world, x, y + 1, z - 1, meta) && !li.contains(4) && !li.contains(8)) {
                li.remove(7);
            }
            if (this.connectTo(world, x, y - 1, z + 1, meta) && !li.contains(2) && !li.contains(6)) {
                li.remove(3);
            }
        }
        if (face.offsetY != 0) {
            if (this.connectTo(world, x, y, z + 1, meta)) {
                li.remove(2);
            }
            if (this.connectTo(world, x, y, z - 1, meta)) {
                li.remove(8);
            }
            if (this.connectTo(world, x + 1, y, z, meta)) {
                li.remove(4);
            }
            if (this.connectTo(world, x - 1, y, z, meta)) {
                li.remove(6);
            }
            if (this.connectTo(world, x + 1, y, z + 1, meta) && !li.contains(4) && !li.contains(2)) {
                li.remove(1);
            }
            if (this.connectTo(world, x - 1, y, z - 1, meta) && !li.contains(6) && !li.contains(8)) {
                li.remove(9);
            }
            if (this.connectTo(world, x + 1, y, z - 1, meta) && !li.contains(4) && !li.contains(8)) {
                li.remove(7);
            }
            if (this.connectTo(world, x - 1, y, z + 1, meta) && !li.contains(2) && !li.contains(6)) {
                li.remove(3);
            }
        }
        if (face.offsetZ != 0) {
            if (this.connectTo(world, x, y + 1, z, meta)) {
                li.remove(4);
            }
            if (this.connectTo(world, x, y - 1, z, meta)) {
                li.remove(6);
            }
            if (this.connectTo(world, x + 1, y, z, meta)) {
                li.remove(2);
            }
            if (this.connectTo(world, x - 1, y, z, meta)) {
                li.remove(8);
            }
            if (this.connectTo(world, x + 1, y + 1, z, meta) && !li.contains(2) && !li.contains(4)) {
                li.remove(1);
            }
            if (this.connectTo(world, x - 1, y - 1, z, meta) && !li.contains(8) && !li.contains(6)) {
                li.remove(9);
            }
            if (this.connectTo(world, x + 1, y - 1, z, meta) && !li.contains(2) && !li.contains(6)) {
                li.remove(3);
            }
            if (this.connectTo(world, x - 1, y + 1, z, meta) && !li.contains(4) && !li.contains(8)) {
                li.remove(7);
            }
        }
        return li;
    }

    private boolean connectTo(IBlockAccess world, int x, int y, int z, int meta) {
        if (world.func_147439_a(x, y, z) == this && world.func_72805_g(x, y, z) == meta) {
            return true;
        }
        return world.func_147439_a(x, y, z) == ChromaBlocks.RUNE.getBlockInstance();
    }

    public IIcon getIconForEdge(IBlockAccess world, int x, int y, int z, int edge) {
        return this.edges[edge];
    }

    public IIcon getIconForEdge(int itemMeta, int edge) {
        return this.edges[edge];
    }

    public boolean renderCentralTextureForItem(int meta) {
        return true;
    }

    public static IIcon getIconOverride(Block b) {
        return b == Blocks.field_150429_aA ? redstoneTorch : redstoneTorchOff;
    }

    public static enum StoneTypes {
        SMOOTH,
        BEAM,
        COLUMN,
        GLOWCOL,
        GLOWBEAM,
        FOCUS,
        CORNER,
        ENGRAVED,
        EMBOSSED,
        FOCUSFRAME,
        GROOVE1,
        GROOVE2,
        BRICKS,
        MULTICHROMIC,
        STABILIZER,
        RESORING;

        public static final StoneTypes[] list;

        public BlockKey getBlock() {
            return new BlockKey(ChromaBlocks.PYLONSTRUCT.getBlockInstance(), this.ordinal());
        }

        public boolean needsSilkTouch() {
            return this == GLOWCOL || this == GLOWBEAM || this == FOCUS;
        }

        public boolean isBeam() {
            return this == BEAM || this == GLOWBEAM;
        }

        public boolean isColumn() {
            return this == COLUMN || this == GLOWCOL;
        }

        public boolean glows() {
            return this == GLOWCOL || this == GLOWBEAM || this == FOCUS || this == RESORING || this == STABILIZER || this == MULTICHROMIC;
        }

        public boolean isConnectedTexture() {
            return this == SMOOTH && ChromaOptions.CONNECTEDCRYSTALSTONE.getState();
        }

        public int getBrightRenderPass() {
            switch (this) {
                case RESORING: 
                case GLOWCOL: 
                case GLOWBEAM: 
                case FOCUS: {
                    return 1;
                }
            }
            return 0;
        }

        public StoneTypes getGlowingVariant() {
            switch (this) {
                case BEAM: {
                    return GLOWBEAM;
                }
                case COLUMN: {
                    return GLOWCOL;
                }
                case FOCUSFRAME: {
                    return FOCUS;
                }
            }
            return null;
        }

        static {
            list = StoneTypes.values();
        }
    }
}

