/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Crystal;

import Reika.ChromatiCraft.Base.CrystalTypeBlock;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCenterBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityLaserFX;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCrystalGlow
extends CrystalTypeBlock {
    public BlockCrystalGlow(Material mat) {
        super(mat);
        this.func_149711_c(0.0f);
        this.func_149752_b(0.0f);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChromaDeco);
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ico.func_94245_a("chromaticraft:basic/glow");
    }

    @Override
    public int getBrightness(IBlockAccess iba, int x, int y, int z) {
        return 15;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        double rx = (double)x + rand.nextDouble();
        double ry = (double)y + rand.nextDouble();
        double rz = (double)z + rand.nextDouble();
        float g = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.025, (double)0.0125);
        TileEntityCrystalGlow te = (TileEntityCrystalGlow)world.func_147438_o(x, y, z);
        if (te.getDirection() != ForgeDirection.DOWN) {
            g = -g;
        }
        boolean in = rand.nextBoolean();
        double v = 0.0125;
        double vx = in ? v * (0.5 - (rx - (double)x)) : (rx - (double)x) * v;
        double vz = in ? v * (0.5 - (rz - (double)z)) : (rz - (double)z) * v;
        Object fx = null;
        int type = rand.nextInt(3);
        switch (type) {
            case 0: {
                fx = new EntityCCBlurFX(this.getCrystalElement((IBlockAccess)world, x, y, z), world, rx, ry, rz, vx, 0.0, vz).setScale(1.0f + rand.nextFloat()).setGravity(g);
                break;
            }
            case 1: {
                fx = new EntityCenterBlurFX(this.getCrystalElement((IBlockAccess)world, x, y, z), world, rx, ry, rz, vx, 0.0, vz).setScale(1.0f + rand.nextFloat()).setGravity(g);
                break;
            }
            case 2: {
                fx = new EntityLaserFX(this.getCrystalElement((IBlockAccess)world, x, y, z), world, rx, ry, rz, vx, 0.0, vz).setScale(1.0f + rand.nextFloat()).setGravity(g);
            }
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
    }

    public final int func_149645_b() {
        return ChromaISBRH.glow.getRenderID();
    }

    public final boolean func_149662_c() {
        return false;
    }

    public final boolean func_149686_d() {
        return false;
    }

    public final int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        ChromaISBRH.glow.setRenderPass(pass);
        return pass <= 1;
    }

    public boolean canPlaceOn(World world, int x, int y, int z, int side) {
        return this.canPlaceOn(world, x, y, z, ForgeDirection.VALID_DIRECTIONS[side]);
    }

    public boolean canPlaceOn(World world, int x, int y, int z, ForgeDirection side) {
        Block b = world.func_147439_a(x, y, z);
        if (b instanceof BlockSlab && side == ForgeDirection.DOWN) {
            return world.func_72805_g(x, y, z) < 8;
        }
        return b.isSideSolid((IBlockAccess)world, x, y, z, side);
    }

    public void setSide(World world, int x, int y, int z, ForgeDirection dir) {
        TileEntityCrystalGlow te = (TileEntityCrystalGlow)world.func_147438_o(x, y, z);
        te.direction = dir;
        te.longAxis = (ForgeDirection)ReikaDirectionHelper.getPerpendicularDirections((ForgeDirection)dir).get(0);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        TileEntityCrystalGlow te = (TileEntityCrystalGlow)world.func_147438_o(x, y, z);
        ForgeDirection dir = te.direction;
        if (!this.canPlaceOn(world, x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ, dir)) {
            ItemStack is = ChromaBlocks.GLOW.getStackOfMetadata(world.func_72805_g(x, y, z) + 16 * te.base.ordinal());
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
            ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)this);
            ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)is);
        }
    }

    public void func_149719_a(IBlockAccess iba, int x, int y, int z) {
        float xmin = 0.0f;
        float ymin = 0.0f;
        float zmin = 0.0f;
        float xmax = 1.0f;
        float ymax = 1.0f;
        float zmax = 1.0f;
        float h = 0.125f;
        float w = 0.25f;
        TileEntity te = iba.func_147438_o(x, y, z);
        ForgeDirection dir = te instanceof TileEntityCrystalGlow ? ((TileEntityCrystalGlow)te).direction : ForgeDirection.UNKNOWN;
        ForgeDirection ax = te instanceof TileEntityCrystalGlow ? ((TileEntityCrystalGlow)te).longAxis : ForgeDirection.UNKNOWN;
        switch (dir) {
            case WEST: {
                zmin = 0.5f - w;
                zmax = 0.5f + w;
                ymin = 0.5f - w;
                ymax = 0.5f + w;
                xmin = 1.0f - h;
                break;
            }
            case EAST: {
                zmin = 0.5f - w;
                zmax = 0.5f + w;
                ymin = 0.5f - w;
                ymax = 0.5f + w;
                xmax = h;
                break;
            }
            case NORTH: {
                xmin = 0.5f - w;
                xmax = 0.5f + w;
                ymin = 0.5f - w;
                ymax = 0.5f + w;
                zmin = 1.0f - h;
                break;
            }
            case SOUTH: {
                xmin = 0.5f - w;
                xmax = 0.5f + w;
                ymin = 0.5f - w;
                ymax = 0.5f + w;
                zmax = h;
                break;
            }
            case UP: {
                xmin = 0.5f - w;
                xmax = 0.5f + w;
                zmin = 0.5f - w;
                zmax = 0.5f + w;
                ymax = h;
                break;
            }
            case DOWN: {
                xmin = 0.5f - w;
                xmax = 0.5f + w;
                zmin = 0.5f - w;
                zmax = 0.5f + w;
                ymin = 1.0f - h;
                break;
            }
        }
        this.func_149676_a(xmin, ymin, zmin, xmax, ymax, zmax);
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityCrystalGlow();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean harvest) {
        if (this.canHarvest(world, player, x, y, z)) {
            this.func_149636_a(world, player, x, y, z, 0);
        }
        return world.func_147468_f(x, y, z);
    }

    private boolean canHarvest(World world, EntityPlayer ep, int x, int y, int z) {
        return !ep.field_71075_bZ.field_75098_d;
    }

    public void func_149636_a(World world, EntityPlayer ep, int x, int y, int z, int meta) {
        if (!this.canHarvest(world, ep, x, y, z)) {
            return;
        }
        TileEntityCrystalGlow te = (TileEntityCrystalGlow)world.func_147438_o(x, y, z);
        if (te != null) {
            ItemStack is = ChromaBlocks.GLOW.getStackOfMetadata(world.func_72805_g(x, y, z) + 16 * te.base.ordinal());
            ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)is);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        TileEntityCrystalGlow te = (TileEntityCrystalGlow)world.func_147438_o(x, y, z);
        return new ItemStack((Block)this, 1, meta + 16 * te.base.ordinal());
    }

    public static class TileEntityCrystalGlow
    extends TileEntity {
        private ForgeDirection direction = ForgeDirection.UNKNOWN;
        private ForgeDirection longAxis = ForgeDirection.UNKNOWN;
        public Bases base = Bases.STONE;
        public boolean isIridescent;
        public boolean isRainbow;

        public boolean canUpdate() {
            return false;
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBT.func_74768_a("dir", this.direction.ordinal());
            NBT.func_74768_a("long", this.longAxis.ordinal());
            NBT.func_74768_a("base", this.base.ordinal());
            NBT.func_74757_a("irid", this.isIridescent);
            NBT.func_74757_a("rainbow", this.isRainbow);
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.direction = ForgeDirection.values()[NBT.func_74762_e("dir")];
            this.longAxis = ForgeDirection.values()[NBT.func_74762_e("long")];
            this.isIridescent = NBT.func_74767_n("irid");
            this.isRainbow = NBT.func_74767_n("rainbow");
            this.base = Bases.baseList[NBT.func_74762_e("base")];
        }

        public Packet func_145844_m() {
            NBTTagCompound NBT = new NBTTagCompound();
            this.func_145841_b(NBT);
            S35PacketUpdateTileEntity pack = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, NBT);
            return pack;
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity p) {
            this.func_145839_a(p.field_148860_e);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public AxisAlignedBB getRenderBoundingBox() {
            return ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        }

        public ForgeDirection getDirection() {
            return this.direction;
        }

        public ForgeDirection getLongAxis() {
            return this.longAxis;
        }

        public void toggle() {
            CrystalTypeBlock.ding(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (this.isIridescent) {
                this.isIridescent = false;
                this.isRainbow = true;
            } else if (this.isRainbow) {
                this.isRainbow = false;
            } else {
                this.isIridescent = true;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public void rotate() {
            CrystalTypeBlock.ding(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.longAxis = this.longAxis.getRotation(this.direction);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public static enum Bases {
        STONE("Stone", Blocks.field_150348_b),
        CRYSTALSTONE("Crystal Stone", ChromaBlocks.PYLONSTRUCT.getBlockInstance()),
        IRON("Iron", Items.field_151042_j, Blocks.field_150339_S),
        GOLD("Gold", Items.field_151043_k, Blocks.field_150340_R),
        OBSIDIAN("Obsidian", Blocks.field_150343_Z),
        QUARTZ("Quartz", Blocks.field_150371_ca);

        public final Object ingredient;
        public final Block texture;
        public final String displayName;
        public static final Bases[] baseList;

        private Bases(String s, Block b) {
            this(s, b, b);
        }

        private Bases(String s, Object o, Block b) {
            this.displayName = s;
            this.ingredient = o;
            this.texture = b;
        }

        static {
            baseList = Bases.values();
        }
    }
}

