/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Crystal;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityRuneFX;
import Reika.ChromatiCraft.TileEntity.Storage.TileEntityPowerTree;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"mcp.mobius.waila.api.IWailaDataProvider"})
public class BlockPowerTree
extends Block
implements IWailaDataProvider {
    private static final Random rand = new Random();

    public BlockPowerTree(Material mat) {
        super(mat);
        this.func_149711_c(1.0f);
        this.func_149752_b(6000.0f);
        this.field_149762_H = field_149778_k;
    }

    public final int getLightValue(IBlockAccess iba, int x, int y, int z) {
        CrystalElement e = CrystalElement.elements[iba.func_72805_g(x, y, z)];
        return ModList.COLORLIGHT.isLoaded() ? ReikaColorAPI.getPackedIntForColoredLight((int)e.getColor(), (int)15) : 15;
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityPowerTreeAux();
    }

    private TileEntityPowerTree getTile(World world, int x, int y, int z) {
        int dz;
        int dy;
        TileEntityPowerTreeAux te = (TileEntityPowerTreeAux)world.func_147438_o(x, y, z);
        int dx = te.originX;
        ChromaTiles c = ChromaTiles.getTile((IBlockAccess)world, dx, dy = te.originY, dz = te.originZ);
        if (c == ChromaTiles.POWERTREE) {
            return (TileEntityPowerTree)world.func_147438_o(dx, dy, dz);
        }
        return null;
    }

    public CrystalElement getColor(IBlockAccess world, int x, int y, int z) {
        return CrystalElement.elements[world.func_72805_g(x, y, z)];
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ico.func_94245_a("chromaticraft:basic/powertree5");
    }

    public int func_149741_i(int meta) {
        return CrystalElement.elements[meta].getColor();
    }

    public int func_149720_d(IBlockAccess iba, int x, int y, int z) {
        return this.getColor(iba, x, y, z).getColor();
    }

    public boolean removedByPlayer(World world, EntityPlayer ep, int x, int y, int z, boolean harvest) {
        ep.func_70097_a((DamageSource)ChromatiCraft.pylonDamage[this.getColor((IBlockAccess)world, x, y, z).ordinal()], 5.0f);
        ChromaSounds.DISCHARGE.playSound((Entity)ep, 2.0f, 1.0f);
        ChromaSounds.DISCHARGE.playSoundAtBlock(world, x, y, z, 2.0f, 1.0f);
        return super.removedByPlayer(world, ep, x, y, z, harvest);
    }

    public void func_149749_a(World world, int x, int y, int z, Block old, int oldmeta) {
        TileEntityPowerTreeAux te = (TileEntityPowerTreeAux)world.func_147438_o(x, y, z);
        TileEntityPowerTree tree = te.getCenter();
        CrystalElement e = CrystalElement.elements[oldmeta];
        if (tree != null) {
            tree.onBreakLeaf(world, x, y, z, e);
        }
        this.breakEffects(world, x, y, z, e);
        super.func_149749_a(world, x, y, z, old, oldmeta);
    }

    private void breakEffects(World world, int x, int y, int z, CrystalElement e) {
        ChromaSounds.POWERDOWN.playSoundAtBlock(world, x, y, z);
        ChromaSounds.POWERDOWN.playSoundAtBlock(world, x, y, z, 1.0f, 2.0f);
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.LEAFBREAK.ordinal(), (World)world, (int)x, (int)y, (int)z, (int)32, (int[])new int[]{e.ordinal()});
    }

    @SideOnly(value=Side.CLIENT)
    public static void breakEffectsClient(World world, int x, int y, int z, CrystalElement e) {
        Object fx;
        double rz;
        double ry;
        double rx;
        double v;
        int i;
        for (i = 0; i < 64; ++i) {
            v = 0.125 + rand.nextDouble() * 0.25;
            rx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            ry = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            rz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            fx = new EntityCCBlurFX(e, world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble(), (double)z + rand.nextDouble(), rx, ry, rz);
            fx.field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (i = 0; i < 8; ++i) {
            v = 0.125 + rand.nextDouble() * 0.25;
            rx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            ry = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            rz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)v);
            fx = new EntityRuneFX(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble(), (double)z + rand.nextDouble(), rx, ry, rz, e);
            ((EntityRuneFX)((Object)fx)).field_70145_X = true;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public int func_149645_b() {
        return ChromaISBRH.tree.getRenderID();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        int rem;
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        CrystalElement e = CrystalElement.elements[meta];
        for (int n = ReikaMathLibrary.intpow2((int)(4 + rand.nextInt(5)), (int)2); n > 0; n -= rem) {
            rem = Math.min(n, ChromaItems.SHARD.getItemInstance().func_77639_j());
            ItemStack is = rand.nextInt(3) > 0 ? ChromaStacks.getChargedShard(e) : ChromaStacks.getShard(e);
            li.add(ReikaItemHelper.getSizedItemStack((ItemStack)is, (int)rem));
        }
        return li;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return new ItemStack((Block)this, 1, meta);
    }

    public ItemStack getWailaStack(IWailaDataAccessor acc, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack is, List<String> tip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        return tip;
    }

    public List<String> getWailaBody(ItemStack is, List<String> tip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        int meta = acc.getMetadata();
        CrystalElement e = CrystalElement.elements[meta];
        TileEntityPowerTree te = this.getTile(acc.getWorld(), acc.getPosition().field_72311_b, acc.getPosition().field_72312_c, acc.getPosition().field_72309_d);
        if (te != null) {
            tip.add(String.format("Stored Energy: %d lumens of %s", te.getEnergy(e), e.displayName));
        }
        return tip;
    }

    public List<String> getWailaTail(ItemStack is, List<String> tip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        return tip;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public final NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return tag;
    }

    public static class TileEntityPowerTreeAux
    extends TileEntity {
        private int growth = 0;
        private ForgeDirection direction;
        private int originX = Integer.MIN_VALUE;
        private int originY = Integer.MIN_VALUE;
        private int originZ = Integer.MIN_VALUE;
        public static final int MAX_GROWTH = 12;

        public boolean canUpdate() {
            return false;
        }

        public boolean grow() {
            if (this.growth < 12) {
                ++this.growth;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return true;
            }
            return false;
        }

        public boolean ungrow() {
            if (this.growth > 0) {
                --this.growth;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return true;
            }
            return false;
        }

        public int getGrowth() {
            return this.growth;
        }

        public ForgeDirection getDirection() {
            return this.direction;
        }

        public void setDirection(ForgeDirection dir) {
            this.direction = dir;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public void setOrigin(TileEntityPowerTree te) {
            this.originX = te.field_145851_c;
            this.originY = te.field_145848_d;
            this.originZ = te.field_145849_e;
        }

        public TileEntityPowerTree getCenter() {
            ChromaTiles c = ChromaTiles.getTile((IBlockAccess)this.field_145850_b, this.originX, this.originY, this.originZ);
            return c == ChromaTiles.POWERTREE ? (TileEntityPowerTree)this.field_145850_b.func_147438_o(this.originX, this.originY, this.originZ) : null;
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBT.func_74768_a("tx", this.originX);
            NBT.func_74768_a("ty", this.originY);
            NBT.func_74768_a("tz", this.originZ);
            NBT.func_74768_a("grow", this.growth);
            NBT.func_74768_a("dir", this.direction != null ? this.direction.ordinal() : -1);
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.originX = NBT.func_74762_e("tx");
            this.originY = NBT.func_74762_e("ty");
            this.originZ = NBT.func_74762_e("tz");
            this.growth = NBT.func_74762_e("grow");
            int dir = NBT.func_74762_e("dir");
            this.direction = dir >= 0 ? ForgeDirection.VALID_DIRECTIONS[dir] : null;
        }

        public Packet func_145844_m() {
            NBTTagCompound NBT = new NBTTagCompound();
            this.func_145841_b(NBT);
            S35PacketUpdateTileEntity pack = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, NBT);
            return pack;
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity p) {
            this.func_145839_a(p.field_148860_e);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }
}

