/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Decoration;

import Reika.ChromatiCraft.Auxiliary.Interfaces.SidedBlock;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.ModInterface.Bees.CrystalBees;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.ModInteract.Bees.BeeSpecies;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeType;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMetaAlloyLamp
extends Block
implements SidedBlock {
    public static final int COLOR1 = 10610026;
    public static final int COLOR2 = 7723775;
    public static IIcon leaf1;
    public static IIcon leaf2;
    public static IIcon podEnd;
    public static IIcon podSide;

    public BlockMetaAlloyLamp(Material mat) {
        super(mat);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChromaDeco);
        this.func_149711_c(0.25f);
        this.func_149752_b(0.0f);
        this.field_149762_H = field_149779_h;
        this.func_149675_a(true);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return this.hasPod(world, x, y, z) ? (ModList.COLORLIGHT.isLoaded() ? ReikaColorAPI.getPackedIntForColoredLight((int)0, (int)15) : 15) : 0;
    }

    public boolean hasPod(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) < 8;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!this.hasPod((IBlockAccess)world, x, y, z) && rand.nextInt(100) == 0 && !world.field_72995_K) {
            this.setPod(world, x, y, z, true);
        }
    }

    private void setPod(World world, int x, int y, int z, boolean pod) {
        world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) & 7 | (pod ? 0 : 8), 3);
        world.func_147463_c(EnumSkyBlock.Block, x, y, z);
        world.func_147471_g(x, y, z);
        ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)this);
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        ForgeDirection dir = this.getSide((IBlockAccess)world, x, y, z);
        if (!this.canPlaceOn(world, x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ, dir.ordinal())) {
            ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)this);
            ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)new ItemStack((Block)this));
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.setPod(world, x, y, z, false);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer ep) {
        if (this.hasPod((IBlockAccess)world, x, y, z)) {
            this.setPod(world, x, y, z, false);
            ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)new ItemStack((Block)this));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (this.hasPod((IBlockAccess)world, x, y, z) && rand.nextBoolean()) {
            double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)x + 0.5), (double)0.5);
            double py = ReikaRandomHelper.getRandomPlusMinus((double)((double)y + 0.5), (double)0.5);
            double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)z + 0.5), (double)0.5);
            int l = ReikaRandomHelper.getRandomBetween((int)10, (int)40);
            double s = 5.0 + rand.nextDouble() * 5.0;
            int c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)ReikaColorAPI.mixColors((int)24608, (int)96, (float)rand.nextFloat()), (float)(0.5f + rand.nextFloat() * 0.5f));
            EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz).setIcon(ChromaIcons.FADE_CLOUD).setColor(c).setLife(l).setScale((float)s).setAlphaFading();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public void func_149651_a(IIconRegister ico) {
        leaf1 = ico.func_94245_a("chromaticraft:metaleaf");
        leaf2 = ico.func_94245_a("chromaticraft:metaleaf_2");
        podSide = ico.func_94245_a("chromaticraft:metaalloy_side");
        podEnd = ico.func_94245_a("chromaticraft:metaalloy");
    }

    public int func_149645_b() {
        return ChromaISBRH.metaAlloy.getRenderID();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @Override
    public void setSide(World world, int x, int y, int z, int side) {
        world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) & 8 | side, 3);
        world.func_147471_g(x, y, z);
    }

    @Override
    public ForgeDirection getSide(IBlockAccess world, int x, int y, int z) {
        return ForgeDirection.VALID_DIRECTIONS[world.func_72805_g(x, y, z) & 7];
    }

    @Override
    public boolean canPlaceOn(World world, int x, int y, int z, int side) {
        Block b = world.func_147439_a(x, y, z);
        return b.isSideSolid((IBlockAccess)world, x, y, z, ForgeDirection.VALID_DIRECTIONS[side]) && (b.func_149688_o() == Material.field_151576_e || b.func_149688_o() == Material.field_151578_c || b.func_149688_o() == Material.field_151585_k || b.func_149688_o() == Material.field_151577_b);
    }

    public final void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float maxY = this.hasPod(world, x, y, z) ? 1.0f : 0.5f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, maxY, 1.0f);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        AxisAlignedBB box = this.func_149668_a(world, x, y, z);
        return box;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        float maxY = this.hasPod((IBlockAccess)world, x, y, z) ? 1.0f : 0.5f;
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)((float)y + maxY), (double)(z + 1));
        return box;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public static void doBeeDrops(World world, int x, int y, int z) {
        ItemStack is;
        BeeSpecies s = CrystalBees.getTowerBee();
        if (world.field_73012_v.nextInt(5) > 0) {
            is = s.getBeeItem(world, EnumBeeType.DRONE);
            ReikaItemHelper.dropItem((World)world, (double)((double)x + world.field_73012_v.nextDouble()), (double)((double)y + world.field_73012_v.nextDouble()), (double)((double)z + world.field_73012_v.nextDouble()), (ItemStack)is);
        }
        if (world.field_73012_v.nextInt(4) > 0) {
            is = s.getBeeItem(world, EnumBeeType.LARVAE);
            ReikaItemHelper.dropItem((World)world, (double)((double)x + world.field_73012_v.nextDouble()), (double)((double)y + world.field_73012_v.nextDouble()), (double)((double)z + world.field_73012_v.nextDouble()), (ItemStack)is);
        }
        if (world.field_73012_v.nextInt(2) == 0) {
            is = s.getBeeItem(world, EnumBeeType.PRINCESS);
            ReikaItemHelper.dropItem((World)world, (double)((double)x + world.field_73012_v.nextDouble()), (double)((double)y + world.field_73012_v.nextDouble()), (double)((double)z + world.field_73012_v.nextDouble()), (ItemStack)is);
        }
        if (world.field_73012_v.nextInt(5) == 0) {
            is = s.getBeeItem(world, EnumBeeType.QUEEN);
            ReikaItemHelper.dropItem((World)world, (double)((double)x + world.field_73012_v.nextDouble()), (double)((double)y + world.field_73012_v.nextDouble()), (double)((double)z + world.field_73012_v.nextDouble()), (ItemStack)is);
        }
    }
}

