/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Decoration;

import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Base.CrystalTypeBlock;
import Reika.ChromatiCraft.Block.Dimension.Structure.Music.BlockMusicMemory;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityStructControl;
import Reika.DragonAPI.Interfaces.Block.SemiUnbreakable;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMusicTrigger
extends Block
implements SemiUnbreakable {
    private static final Random rand = new Random();
    private final IIcon[] icons = new IIcon[2];

    public BlockMusicTrigger(Material mat) {
        super(mat);
        this.func_149711_c(6.0f);
        this.func_149752_b(60000.0f);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChromaGen);
    }

    public boolean isUnbreakable(World world, int x, int y, int z, int meta) {
        return world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue();
    }

    public IIcon func_149691_a(int s, int meta) {
        return s <= 1 ? this.icons[0] : this.icons[1];
    }

    public final void func_149695_a(World world, int x, int y, int z, Block b) {
        if (world.func_72864_z(x, y, z)) {
            this.ping(world, x, y, z, world.func_94577_B(x, y, z) / 4, null);
        }
    }

    public void func_149651_a(IIconRegister ico) {
        this.icons[0] = ico.func_94245_a("chromaticraft:dimstruct/musictrigger");
        this.icons[1] = ico.func_94245_a("chromaticraft:dimstruct/musictrigger_side");
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        int idx;
        if (s > 1 && (idx = this.getIndex(s, a, b, c)) >= 0) {
            this.ping(world, x, y, z, idx, ep);
        }
        return true;
    }

    private void ping(World world, int x, int y, int z, int idx, EntityPlayer ep) {
        Block bk = world.func_147439_a(x, y + 1, z);
        if (bk instanceof CrystalTypeBlock) {
            int meta = world.func_72805_g(x, y + 1, z);
            CrystalElement e = CrystalElement.elements[meta];
            float p = CrystalMusicManager.instance.getScaledDing(e, idx);
            CrystalTypeBlock.ding(world, x, y, z, e, p);
            if (world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
                BlockMusicMemory.ping(world, x, y, z, e, idx);
            } else if (world.func_147439_a(x, y - 1, z) == ChromaBlocks.STRUCTSHIELD.getBlockInstance() && world.func_72805_g(x, y - 1, z) >= 8) {
                this.pingCallback(world, x, y, z, e, idx, ep);
            }
            if (world.field_72995_K) {
                BlockMusicTrigger.createParticle(world, x, y + 1, z, e);
            }
        }
    }

    private void pingCallback(World world, int x, int y, int z, CrystalElement e, int idx, EntityPlayer ep) {
        TileEntityStructControl te = null;
        block0: for (int i = 2; i < 6 && te == null; ++i) {
            for (int d = 4; d <= 5; ++d) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
                int dx = x + dir.offsetX * d + left.offsetX;
                int dy = y - 2;
                int dz = z + dir.offsetZ * d + left.offsetZ;
                if (ChromaTiles.getTile((IBlockAccess)world, dx, dy, dz) != ChromaTiles.STRUCTCONTROL) continue;
                te = (TileEntityStructControl)world.func_147438_o(dx, dy, dz);
                continue block0;
            }
        }
        if (te != null) {
            te.onMusicTrigger(world, x, y, z, e, CrystalMusicManager.instance.getKeys(e).get(idx), ep);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void createParticle(World world, int x, int y, int z, CrystalElement e) {
        double v = ReikaRandomHelper.getRandomPlusMinus((double)0.125, (double)0.0625);
        ChromaFX.doElementalParticle(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, e, 4.0, v, 20);
        for (int i = 0; i < 12; ++i) {
            world.func_147439_a(x, y, z).func_149734_b(world, x, y, z, rand);
        }
    }

    private int getIndex(int s, float a, float b, float c) {
        double m1a = 0.125;
        double m1b = 0.4375;
        double m2a = 0.5625;
        double m2b = 0.875;
        if (s == 2 || s == 5) {
            a = 1.0f - a;
            c = 1.0f - c;
        }
        if (s == 4 || s == 5) {
            if (ReikaMathLibrary.isValueInsideBoundsIncl((double)m1a, (double)m1b, (double)c) && ReikaMathLibrary.isValueInsideBoundsIncl((double)m2a, (double)m2b, (double)b)) {
                return 0;
            }
            if (ReikaMathLibrary.isValueInsideBoundsIncl((double)m2a, (double)m2b, (double)c) && ReikaMathLibrary.isValueInsideBoundsIncl((double)m2a, (double)m2b, (double)b)) {
                return 1;
            }
            if (ReikaMathLibrary.isValueInsideBoundsIncl((double)m2a, (double)m2b, (double)c) && ReikaMathLibrary.isValueInsideBoundsIncl((double)m1a, (double)m1b, (double)b)) {
                return 2;
            }
            if (ReikaMathLibrary.isValueInsideBoundsIncl((double)m1a, (double)m1b, (double)c) && ReikaMathLibrary.isValueInsideBoundsIncl((double)m1a, (double)m1b, (double)b)) {
                return 3;
            }
        } else if (s == 2 || s == 3) {
            if (ReikaMathLibrary.isValueInsideBoundsIncl((double)m1a, (double)m1b, (double)a) && ReikaMathLibrary.isValueInsideBoundsIncl((double)m2a, (double)m2b, (double)b)) {
                return 0;
            }
            if (ReikaMathLibrary.isValueInsideBoundsIncl((double)m2a, (double)m2b, (double)a) && ReikaMathLibrary.isValueInsideBoundsIncl((double)m2a, (double)m2b, (double)b)) {
                return 1;
            }
            if (ReikaMathLibrary.isValueInsideBoundsIncl((double)m2a, (double)m2b, (double)a) && ReikaMathLibrary.isValueInsideBoundsIncl((double)m1a, (double)m1b, (double)b)) {
                return 2;
            }
            if (ReikaMathLibrary.isValueInsideBoundsIncl((double)m1a, (double)m1b, (double)a) && ReikaMathLibrary.isValueInsideBoundsIncl((double)m1a, (double)m1b, (double)b)) {
                return 3;
            }
        }
        return -1;
    }
}

