/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Decoration;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.AOE.TileEntityLampController;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.ModList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockRangedLamp
extends Block {
    private IIcon dark;
    private IIcon light;

    public BlockRangedLamp(Material mat) {
        super(mat);
        this.field_149782_v = 5.0f;
        this.field_149781_w = 10.0f;
        this.field_149762_H = new Block.SoundType("stone", 1.0f, 0.5f);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChromaDeco);
        this.func_149713_g(0);
    }

    public final boolean func_149662_c() {
        return false;
    }

    public final boolean func_149686_d() {
        return false;
    }

    public int getLightValue(IBlockAccess iba, int x, int y, int z) {
        this.func_149713_g(0);
        boolean lit = ((TileEntityRangedLamp)iba.func_147438_o(x, y, z)).isLit();
        if (lit) {
            if (ModList.COLORLIGHT.isLoaded()) {
                int color = this.func_149720_d(iba, x, y, z);
                return ReikaColorAPI.getPackedIntForColoredLight((int)color, (int)15) | 0xF;
            }
            return 15;
        }
        return 0;
    }

    public final AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return ChromaOptions.PANELLAMPCOLLISION.getState() ? null : super.func_149668_a(world, x, y, z);
    }

    public final void func_149683_g() {
        this.setBounds(null);
    }

    public final void func_149719_a(IBlockAccess iba, int x, int y, int z) {
        TileEntity te = iba.func_147438_o(x, y, z);
        if (te instanceof TileEntityRangedLamp) {
            this.setBounds(((TileEntityRangedLamp)te).panel);
        } else {
            this.setBounds(null);
        }
    }

    private void setBounds(ForgeDirection dir) {
        if (dir == null) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        float t = 0.125f;
        float o = 0.0625f;
        float x1 = 0.0f;
        float y1 = 0.0f;
        float z1 = 0.0f;
        float x2 = 1.0f;
        float y2 = 1.0f;
        float z2 = 1.0f;
        switch (dir) {
            case DOWN: {
                y2 = t;
                break;
            }
            case UP: {
                y1 = 1.0f - t;
                break;
            }
            case WEST: {
                x2 = t;
                break;
            }
            case EAST: {
                x1 = 1.0f - t;
                break;
            }
            case NORTH: {
                z2 = t;
                break;
            }
            case SOUTH: {
                z1 = 1.0f - t;
                break;
            }
        }
        if (dir.offsetX == 0) {
            x1 += o;
            x2 -= o;
        }
        if (dir.offsetY == 0) {
            y1 += o;
            y2 -= o;
        }
        if (dir.offsetZ == 0) {
            z1 += o;
            z2 -= o;
        }
        this.func_149676_a(x1, y1, z1, x2, y2, z2);
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityRangedLamp();
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        ChromaISBRH.lamp.setRenderPass(pass);
        return pass <= 1;
    }

    public int func_149645_b() {
        return ChromaISBRH.lamp.getRenderID();
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntityRangedLamp te = new TileEntityRangedLamp();
        world.func_147455_a(x, y, z, (TileEntity)te);
        TileEntityLampController.addLight(te);
        te.setLit(TileEntityLampController.activeSourceInRange(te));
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        TileEntityRangedLamp te = (TileEntityRangedLamp)world.func_147438_o(x, y, z);
        ItemStack is = ep.func_71045_bC();
        if (is != null) {
            int dmg = -1;
            if (ReikaDyeHelper.isDyeItem((ItemStack)is)) {
                dmg = ReikaDyeHelper.getColorFromItem((ItemStack)is).ordinal();
            } else if (ChromaItems.SHARD.matchWith(is)) {
                dmg = is.func_77960_j() % 16;
            }
            if (dmg >= 0 && dmg != world.func_72805_g(x, y, z)) {
                world.func_72921_c(x, y, z, dmg, 3);
                return true;
            }
        }
        ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.TILE.ordinal(), world, x, y, z);
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block old, int oldm) {
        TileEntityRangedLamp te = (TileEntityRangedLamp)world.func_147438_o(x, y, z);
        TileEntityLampController.removeLight(te);
        super.func_149749_a(world, x, y, z, old, oldm);
    }

    public int func_149741_i(int meta) {
        return ReikaColorAPI.getModifiedSat((int)CrystalElement.elements[meta % 16].getColor(), (float)0.7f);
    }

    public int func_149720_d(IBlockAccess iba, int x, int y, int z) {
        return this.func_149741_i(iba.func_72805_g(x, y, z));
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ico.func_94245_a("chromaticraft:lamp");
        this.dark = ico.func_94245_a("chromaticraft:lamp_off");
        this.light = this.field_149761_L;
    }

    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        return this.getLightValue(iba, x, y, z) > 0 ? this.light : this.dark;
    }

    public static class TileEntityRangedLamp
    extends TileEntity
    implements GuiController {
        private boolean lit;
        private boolean inverted;
        private int channel;
        private ForgeDirection panel;

        public boolean isPanel() {
            return this.panel != null;
        }

        public ForgeDirection getPanelSide() {
            return this.panel;
        }

        public boolean isLit() {
            return this.lit;
        }

        public int getChannel() {
            return this.channel;
        }

        public void setChannel(int ch) {
            TileEntityLampController.removeLight(this);
            this.channel = ch;
            TileEntityLampController.addLight(this);
            this.setLit(TileEntityLampController.activeSourceInRange(this));
        }

        public void setPanel(ForgeDirection side) {
            this.panel = side;
        }

        public void invert() {
            this.inverted = !this.inverted;
            this.setLit(this.lit);
        }

        public void setLit(boolean on) {
            this.lit = on != this.inverted;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public boolean canUpdate() {
            return false;
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBT.func_74757_a("on", this.lit);
            NBT.func_74768_a("ch", this.channel);
            if (this.isPanel()) {
                NBT.func_74768_a("side", this.panel.ordinal());
            }
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.lit = NBT.func_74767_n("on");
            this.channel = NBT.func_74762_e("ch");
            if (NBT.func_74764_b("side")) {
                this.panel = ForgeDirection.VALID_DIRECTIONS[NBT.func_74762_e("side")];
            }
        }

        public Packet func_145844_m() {
            NBTTagCompound NBT = new NBTTagCompound();
            this.func_145841_b(NBT);
            S35PacketUpdateTileEntity pack = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, NBT);
            return pack;
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity p) {
            this.func_145839_a(p.field_148860_e);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }
}

