/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension;

import Reika.ChromatiCraft.API.Interfaces.MinerBlock;
import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.ChromatiCraft.World.Dimension.DimensionTuningManager;
import Reika.DragonAPI.Base.BlockReplaceOnBreak;
import Reika.DragonAPI.DragonAPICore;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBedrockCrack
extends BlockReplaceOnBreak
implements MinerBlock {
    private static final IIcon[] crackOverlay = new IIcon[10];

    public BlockBedrockCrack(Material mat) {
        super(mat);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChromaGen);
        this.func_149752_b(Blocks.field_150357_h.field_149781_w);
        this.func_149711_c(12.0f);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        float f = super.func_149712_f(world, x, y, z);
        float f2 = 1.0f - (float)(9 - world.func_72805_g(x, y, z)) / 9.0f * 0.5f;
        return f2 * f;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return this.getDrops(world, x, y, z, metadata, fortune, (EntityPlayer)this.harvesters.get());
    }

    private ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune, EntityPlayer ep) {
        int i;
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        int n = 1 + Math.min(metadata, DragonAPICore.rand.nextInt(1 + metadata + fortune));
        if (ep != null) {
            n = DimensionTuningManager.instance.getTunedDropCount(ep, n, 1, Integer.MAX_VALUE);
        }
        for (i = 0; i < n; ++i) {
            li.add(ChromaStacks.bedrockloot.func_77946_l());
        }
        if (metadata == 9) {
            n = ep != null ? DimensionTuningManager.instance.getTunedDropCount(ep, n, 1, 3) : 1;
            for (i = 0; i < n; ++i) {
                li.add(ChromaStacks.bedrockloot2.func_77946_l());
            }
        }
        return li;
    }

    public Block getBlockReplacedWith(EntityPlayer ep, int x, int y, int z, int oldMeta, boolean willHarvest) {
        return willHarvest && oldMeta > 0 ? this : Blocks.field_150357_h;
    }

    public int getMetaReplacedWith(EntityPlayer ep, int x, int y, int z, int oldMeta, boolean willHarvest) {
        return Math.max(0, oldMeta - 1);
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = Blocks.field_150357_h.field_149761_L;
        for (int i = 0; i < crackOverlay.length; ++i) {
            String s = "chromaticraft:dimgen/bedrockloot/" + i;
            BlockBedrockCrack.crackOverlay[i] = ico.func_94245_a(s);
        }
    }

    public static IIcon getCrackOverlay(int meta) {
        return crackOverlay[meta % 10];
    }

    public static IIcon getCrackOverlay(IBlockAccess world, int x, int y, int z) {
        return BlockBedrockCrack.getCrackOverlay(world.func_72805_g(x, y, z));
    }

    public boolean func_149686_d() {
        return false;
    }

    public final int func_149701_w() {
        return 1;
    }

    public final boolean canRenderInPass(int pass) {
        ChromaISBRH.bedrockCrack.setRenderPass(pass);
        return true;
    }

    public int func_149645_b() {
        return ChromaISBRH.bedrockCrack.getRenderID();
    }

    @Override
    public boolean isMineable(int meta) {
        return true;
    }

    @Override
    public boolean allowSilkTouch(int meta) {
        return false;
    }

    @Override
    public ArrayList<ItemStack> getHarvestItems(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        if (meta == 9) {
            li.add(ChromaStacks.bedrockloot2);
        }
        for (int m = meta; m >= 0; --m) {
            li.addAll(this.getDrops(world, x, y, z, m, fortune));
        }
        return li;
    }

    @Override
    public MinerBlock.MineralCategory getCategory() {
        return MinerBlock.MineralCategory.MISC_UNDERGROUND_VALUABLE;
    }

    @Override
    public Block getReplacedBlock(World world, int x, int y, int z) {
        return Blocks.field_150357_h;
    }
}

