/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension;

import Reika.ChromatiCraft.API.Interfaces.MinerBlock;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.DragonAPI.Auxiliary.ChunkManager;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.TileEntity.ChunkLoadingTile;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDimensionChunkloader
extends Block
implements MinerBlock {
    private final IIcon[][] textures = new IIcon[2][2];

    public BlockDimensionChunkloader(Material mat) {
        super(mat);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChromaGen);
        this.func_149711_c(0.75f);
        this.func_149752_b(6000.0f);
        this.func_149715_a(1.0f);
    }

    public void func_149651_a(IIconRegister ico) {
        this.textures[0][0] = ico.func_94245_a("chromaticraft:dimgen/chunkloader-a");
        this.textures[0][1] = ico.func_94245_a("chromaticraft:dimgen/chunkloader-b");
        this.textures[1][0] = ico.func_94245_a("chromaticraft:dimgen/chunkloader-c");
        this.textures[1][1] = ico.func_94245_a("chromaticraft:dimgen/chunkloader-d");
    }

    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        int a = 0;
        int b = 0;
        switch (ForgeDirection.VALID_DIRECTIONS[s]) {
            case UP: {
                a = x % 2;
                b = z % 2;
                break;
            }
            case DOWN: {
                a = x % 2;
                b = z % 2;
                break;
            }
            case EAST: {
                a = z % 2;
                b = y % 2;
                break;
            }
            case WEST: {
                a = z % 2;
                b = y % 2;
                break;
            }
            case NORTH: {
                a = x % 2;
                b = y % 2;
                break;
            }
            case SOUTH: {
                a = x % 2;
                b = y % 2;
                break;
            }
        }
        a = (a + 2) % 2;
        b = (b + 2) % 2;
        return this.textures[a][b];
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.textures[0][0];
    }

    public boolean hasTileEntity(int meta) {
        return meta == 1;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return meta == 1 ? new TileEntityDimensionChunkloader() : null;
    }

    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        ReikaParticleHelper p = rand.nextInt(3) == 0 ? ReikaParticleHelper.WITCH : ReikaParticleHelper.AMBIENTMOBSPELL;
        p.spawnAroundBlockWithOutset(world, x, y, z, 1, 0.03125);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase e, ItemStack is) {
        if (world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
            world.func_72921_c(x, y, z, 1, 3);
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof TileEntityDimensionChunkloader) {
                ((TileEntityDimensionChunkloader)te).placer = e.func_110124_au();
                ChunkManager.instance.loadChunks((ChunkLoadingTile)((TileEntityDimensionChunkloader)te));
            } else {
                String s = "Missing TileEntity for CC dimension chunkloader @ DIM" + world.field_73011_w.field_76574_g + " " + x + ", " + y + ", " + z + " (" + te + ")";
                ChromatiCraft.logger.logError((Object)s);
                if (e instanceof EntityPlayer) {
                    ReikaChatHelper.sendChatToPlayer((EntityPlayer)((EntityPlayer)e), (String)s);
                }
            }
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block b, int meta) {
        if (this.hasTileEntity(meta)) {
            ((TileEntityDimensionChunkloader)world.func_147438_o(x, y, z)).breakBlock();
        }
        super.func_149749_a(world, x, y, z, b, meta);
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return meta == 1 ? null : super.func_149650_a(meta, rand, fortune);
    }

    @Override
    public boolean isMineable(int meta) {
        return true;
    }

    @Override
    public ArrayList<ItemStack> getHarvestItems(World world, int x, int y, int z, int meta, int fortune) {
        return this.getDrops(world, x, y, z, meta, fortune);
    }

    @Override
    public MinerBlock.MineralCategory getCategory() {
        return MinerBlock.MineralCategory.MISC_UNDERGROUND_VALUABLE;
    }

    @Override
    public Block getReplacedBlock(World world, int x, int y, int z) {
        return Blocks.field_150350_a;
    }

    @Override
    public boolean allowSilkTouch(int meta) {
        return false;
    }

    public static class TileEntityDimensionChunkloader
    extends TileEntity
    implements ChunkLoadingTile {
        private static final int TIMER = 1200;
        private UUID placer;
        private int deletionTimer;

        public void func_145845_h() {
            EntityPlayer ep;
            if (this.placer == null) {
                this.delete("No placer");
            }
            if (this.deletionTimer > 0) {
                --this.deletionTimer;
                if (this.deletionTimer <= 0) {
                    this.delete("Timer Elapsed");
                }
            }
            EntityPlayer entityPlayer = ep = this.placer != null ? this.field_145850_b.func_152378_a(this.placer) : null;
            if (ep != null) {
                if (this.deletionTimer > 0) {
                    this.delete("Reentry");
                } else if (ep.field_70163_u < -250.0) {
                    this.delete("Intentional Exit");
                }
            } else if (this.deletionTimer == 0) {
                ChromatiCraft.logger.log((Object)("Activating chunkloader crystal " + new WorldLocation((TileEntity)this) + " placed by " + this.placer));
                this.deletionTimer = 1200;
            }
        }

        private void delete(String reason) {
            ChromatiCraft.logger.log((Object)("Deleting chunkloader crystal placed by " + this.placer + ": " + reason));
            ChunkManager.instance.unloadChunks((TileEntity)this);
            this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, Blocks.field_150350_a);
        }

        public void breakBlock() {
            ChunkManager.instance.unloadChunks((TileEntity)this);
        }

        public Collection<ChunkCoordIntPair> getChunksToLoad() {
            return ReikaJavaLibrary.makeListFrom((Object)new ChunkCoordIntPair(this.field_145851_c >> 4, this.field_145849_e >> 4));
        }
    }
}

