/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension;

import Reika.ChromatiCraft.API.Interfaces.MinerBlock;
import Reika.ChromatiCraft.Auxiliary.Interfaces.DecoType;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.World.Dimension.DimensionTuningManager;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaPotionHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockDimensionDeco
extends Block
implements MinerBlock {
    private static final ArrayList<IIcon>[] icons = new ArrayList[16];
    private static final Random rand = new Random();

    public BlockDimensionDeco(Material mat) {
        super(mat);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChromaGen);
        this.func_149752_b(5.0f);
        this.func_149711_c(0.75f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess iba, int x, int y, int z, int s) {
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[s];
        return iba.func_147439_a(x, y, z) != this || iba.func_72805_g(x, y, z) != iba.func_72805_g(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ);
    }

    public float func_149737_a(EntityPlayer ep, World world, int x, int y, int z) {
        if (!DimensionTuningManager.TuningThresholds.DECOHARVEST.isSufficientlyTuned(ep)) {
            return -1.0f;
        }
        return super.func_149737_a(ep, world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        if (meta == DimDecoTypes.GEMSTONE.ordinal() && Minecraft.func_71410_x().field_71441_e != null) {
            EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
            return BlockDimensionDeco.getGemStoneColor((IBlockAccess)Minecraft.func_71410_x().field_71441_e, MathHelper.func_76128_c((double)ep.field_70165_t), MathHelper.func_76128_c((double)ep.field_70163_u), MathHelper.func_76128_c((double)ep.field_70161_v));
        }
        return 0xFFFFFF;
    }

    public int func_149720_d(IBlockAccess iba, int x, int y, int z) {
        int meta = iba.func_72805_g(x, y, z);
        if (meta == DimDecoTypes.GEMSTONE.ordinal() || meta == DimDecoTypes.CRYSTALLEAF.ordinal()) {
            return BlockDimensionDeco.getGemStoneColor(iba, x, y, z);
        }
        return 0xFFFFFF;
    }

    public static int getGemStoneColor(IBlockAccess iba, int x, int y, int z) {
        return ReikaColorAPI.getModifiedHue((int)0xFF0000, (int)((x + z * 3 / 2) * 4));
    }

    public int getLightValue(IBlockAccess iba, int x, int y, int z) {
        int meta = iba.func_72805_g(x, y, z);
        if (meta == DimDecoTypes.GEMSTONE.ordinal()) {
            return 0;
        }
        if (meta == DimDecoTypes.CRYSTALLEAF.ordinal()) {
            return 0;
        }
        if (meta == DimDecoTypes.CLIFFGLASS.ordinal()) {
            return 12;
        }
        return 0;
    }

    public int func_149677_c(IBlockAccess iba, int x, int y, int z) {
        int meta = iba.func_72805_g(x, y, z);
        if (meta == DimDecoTypes.GEMSTONE.ordinal() || meta == DimDecoTypes.OCEANSTONE.ordinal()) {
            return iba.func_72802_i(x, y, z, 15);
        }
        return super.func_149677_c(iba, x, y, z);
    }

    public IIcon func_149691_a(int s, int meta) {
        if (icons[meta] == null) {
            ChromatiCraft.logger.logError((Object)("Dimension Deco Type " + DimDecoTypes.list[meta] + " is missing icons!"));
            return Blocks.field_150357_h.field_149761_L;
        }
        return icons[meta].get(0);
    }

    public void func_149651_a(IIconRegister ico) {
        for (int i = 0; i < DimDecoTypes.list.length; ++i) {
            DimDecoTypes deco = DimDecoTypes.list[i];
            int n = deco.numIcons;
            BlockDimensionDeco.icons[i] = new ArrayList();
            for (int k = 0; k < n; ++k) {
                icons[i].add(ico.func_94245_a("chromaticraft:dimgen/" + deco.name().toLowerCase(Locale.ENGLISH) + "/layer_" + k));
                if (!deco.hasSecondaryIcons()) continue;
                icons[i].add(ico.func_94245_a("chromaticraft:dimgen/" + deco.name().toLowerCase(Locale.ENGLISH) + "/layer_" + k + "b"));
            }
        }
    }

    public final int func_149645_b() {
        return ChromaISBRH.dimgen.getRenderID();
    }

    public final boolean func_149662_c() {
        return false;
    }

    public final boolean func_149686_d() {
        return false;
    }

    public final int func_149701_w() {
        return 1;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return DimDecoTypes.list[metadata].canSilkTouch();
    }

    public final boolean canRenderInPass(int pass) {
        ChromaISBRH.dimgen.setRenderPass(pass);
        return pass <= 1;
    }

    public boolean canHarvestBlock(EntityPlayer ep, int meta) {
        return DimDecoTypes.list[meta].requiresPickaxe() ? super.canHarvestBlock(ep, meta) : true;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return DimDecoTypes.list[meta].hasBlockRender() ? ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z) : null;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        DimDecoTypes.list[metadata].addDrops(world, x, y, z, metadata, fortune, li, (EntityPlayer)this.harvesters.get());
        return li;
    }

    @Override
    public boolean isMineable(int meta) {
        return true;
    }

    @Override
    public ArrayList<ItemStack> getHarvestItems(World world, int x, int y, int z, int meta, int fortune) {
        return this.getDrops(world, x, y, z, meta, fortune);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random r) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == DimDecoTypes.GEMSTONE.ordinal()) {
            int n = r.nextInt(5);
            int c = BlockDimensionDeco.getGemStoneColor((IBlockAccess)world, x, y, z);
            int l = ReikaRandomHelper.getRandomBetween((int)10, (int)40);
            double o = 0.03125;
            for (int i = 0; i < n; ++i) {
                double px = ReikaRandomHelper.getRandomBetween((double)((double)x - o), (double)((double)(x + 1) + o));
                double py = ReikaRandomHelper.getRandomBetween((double)((double)y - o), (double)((double)(y + 1) + o));
                double pz = ReikaRandomHelper.getRandomBetween((double)((double)z - o), (double)((double)(z + 1) + o));
                while (new DecimalPosition(px, py, pz).sharesBlock((double)x, (double)y, (double)z)) {
                    px = ReikaRandomHelper.getRandomBetween((double)((double)x - o), (double)((double)(x + 1) + o));
                    py = ReikaRandomHelper.getRandomBetween((double)((double)y - o), (double)((double)(y + 1) + o));
                    pz = ReikaRandomHelper.getRandomBetween((double)((double)z - o), (double)((double)(z + 1) + o));
                }
                float s = 1.0f + r.nextFloat();
                EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz).setIcon(ChromaIcons.FLARE).setColor(c).setLife(l).setRapidExpand().setScale(s);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    public int func_149660_a(World world, int x, int y, int z, int s, float a, float b, float c, int meta) {
        if (meta == DimDecoTypes.GEMSTONE.ordinal() && world.field_72995_K) {
            this.doBreakFX(world, x, y, z);
        }
        return meta;
    }

    public void func_149749_a(World world, int x, int y, int z, Block old, int oldmeta) {
        if (oldmeta == DimDecoTypes.GEMSTONE.ordinal() && world.field_72995_K) {
            this.doBreakFX(world, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer f) {
        int meta = world.func_72805_g(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        if (meta == DimDecoTypes.GEMSTONE.ordinal()) {
            this.doBreakFX(world, target.field_72311_b, target.field_72312_c, target.field_72309_d);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer f) {
        if (meta == DimDecoTypes.GEMSTONE.ordinal()) {
            this.doBreakFX(world, x, y, z);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void doBreakFX(World world, int x, int y, int z) {
        int n = 16 + rand.nextInt(32);
        int c = BlockDimensionDeco.getGemStoneColor((IBlockAccess)world, x, y, z);
        int l = ReikaRandomHelper.getRandomBetween((int)10, (int)40);
        double o = 0.03125;
        for (int i = 0; i < n; ++i) {
            double px = ReikaRandomHelper.getRandomBetween((double)((double)x - o), (double)((double)(x + 1) + o));
            double py = ReikaRandomHelper.getRandomBetween((double)((double)y - o), (double)((double)(y + 1) + o));
            double pz = ReikaRandomHelper.getRandomBetween((double)((double)z - o), (double)((double)(z + 1) + o));
            while (new DecimalPosition(px, py, pz).sharesBlock((double)x, (double)y, (double)z)) {
                px = ReikaRandomHelper.getRandomBetween((double)((double)x - o), (double)((double)(x + 1) + o));
                py = ReikaRandomHelper.getRandomBetween((double)((double)y - o), (double)((double)(y + 1) + o));
                pz = ReikaRandomHelper.getRandomBetween((double)((double)z - o), (double)((double)(z + 1) + o));
            }
            float s = 1.0f + rand.nextFloat();
            EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz).setIcon(ChromaIcons.FLARE).setColor(c).setLife(l).setRapidExpand().setScale(s);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == DimDecoTypes.GEMSTONE.ordinal()) {
            return false;
        }
        return super.canCreatureSpawn(type, world, x, y, z);
    }

    @Override
    public MinerBlock.MineralCategory getCategory() {
        return MinerBlock.MineralCategory.MISC_UNDERGROUND_VALUABLE;
    }

    @Override
    public Block getReplacedBlock(World world, int x, int y, int z) {
        return Blocks.field_150350_a;
    }

    @Override
    public boolean allowSilkTouch(int meta) {
        return DimDecoTypes.list[meta].canSilkTouch();
    }

    public boolean isBeaconBase(IBlockAccess world, int x, int y, int z, int beaconX, int beaconY, int beaconZ) {
        return world.func_72805_g(x, y, z) == DimDecoTypes.FLOATSTONE.ordinal();
    }

    public void func_149670_a(World world, int x, int y, int z, Entity e) {
        super.func_149670_a(world, x, y, z, e);
        if (e instanceof EntityLivingBase) {
            EntityLivingBase elb = (EntityLivingBase)e;
            int meta = world.func_72805_g(x, y, z);
            switch (DimDecoTypes.list[meta]) {
                case AQUA: {
                    elb.func_70066_B();
                    break;
                }
                case LIFEWATER: {
                    if (elb instanceof EntityMob && ((EntityMob)elb).func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
                        elb.func_70097_a(DamageSource.field_76376_m, 4.0f);
                        break;
                    }
                    elb.func_70691_i(2.0f);
                    break;
                }
                case MIASMA: {
                    ArrayList<PotionEffect> map = new ArrayList<PotionEffect>();
                    for (Object o : elb.func_70651_bq()) {
                        PotionEffect ef = (PotionEffect)o;
                        Potion p = Potion.field_76425_a[ef.func_76456_a()];
                        if (ReikaPotionHelper.isBadEffect((Potion)p)) continue;
                        int time = Math.max(24000, ef.func_76459_b());
                        PotionEffect repl = new PotionEffect(p.field_76415_H, time, ef.func_76458_c());
                        repl.setCurativeItems(ef.getCurativeItems());
                        map.add(repl);
                    }
                    for (PotionEffect ef : map) {
                        elb.func_82170_o(ef.func_76456_a());
                        elb.func_70690_d(ef);
                    }
                    break;
                }
            }
        }
    }

    public static enum DimDecoTypes implements DecoType
    {
        MIASMA(1),
        FLOATSTONE(2),
        AQUA(1),
        LIFEWATER(1),
        LATTICE(1),
        GEMSTONE(3),
        CRYSTALLEAF(3),
        OCEANSTONE(2),
        CLIFFGLASS(2),
        GLOWCAVE(10);

        public final int numIcons;
        public static DimDecoTypes[] list;

        private DimDecoTypes(int n2) {
            this.numIcons = n2;
        }

        public ItemStack getItem() {
            return new ItemStack(ChromaBlocks.DIMGEN.getBlockInstance(), 1, this.ordinal());
        }

        @Override
        public boolean hasBlockRender() {
            return this == FLOATSTONE || this == GEMSTONE || this == CRYSTALLEAF || this == OCEANSTONE || this == CLIFFGLASS || this == GLOWCAVE;
        }

        @Override
        public List<IIcon> getIcons(IBlockAccess iba, int x, int y, int z, int pass, Random rand) {
            List<IIcon> li = this.getItemIcons(pass);
            if (this == GLOWCAVE) {
                li.clear();
                if (pass == 1) {
                    int idx = rand.nextInt(16);
                    li.add((IIcon)icons[this.ordinal()].get(2 + idx));
                }
            }
            return li;
        }

        @Override
        public List<IIcon> getItemIcons(int pass) {
            if (icons[this.ordinal()] == null) {
                ChromatiCraft.logger.logError((Object)("Dimension Deco Type " + this + " is missing icons!"));
                return ReikaJavaLibrary.makeListFrom((Object[])new IIcon[]{Blocks.field_150357_h.field_149761_L, Blocks.field_150475_bE.field_149761_L, Blocks.field_150343_Z.field_149761_L, Blocks.field_150474_ac.field_149761_L});
            }
            ArrayList<IIcon> li = new ArrayList<IIcon>();
            int idx = 0;
            for (IIcon ico : icons[this.ordinal()]) {
                if (this.renderIconInPass(idx, pass)) {
                    li.add(ico);
                }
                ++idx;
            }
            return li;
        }

        private boolean renderIconInPass(int idx, int pass) {
            switch (this) {
                case CRYSTALLEAF: 
                case CLIFFGLASS: {
                    return idx >= 1 ? pass == 1 : pass == 0;
                }
                case MIASMA: 
                case LIFEWATER: {
                    return pass == 1;
                }
                case GLOWCAVE: {
                    return idx == pass * 2;
                }
            }
            return pass == 0;
        }

        public boolean requiresPickaxe() {
            return this == FLOATSTONE || this == GEMSTONE || this == OCEANSTONE || this == CLIFFGLASS;
        }

        public boolean canSilkTouch() {
            switch (this) {
                case MIASMA: 
                case LIFEWATER: 
                case LATTICE: 
                case AQUA: {
                    return false;
                }
            }
            return true;
        }

        private void addDrops(World world, int x, int y, int z, int metadata, int fortune, ArrayList<ItemStack> li, EntityPlayer ep) {
            int n = 1;
            switch (this) {
                case GLOWCAVE: {
                    n = ReikaRandomHelper.getRandomBetween((int)1, (int)6);
                }
            }
            if (ep != null) {
                n = DimensionTuningManager.instance.getTunedDropCount(ep, n, 1, this.getMaxDrops());
            }
            for (int i = 0; i < n; ++i) {
                li.add(ChromaItems.DIMGEN.getStackOfMetadata(this.ordinal()));
            }
        }

        private int getMaxDrops() {
            switch (this) {
                case AQUA: {
                    return 24;
                }
                case CRYSTALLEAF: {
                    return 12;
                }
                case FLOATSTONE: {
                    return 3;
                }
                case GLOWCAVE: {
                    return 18;
                }
                case OCEANSTONE: {
                    return 2;
                }
            }
            return 1;
        }

        public boolean hasSecondaryIcons() {
            switch (this) {
                case GLOWCAVE: {
                    return true;
                }
            }
            return false;
        }

        static {
            list = DimDecoTypes.values();
        }
    }
}

