/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure;

import Reika.ChromatiCraft.Auxiliary.OverlayColor;
import Reika.ChromatiCraft.Base.BlockDimensionStructureTile;
import Reika.ChromatiCraft.Base.CrystalTypeBlock;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.TileEntity.StructureBlockTile;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.Dimension.Structure.RayBlendGenerator;
import Reika.DragonAPI.DragonAPICore;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRayblendFloor
extends BlockDimensionStructureTile {
    public BlockRayblendFloor(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityRayblendFloor();
    }

    public int func_149645_b() {
        return ChromaISBRH.rayblendFloor.getRenderID();
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149701_w() {
        return 1;
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ico.func_94245_a("chromaticraft:dimstruct/rayblendfloor");
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileEntityRayblendFloor te = (TileEntityRayblendFloor)world.func_147438_o(x, y, z);
        if (te.isBlocked()) {
            return 0xFFFFFF;
        }
        OverlayColor e = te.getOverlayColor();
        return e != null ? e.getColor() : 0xFFFFFF;
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        super.func_149695_a(world, x, y, z, b);
        TileEntityRayblendFloor te = (TileEntityRayblendFloor)world.func_147438_o(x, y, z);
        te.blockUpdate(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return world.func_147439_a(x, y, z) != this;
    }

    @Override
    protected boolean onRightClicked(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        Block bk;
        ItemStack held = ep.func_71045_bC();
        Block block = bk = held != null ? Block.func_149634_a((Item)held.func_77973_b()) : null;
        if (bk instanceof CrystalTypeBlock) {
            CrystalElement e = CrystalElement.elements[held.func_77960_j()];
            TileEntityRayblendFloor te = (TileEntityRayblendFloor)world.func_147438_o(x, y, z);
            if (!te.allowsCrystalAt(x, z, e)) {
                ChromaSounds.ERROR.playSoundAtBlock(te);
                return true;
            }
            return false;
        }
        return true;
    }

    public static class TileEntityRayblendFloor
    extends StructureBlockTile<RayBlendGenerator> {
        private UUID puzzleID;
        private UUID gridID = DragonAPICore.Reika_UUID;
        private int tileX;
        private int tileZ;
        private boolean isBlocked;
        private CrystalElement cageColor;

        @Override
        public DimensionStructureGenerator.DimensionStructureType getType() {
            return DimensionStructureGenerator.DimensionStructureType.RAYBLEND;
        }

        public boolean allowsCrystalAt(int x, int z, CrystalElement e) {
            RayBlendGenerator g = (RayBlendGenerator)this.getGenerator();
            return g != null && !this.isBlocked && g.allowsCrystalAt(this.field_145850_b, this.puzzleID, x, z, e);
        }

        public OverlayColor getOverlayColor() {
            if (this.cageColor != null) {
                return this.cageColor;
            }
            RayBlendGenerator g = (RayBlendGenerator)this.getGenerator();
            return g != null ? g.getCageColor(this.puzzleID, this.tileX, this.tileZ) : null;
        }

        public boolean isBlocked() {
            return this.isBlocked;
        }

        private void blockUpdate(World world, int x, int y, int z) {
            CrystalElement e;
            RayBlendGenerator g = (RayBlendGenerator)this.getGenerator();
            if (g == null) {
                return;
            }
            Block b = world.func_147439_a(x, y + 1, z);
            int meta = world.func_72805_g(x, y + 1, z);
            CrystalElement crystalElement = e = b instanceof CrystalTypeBlock ? CrystalElement.elements[meta] : null;
            if (e != null) {
                // empty if block
            }
            g.setCrystal(world, this.puzzleID, this.tileX, this.tileZ, e);
        }

        public boolean canUpdate() {
            return false;
        }

        public void populate(UUID uid, UUID grid, int x, int z, boolean blocked, CrystalElement e) {
            this.puzzleID = uid;
            this.gridID = grid;
            this.tileX = x;
            this.tileZ = z;
            this.isBlocked = blocked;
            this.cageColor = e;
        }

        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            if (this.puzzleID != null) {
                NBT.func_74778_a("puzzle", this.puzzleID.toString());
            }
            if (this.gridID != null) {
                NBT.func_74778_a("grid", this.gridID.toString());
            }
            NBT.func_74768_a("tileX", this.tileX);
            NBT.func_74768_a("tileZ", this.tileZ);
            NBT.func_74757_a("blocked", this.isBlocked);
            if (this.cageColor != null) {
                NBT.func_74768_a("cage", this.cageColor.ordinal());
            }
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            if (NBT.func_74764_b("puzzle")) {
                this.puzzleID = UUID.fromString(NBT.func_74779_i("puzzle"));
            }
            if (NBT.func_74764_b("grid")) {
                this.gridID = UUID.fromString(NBT.func_74779_i("grid"));
            }
            this.tileX = NBT.func_74762_e("tileX");
            this.tileZ = NBT.func_74762_e("tileZ");
            this.isBlocked = NBT.func_74767_n("blocked");
            if (NBT.func_74764_b("cage")) {
                this.cageColor = CrystalElement.elements[NBT.func_74762_e("cage")];
            }
        }

        public UUID getGridID() {
            return this.gridID;
        }
    }
}

