/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Block.Dimension.Structure.BlockStructureDataStorage;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSpecialShield
extends BlockStructureShield {
    public static final IIcon[] edgeIcons = new IIcon[4];
    private static final int[] overlays = new int[]{0, 0, 2, 0, 0, 0, 0, 0};
    public static final IIcon[][] overlayIcons = new IIcon[16][ReikaArrayHelper.getMaxValue((int[])overlays)];

    public BlockSpecialShield(Material mat) {
        super(mat);
    }

    public int func_149645_b() {
        return ChromaISBRH.specialShield.getRenderID();
    }

    @Override
    public void func_149651_a(IIconRegister ico) {
        int i;
        for (i = 0; i < BlockStructureShield.BlockType.list.length; ++i) {
            this.icons[i] = ico.func_94245_a("chromaticraft:basic/specialshield_" + i);
            int n = overlays[i];
            for (int k = 0; k < n; ++k) {
                BlockSpecialShield.overlayIcons[i][k] = ico.func_94245_a("chromaticraft:basic/specialshield_" + i + ReikaStringParser.intToAlphaChar((int)k));
            }
        }
        for (i = 0; i < 4; ++i) {
            BlockSpecialShield.edgeIcons[i] = ico.func_94245_a("chromaticraft:basic/side" + i);
        }
    }

    public static int getOverlayIndex(IBlockAccess iba, int x, int y, int z, int meta) {
        return overlays[meta] > 0 ? ((x + z) % overlays[meta] + overlays[meta]) % overlays[meta] : -1;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    @Override
    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        int meta = iba.func_72805_g(x, y, z) % 8;
        return this.icons[meta];
    }

    @Override
    public boolean func_149646_a(IBlockAccess iba, int dx, int dy, int dz, int s) {
        ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[s];
        return iba.func_147439_a(dx, dy, dz) != this || iba.func_72805_g(dx, dy, dz) != iba.func_72805_g(dx - dir.offsetX, dy - dir.offsetY, dz - dir.offsetZ);
    }

    @Override
    public Item func_149650_a(int meta, Random r, int fortune) {
        return Item.func_150898_a((Block)ChromaBlocks.STRUCTSHIELD.getBlockInstance());
    }

    public boolean useNoLighting(IBlockAccess iba, int x, int y, int z) {
        int m = iba.func_72805_g(x, y, z) % 8;
        return m <= 1 || m == 7;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        int meta = world.func_72805_g(x, y, z) % 8;
        return meta <= 1;
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block b) {
        super.func_149695_a(world, x, y, z, b);
        DimensionStructureGenerator gen = BlockSpecialShield.getStructure(world, x, y, z);
        if (gen != null) {
            gen.onBlockUpdate(world, x, y, z, b);
        }
    }

    public static DimensionStructureGenerator getStructure(World world, int x, int y, int z) {
        TileEntity te;
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        int dx = x;
        int dy = y;
        int dz = z;
        Block b2 = world.func_147439_a(dx, dy, dz);
        int meta2 = world.func_72805_g(dx, dy, dz);
        while (b2 instanceof BlockStructureShield && BlockSpecialShield.matchMetas(meta, meta2)) {
            b2 = world.func_147439_a(dx, --dy, dz);
            meta2 = world.func_72805_g(dx, dy, dz);
        }
        b2 = world.func_147439_a(dx, ++dy, dz);
        meta2 = world.func_72805_g(dx, dy, dz);
        while (b2 instanceof BlockStructureShield && BlockSpecialShield.matchMetas(meta, meta2)) {
            b2 = world.func_147439_a(--dx, dy, dz);
            meta2 = world.func_72805_g(dx, dy, dz);
        }
        b2 = world.func_147439_a(++dx, dy, dz);
        meta2 = world.func_72805_g(dx, dy, dz);
        while (b2 instanceof BlockStructureShield && BlockSpecialShield.matchMetas(meta, meta2)) {
            b2 = world.func_147439_a(dx, dy, --dz);
            meta2 = world.func_72805_g(dx, dy, dz);
        }
        if (world.func_147439_a(dx, dy - 1, ++dz) == ChromaBlocks.DIMDATA.getBlockInstance() && (te = world.func_147438_o(dx, dy - 1, dz)) instanceof BlockStructureDataStorage.StructureInterfaceTile) {
            return ((BlockStructureDataStorage.StructureInterfaceTile)te).getStructure();
        }
        return null;
    }

    private static boolean matchMetas(int meta, int meta2) {
        return true;
    }
}

