/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure;

import Reika.ChromatiCraft.Auxiliary.ElementEncodedNumber;
import Reika.ChromatiCraft.Base.BlockDimensionStructureTile;
import Reika.ChromatiCraft.Base.CrystalTypeBlock;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.ItemCrystalBasic;
import Reika.ChromatiCraft.Base.StructureData;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Progression.ProgressionManager;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.DragonAPI.Interfaces.TileEntity.InertIInv;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockStructureDataStorage
extends BlockDimensionStructureTile {
    private final IIcon[][] icons = new IIcon[2][2];

    public BlockStructureDataStorage(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityStructureDataStorage();
            }
            case 1: {
                return new TileEntityStructurePassword();
            }
        }
        return null;
    }

    public void func_149651_a(IIconRegister ico) {
        this.icons[0][0] = ico.func_94245_a("chromaticraft:dimstruct/dimdata");
        this.icons[1][0] = ico.func_94245_a("chromaticraft:dimstruct/dimdata_side");
        this.icons[0][1] = ico.func_94245_a("chromaticraft:dimstruct/dimpassword");
        this.icons[1][1] = ico.func_94245_a("chromaticraft:dimstruct/dimpassword_side");
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.icons[1][meta];
    }

    @Override
    public boolean onRightClicked(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        if (!world.field_72995_K) {
            ((StructureInterfaceTile)world.func_147438_o(x, y, z)).onRightClick(ep, s);
        }
        return true;
    }

    public static class TileEntityStructureDataStorage
    extends StructureInterfaceTile {
        private StructureData data;
        private HashMap<String, Object> extraData;

        @Override
        protected void onDataLoad(DimensionStructureGenerator gen, HashMap<String, Object> map) {
            this.data = gen.createDataStorage();
            if (this.data != null) {
                this.data.load(map);
            }
            this.extraData = map;
        }

        public boolean canUpdate() {
            return true;
        }

        public void func_145845_h() {
            if (this.data != null) {
                this.data.onTileTick(this);
            }
        }

        @Override
        protected void onRightClick(EntityPlayer ep, int s) {
            if (this.data != null) {
                this.data.onInteract(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ep, s, this.extraData);
            }
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            NBTTagCompound dat = NBT.func_74775_l("extra");
            this.extraData = dat != null && !dat.func_82582_d() ? (HashMap)ReikaNBTHelper.getValue((NBTBase)dat) : null;
            this.loadData(this.getStructure(), this.extraData);
        }

        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            if (this.extraData != null && !this.extraData.isEmpty()) {
                NBT.func_74782_a("extra", ReikaNBTHelper.getTagForObject(this.extraData));
            }
        }
    }

    public static class TileEntityStructurePassword
    extends StructureInterfaceTile
    implements InertIInv {
        private ItemStack[] inv = new ItemStack[8];

        @Override
        public void onDataLoad(DimensionStructureGenerator gen, HashMap<String, Object> map) {
        }

        @Override
        protected void onRightClick(EntityPlayer ep, int s) {
            if (!this.checkPassword(ep) && ChromaOptions.canPlayerUseStructureBypass(ep)) {
                ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.STRUCTUREPASS.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }

        public int func_70302_i_() {
            return 8;
        }

        public ItemStack func_70301_a(int slot) {
            return this.inv[slot];
        }

        public ItemStack func_70298_a(int slot, int decr) {
            return ReikaInventoryHelper.decrStackSize((IInventory)this, (int)slot, (int)decr);
        }

        public ItemStack func_70304_b(int slot) {
            return ReikaInventoryHelper.getStackInSlotOnClosing((IInventory)this, (int)slot);
        }

        public void func_70299_a(int slot, ItemStack is) {
            this.inv[slot] = is;
        }

        public String func_145825_b() {
            DimensionStructureGenerator gen = this.getStructure();
            if (gen != null) {
                return gen.getType().getDisplayText() + " " + ReikaStringParser.parseRomanRumeral((int)gen.getGenerationIndex()) + " Bypass";
            }
            return "Structure Bypass";
        }

        public boolean func_145818_k_() {
            return true;
        }

        public int func_70297_j_() {
            return 1;
        }

        public boolean func_70300_a(EntityPlayer ep) {
            return true;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public boolean func_94041_b(int slot, ItemStack is) {
            return this.isValidItem(is.func_77973_b());
        }

        private boolean isValidItem(Item i) {
            return i instanceof ItemCrystalBasic || i instanceof ItemBlock && ((ItemBlock)i).field_150939_a instanceof CrystalTypeBlock;
        }

        public boolean checkPassword(EntityPlayer ep) {
            DimensionStructureGenerator gen = this.getStructure();
            if (gen == null) {
                ChromaSounds.ERROR.playSoundAtBlock(this);
                return false;
            }
            if (gen.forcedOpen()) {
                ChromaSounds.CRAFTDONE.playSoundAtBlock(this);
                return true;
            }
            ElementEncodedNumber pass = new ElementEncodedNumber(gen.getPassword(ep));
            if (ReikaPlayerAPI.isReika((EntityPlayer)ep) || ProgressionManager.instance.hasPlayerCompletedStructureColor(ep, gen.getCoreColor())) {
                ChromaSounds.CRAFTDONE.playSoundAtBlock(this);
                gen.forceOpen(this.field_145850_b, ep);
                return true;
            }
            byte[] chars = new byte[8];
            for (int i = 0; i < 8; ++i) {
                if (this.inv[i] == null) {
                    return false;
                }
                if (!this.func_94041_b(i, this.inv[i])) {
                    return false;
                }
                chars[i] = (byte)(this.inv[i].func_77960_j() % 16);
            }
            boolean match = pass.match(chars);
            if (match) {
                ChromaSounds.CRAFTDONE.playSoundAtBlock(this);
                gen.forceOpen(this.field_145850_b, ep);
                for (int i = 0; i < 8; ++i) {
                    ItemStack is = this.inv[i];
                    ReikaPlayerAPI.addOrDropItem((ItemStack)is, (EntityPlayer)ep);
                }
            } else {
                ChromaSounds.ERROR.playSoundAtBlock(this);
            }
            return match;
        }

        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.inv.length; ++i) {
                if (this.inv[i] == null) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("Slot", (byte)i);
                this.inv[i].func_77955_b(nbttagcompound);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            NBT.func_74782_a("Items", (NBTBase)nbttaglist);
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            NBTTagList nbttaglist = NBT.func_150295_c("Items", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
            this.inv = new ItemStack[this.func_70302_i_()];
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                byte byte0 = nbttagcompound.func_74771_c("Slot");
                if (byte0 < 0 || byte0 >= this.inv.length) continue;
                this.inv[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
            }
        }
    }

    public static abstract class StructureInterfaceTile
    extends TileEntity {
        private UUID structureUID;

        protected abstract void onRightClick(EntityPlayer var1, int var2);

        public final void loadData(DimensionStructureGenerator gen, HashMap<String, Object> map) {
            if (gen == null) {
                return;
            }
            this.structureUID = gen.id;
            this.onDataLoad(gen, map);
        }

        protected abstract void onDataLoad(DimensionStructureGenerator var1, HashMap<String, Object> var2);

        protected final DimensionStructureGenerator getStructure() {
            return DimensionStructureGenerator.getGeneratorByID(this.structureUID);
        }

        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            if (NBT.func_74764_b("uid")) {
                this.structureUID = UUID.fromString(NBT.func_74779_i("uid"));
            }
        }

        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            if (this.structureUID != null) {
                NBT.func_74778_a("uid", this.structureUID.toString());
            }
        }
    }
}

