/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure.Laser;

import Reika.ChromatiCraft.Base.BlockDimensionStructureTile;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.TileEntity.StructureBlockTile;
import Reika.ChromatiCraft.Entity.EntityLaserPulse;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.World.Dimension.Structure.LaserPuzzleGenerator;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.RGBColorData;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLaserEffector
extends BlockDimensionStructureTile {
    public static IIcon baseTexture;
    private static Entity currentCollisionEntity;

    public BlockLaserEffector(Material mat) {
        super(mat);
    }

    @Override
    public boolean onRightClicked(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        LaserEffectType e = LaserEffectType.list[world.func_72805_g(x, y, z)];
        e.onInteract(world, x, y, z, ep);
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (LaserEffectType.list[meta]) {
            case PRISM: {
                return new PrismTile();
            }
            case TARGET: 
            case TARGET_THRU: {
                return new TargetTile();
            }
            case EMITTER: {
                return new EmitterTile();
            }
        }
        return new LaserEffectTile();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        ChromaISBRH.lasereffect.setRenderPass(pass);
        return pass <= 1;
    }

    public int func_149645_b() {
        return ChromaISBRH.lasereffect.getRenderID();
    }

    public void func_149719_a(IBlockAccess iba, int x, int y, int z) {
        if (((LaserEffectTile)iba.func_147438_o((int)x, (int)y, (int)z)).renderAsFullBlock) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        }
    }

    public int getLightValue(IBlockAccess iba, int x, int y, int z) {
        LaserEffectTile te = (LaserEffectTile)iba.func_147438_o(x, y, z);
        return te instanceof TargetTile && ((TargetTile)te).isTriggered() ? (ModList.COLORLIGHT.isLoaded() ? ReikaColorAPI.getPackedIntForColoredLight((int)te.getRenderColor(), (int)15) : 15) : 2;
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment() && world.func_72864_z(x, y, z) && world.func_72805_g(x, y, z) == LaserEffectType.EMITTER.ordinal()) {
            LaserEffectTile te = (LaserEffectTile)world.func_147438_o(x, y, z);
            te.fire();
            return;
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return currentCollisionEntity instanceof EntityPlayer ? super.func_149668_a(world, x, y, z) : null;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List li, Entity e) {
        currentCollisionEntity = e;
        super.func_149743_a(world, x, y, z, mask, li, e);
        currentCollisionEntity = null;
    }

    public void func_149651_a(IIconRegister ico) {
        baseTexture = ico.func_94245_a("chromaticraft:dimstruct/laser_block_base");
        for (LaserEffectType e : LaserEffectType.list) {
            e.frontTexture = ico.func_94245_a("chromaticraft:dimstruct/laser_front/" + e.name().toLowerCase(Locale.ENGLISH) + "_back");
            e.frontOverlay = ico.func_94245_a("chromaticraft:dimstruct/laser_front/" + e.name().toLowerCase(Locale.ENGLISH) + "_front");
        }
    }

    public static class LaserEffectTile
    extends StructureBlockTile<LaserPuzzleGenerator> {
        protected ReikaDirectionHelper.CubeDirections facing = ReikaDirectionHelper.CubeDirections.NORTH;
        protected RGBColorData color = RGBColorData.white();
        private boolean rotateable = true;
        private boolean fixed = false;
        private int rotateableDifficulty = 0;
        public boolean renderAsFullBlock = false;
        public boolean silent = false;
        public double speedFactor = 1.0;
        protected String level = "none";
        public static final boolean PARTIAL_ROTATEABILITY = false;

        public boolean canUpdate() {
            return false;
        }

        public final void setDirection(ReikaDirectionHelper.CubeDirections dir) {
            this.facing = dir;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public final void setColor(RGBColorData c) {
            this.color = c;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        @Override
        public void func_145839_a(NBTTagCompound tag) {
            super.func_145839_a(tag);
            this.color = RGBColorData.white();
            this.color.readFromNBT(tag);
            this.facing = ReikaDirectionHelper.CubeDirections.list[tag.func_74762_e("dir")];
            this.rotateable = tag.func_74767_n("free");
            this.fixed = tag.func_74767_n("fixed");
            this.rotateableDifficulty = tag.func_74762_e("mindiff");
            this.level = tag.func_74779_i("level");
            this.renderAsFullBlock = tag.func_74767_n("fullblock");
            this.silent = tag.func_74767_n("silent");
            this.speedFactor = tag.func_74769_h("speed");
        }

        @Override
        public void func_145841_b(NBTTagCompound tag) {
            super.func_145841_b(tag);
            this.color.writeToNBT(tag);
            tag.func_74768_a("dir", this.facing.ordinal());
            tag.func_74757_a("free", this.rotateable);
            tag.func_74757_a("fixed", this.fixed);
            tag.func_74768_a("mindiff", this.rotateableDifficulty);
            tag.func_74778_a("level", this.level);
            tag.func_74757_a("fullblock", this.renderAsFullBlock);
            tag.func_74757_a("silent", this.silent);
            tag.func_74780_a("speed", this.speedFactor);
        }

        @Override
        public DimensionStructureGenerator.DimensionStructureType getType() {
            return DimensionStructureGenerator.DimensionStructureType.LASER;
        }

        public ReikaDirectionHelper.CubeDirections getFacing() {
            return this.facing;
        }

        public int getRenderColor() {
            return this.color.getRenderColor();
        }

        public void rotate(boolean rev) {
            if (this.isRotateable() && !this.areLasersInPlay()) {
                this.facing = this.facing.getRotation(!rev);
                ReikaSoundHelper.playSoundAtBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (String)"random.click", (float)0.4f, (float)0.5f);
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }

        private boolean areLasersInPlay() {
            LaserPuzzleGenerator gen = (LaserPuzzleGenerator)this.getGenerator();
            if (gen == null) {
                return false;
            }
            return gen.areLasersInPlay(this.level);
        }

        public boolean isRotateable() {
            if (this.rotateableDifficulty > 0 && ChromaOptions.getStructureDifficulty() < this.rotateableDifficulty) {
                return false;
            }
            return !(this instanceof TargetTile) && (this.func_145832_p() != LaserEffectType.EMITTER.ordinal() || DragonAPICore.isReikasComputer()) && !this.fixed;
        }

        public final void fire() {
            if (!this.field_145850_b.field_72995_K) {
                EntityLaserPulse ea = new EntityLaserPulse(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing, this.color, this.level);
                this.affect(ea);
                this.field_145850_b.func_72838_d((Entity)ea);
            }
        }

        protected final void fireParticle(ReikaDirectionHelper.CubeDirections dir, RGBColorData clr, String lvl) {
            if (!this.field_145850_b.field_72995_K) {
                EntityLaserPulse ea = new EntityLaserPulse(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, dir, clr, lvl);
                this.affect(ea);
                this.field_145850_b.func_72838_d((Entity)ea);
            }
        }

        protected final void affect(EntityLaserPulse ea) {
            ea.silentImpact = this.silent;
            ea.setSpeedFactor(this.speedFactor);
        }
    }

    public static class PrismTile
    extends LaserEffectTile {
        private RGBColorData nextPulse = RGBColorData.black();
        private int timer;
        private int timerLength = 2;

        public void addPulse(RGBColorData dat) {
            this.nextPulse.add(dat);
            this.timer = this.timerLength;
        }

        public void func_145845_h() {
            --this.timer;
            if (this.timer == 0 && !this.nextPulse.isBlack()) {
                this.fireParticle(this.facing, this.nextPulse, this.level);
                this.nextPulse = RGBColorData.black();
            }
        }

        @Override
        public boolean canUpdate() {
            return true;
        }

        @Override
        public void func_145839_a(NBTTagCompound tag) {
            super.func_145839_a(tag);
            this.timerLength = tag.func_74762_e("timer");
        }

        @Override
        public void func_145841_b(NBTTagCompound tag) {
            super.func_145841_b(tag);
            tag.func_74768_a("timer", this.timerLength);
        }
    }

    public static class TargetTile
    extends LaserEffectTile {
        private boolean triggered = false;
        public int autoReset = 0;
        private int resetTick;

        public boolean isTriggered() {
            return this.triggered;
        }

        public void func_145845_h() {
            if (this.resetTick > 0) {
                --this.resetTick;
                if (this.resetTick == 0) {
                    this.reset();
                }
            }
        }

        private void reset() {
            this.trigger(false, false, false);
        }

        @Override
        public boolean canUpdate() {
            return true;
        }

        public void trigger(boolean set, boolean doFX, boolean triggerCompletion) {
            LaserPuzzleGenerator gen;
            this.triggered = set;
            if (doFX) {
                if (set) {
                    ChromaSounds.CAST.playSoundAtBlock(this);
                    if (this.field_145850_b.field_72995_K) {
                        this.doFXClient();
                    }
                } else {
                    ChromaSounds.ERROR.playSoundAtBlock(this);
                }
            }
            if (triggerCompletion && !this.field_145850_b.field_72995_K && (gen = (LaserPuzzleGenerator)this.getGenerator()) != null) {
                gen.completeTrigger(this.level, this.field_145850_b, new Coordinate((TileEntity)this), set);
            }
            if (this.autoReset > 0) {
                this.resetTick = this.autoReset;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        @SideOnly(value=Side.CLIENT)
        private void doFXClient() {
            for (int i = 0; i < 32; ++i) {
                double x = ReikaRandomHelper.getRandomPlusMinus((double)((double)this.field_145851_c + 0.5), (double)0.75);
                double y = ReikaRandomHelper.getRandomPlusMinus((double)((double)this.field_145848_d + 0.5), (double)0.5);
                double z = ReikaRandomHelper.getRandomPlusMinus((double)((double)this.field_145849_e + 0.5), (double)0.75);
                int l = ReikaRandomHelper.getRandomBetween((int)8, (int)30);
                EntityBlurFX fx = new EntityCCBlurFX(this.field_145850_b, x, y, z).setColor(this.getRenderColor()).setLife(l);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }

        @Override
        public void func_145839_a(NBTTagCompound tag) {
            super.func_145839_a(tag);
            this.triggered = tag.func_74767_n("trigger");
            this.autoReset = tag.func_74762_e("reset");
        }

        @Override
        public void func_145841_b(NBTTagCompound tag) {
            super.func_145841_b(tag);
            tag.func_74757_a("trigger", this.triggered);
            tag.func_74768_a("reset", this.autoReset);
        }

        public boolean shouldRenderInPass(int pass) {
            return pass <= 1;
        }
    }

    public static class EmitterTile
    extends LaserEffectTile {
        public boolean keepFiring = false;

        public void func_145845_h() {
            if (this.keepFiring && DragonAPICore.rand.nextInt(4) == 0) {
                this.fire();
            }
        }

        @Override
        public boolean canUpdate() {
            return true;
        }

        @Override
        public void func_145839_a(NBTTagCompound tag) {
            super.func_145839_a(tag);
            this.keepFiring = tag.func_74767_n("firing");
        }

        @Override
        public void func_145841_b(NBTTagCompound tag) {
            super.func_145841_b(tag);
            tag.func_74757_a("firing", this.keepFiring);
        }
    }

    public static enum LaserEffectType {
        EMITTER,
        TARGET,
        TARGET_THRU,
        MIRROR,
        DOUBLEMIRROR,
        SLITMIRROR,
        REFRACTOR,
        ONEWAY,
        SPLITTER,
        PRISM,
        COLORIZER,
        POLARIZER;

        public IIcon frontTexture;
        public IIcon frontOverlay;
        public static final LaserEffectType[] list;

        public boolean affectPulse(World world, int x, int y, int z, EntityLaserPulse e) {
            LaserEffectTile te = (LaserEffectTile)world.func_147438_o(x, y, z);
            if (te instanceof TargetTile && e.color.matchColor(te.color) && (e.direction == te.facing || this.isOmniDirectional())) {
                ((TargetTile)te).trigger(true, true, true);
            }
            switch (this) {
                case COLORIZER: {
                    e.color.intersect(te.color);
                    return e.color.isBlack();
                }
                case EMITTER: {
                    return true;
                }
                case MIRROR: {
                    if (!ReikaMathLibrary.isValueInsideBoundsIncl((int)3, (int)5, (int)Math.abs(e.direction.ordinal() - te.facing.ordinal()))) {
                        return true;
                    }
                    e.reflect(te.facing);
                    te.fireParticle(e.direction, e.color, e.getLevel());
                    return true;
                }
                case DOUBLEMIRROR: {
                    ReikaDirectionHelper.CubeDirections dir1 = e.direction.getRotation(true, 2);
                    if (dir1 == te.facing || dir1 == te.facing.getOpposite()) {
                        return true;
                    }
                    ReikaDirectionHelper.CubeDirections dir = te.facing;
                    if (!ReikaMathLibrary.isValueInsideBoundsIncl((int)2, (int)6, (int)Math.abs(e.direction.ordinal() - te.facing.ordinal()))) {
                        dir = dir.getOpposite();
                    }
                    e.reflect(dir);
                    te.fireParticle(e.direction, e.color, e.getLevel());
                    return true;
                }
                case SLITMIRROR: {
                    ReikaDirectionHelper.CubeDirections dir = e.direction.getRotation(true, 2);
                    if (dir != te.facing && dir != te.facing.getOpposite()) {
                        return DOUBLEMIRROR.affectPulse(world, x, y, z, e);
                    }
                    return false;
                }
                case ONEWAY: {
                    return e.direction != te.facing;
                }
                case POLARIZER: {
                    return e.direction != te.facing && e.direction != te.facing.getOpposite();
                }
                case PRISM: {
                    if (e.direction != te.facing.getOpposite()) {
                        boolean b1 = e.direction == te.facing.getRotation(true, 2);
                        boolean b2 = e.direction == te.facing;
                        boolean b3 = e.direction == te.facing.getRotation(false, 2);
                        RGBColorData dat = new RGBColorData(e.color.red && b1, e.color.green && b2, e.color.blue && b3);
                        ((PrismTile)te).addPulse(dat);
                        return true;
                    }
                    if (e.color.red) {
                        te.fireParticle(e.direction.getRotation(true, 2), new RGBColorData(true, false, false), e.getLevel());
                    }
                    if (e.color.green) {
                        te.fireParticle(e.direction, new RGBColorData(false, true, false), e.getLevel());
                    }
                    if (e.color.blue) {
                        te.fireParticle(e.direction.getRotation(false, 2), new RGBColorData(false, false, true), e.getLevel());
                    }
                    return true;
                }
                case REFRACTOR: {
                    int d = (int)MathHelper.func_76138_g((double)(e.direction.angle - te.facing.angle));
                    if (d == 90) {
                        e.refract(false);
                    } else if (d == -45) {
                        e.refract(true);
                    } else {
                        return true;
                    }
                    return false;
                }
                case SPLITTER: {
                    if (e.direction == te.facing) {
                        te.fireParticle(e.direction.getRotation(true), e.color, e.getLevel());
                        te.fireParticle(e.direction.getRotation(false), e.color, e.getLevel());
                    } else if (e.direction == te.facing.getOpposite().getRotation(true) || e.direction == te.facing.getOpposite().getRotation(false)) {
                        e.setDirection(te.facing.getOpposite(), true);
                        return false;
                    }
                    return true;
                }
                case TARGET: {
                    return true;
                }
                case TARGET_THRU: {
                    return false;
                }
            }
            return false;
        }

        public boolean isOmniDirectional() {
            return this == TARGET_THRU || this == COLORIZER;
        }

        public void onInteract(World world, int x, int y, int z, EntityPlayer ep) {
            LaserEffectTile te = (LaserEffectTile)world.func_147438_o(x, y, z);
            if (DragonAPICore.isReikasComputer() && ReikaObfuscationHelper.isDeObfEnvironment()) {
                ItemStack is = ep.func_71045_bC();
                if (ChromaItems.SHARD.matchWith(is)) {
                    int dmg = is.func_77960_j() % 16;
                    if (dmg == CrystalElement.RED.ordinal()) {
                        te.color.red = !te.color.red;
                    } else if (dmg == CrystalElement.GREEN.ordinal()) {
                        te.color.green = !te.color.green;
                    } else if (dmg == CrystalElement.BLUE.ordinal()) {
                        te.color.blue = !te.color.blue;
                    }
                    world.func_147471_g(x, y, z);
                    return;
                }
                if (!this.isOmniDirectional() && is != null && is.func_77973_b() == Items.field_151045_i) {
                    te.rotateable = !te.rotateable;
                    world.func_147471_g(x, y, z);
                    return;
                }
                if (!this.isOmniDirectional() && is != null && is.func_77973_b() == Items.field_151034_e) {
                    te.rotate(false);
                    world.func_147471_g(x, y, z);
                    return;
                }
                if (te instanceof TargetTile && is != null && is.func_77973_b() == Items.field_151114_aO) {
                    ((TargetTile)te).trigger(!((TargetTile)te).isTriggered(), true, false);
                    return;
                }
                if (te instanceof PrismTile && is != null && is.func_77973_b() == Items.field_151166_bC) {
                    ((PrismTile)te).timer++;
                    return;
                }
                if (this == EMITTER && !ep.func_70093_af()) {
                    te.fire();
                    return;
                }
            }
            if (!this.isOmniDirectional() && !world.field_72995_K) {
                te.rotate(ep.func_70093_af());
            }
        }

        static {
            list = LaserEffectType.values();
        }
    }
}

