/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure.LightPanel;

import Reika.ChromatiCraft.Base.BlockDimensionStructureTile;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.TileEntity.StructureBlockTile;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityStructControl;
import Reika.ChromatiCraft.World.Dimension.Structure.LightPanelGenerator;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLightSwitch
extends BlockDimensionStructureTile {
    private final IIcon[] icons = new IIcon[3];

    public BlockLightSwitch(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new LightSwitchTile();
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.icons[s <= 1 ? 0 : 1 + meta];
    }

    public void func_149651_a(IIconRegister ico) {
        this.icons[0] = ico.func_94245_a("chromaticraft:dimstruct/lightpanel");
        this.icons[1] = ico.func_94245_a("chromaticraft:dimstruct/lightpanel_switch_off");
        this.icons[2] = ico.func_94245_a("chromaticraft:dimstruct/lightpanel_switch_on");
    }

    @Override
    public boolean onRightClicked(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        int meta = ReikaMathLibrary.toggleBit((int)world.func_72805_g(x, y, z), (int)0);
        world.func_72921_c(x, y, z, meta, 3);
        if (!world.field_72995_K) {
            TileEntity te2;
            LightSwitchTile te = (LightSwitchTile)world.func_147438_o(x, y, z);
            te.sendState();
            if (te.delegate != null && (te2 = te.delegate.getTileEntity((IBlockAccess)world)) instanceof TileEntityStructControl) {
                ((TileEntityStructControl)te2).onDelegatedTileInteract(world, x, y, z, te, ep);
            }
        }
        ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.click", (float)1.0f, (float)(meta % 2 == 1 ? 0.875f : 0.75f));
        return true;
    }

    public static boolean isSwitchUp(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 1;
    }

    public static class LightSwitchTile
    extends StructureBlockTile<LightPanelGenerator>
    implements TileEntityStructControl.InteractionDelegateTile {
        private int level;
        private int channel;
        private Coordinate delegate;

        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBT.func_74768_a("ch", this.channel);
            NBT.func_74768_a("lvl", this.level);
            if (this.delegate != null) {
                this.delegate.writeToNBT("delegate", NBT);
            }
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.channel = NBT.func_74762_e("ch");
            this.level = NBT.func_74762_e("lvl");
            this.delegate = Coordinate.readFromNBT((String)"delegate", (NBTTagCompound)NBT);
        }

        public void sendState() {
            LightPanelGenerator g = (LightPanelGenerator)this.getGenerator();
            if (g != null) {
                g.toggleSwitch(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.level, this.channel, this.func_145832_p() == 1);
            }
        }

        public void setData(int level, int channel) {
            this.level = level;
            this.channel = channel;
        }

        @Override
        public DimensionStructureGenerator.DimensionStructureType getType() {
            return DimensionStructureGenerator.DimensionStructureType.LIGHTPANEL;
        }

        @Override
        public void setDelegate(Coordinate c) {
            this.delegate = c;
        }
    }
}

