/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure.Locks;

import Reika.ChromatiCraft.Base.BlockDimensionStructureTile;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.TileEntity.StructureBlockTile;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.Dimension.Structure.LocksGenerator;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockColoredLock
extends BlockDimensionStructureTile {
    private IIcon[] icons = new IIcon[2];

    public BlockColoredLock(Material mat) {
        super(mat);
    }

    public void func_149651_a(IIconRegister ico) {
        for (int i = 0; i < 2; ++i) {
            this.icons[i] = ico.func_94245_a("chromaticraft:dimstruct/colorlock_" + i);
        }
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.icons[0];
    }

    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        TileEntity te = iba.func_147438_o(x, y, z);
        return te instanceof TileEntityColorLock && ((TileEntityColorLock)te).isOpen ? this.icons[1] : this.icons[0];
    }

    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        TileEntityColorLock te = (TileEntityColorLock)world.func_147438_o(x, y, z);
        if (te.isOpen && world.func_72805_g(x, y, z) == 0) {
            CrystalElement e = (CrystalElement)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, (Collection)te.colors);
            float r = (float)e.getRed() / 255.0f;
            float g = (float)e.getGreen() / 255.0f;
            float b = (float)e.getBlue() / 255.0f;
            ReikaParticleHelper.spawnColoredParticles((World)world, (int)x, (int)y, (int)z, (double)r, (double)g, (double)b, (int)3);
        }
    }

    @Override
    public boolean onRightClicked(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        ItemStack is = ep.func_71045_bC();
        if (is != null && ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)this)) {
            return false;
        }
        if (ep.field_71075_bZ.field_75098_d) {
            TileEntityColorLock te = (TileEntityColorLock)world.func_147438_o(x, y, z);
            if (ChromaItems.SHARD.matchWith(is)) {
                te.addColor(CrystalElement.elements[is.func_77960_j() % 16]);
            } else if (is == null && ep.func_70093_af()) {
                te.colors.clear();
            } else if (is != null && ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)Blocks.field_150343_Z)) {
                world.func_72921_c(x, y, z, 1, 3);
            }
            te.recalc();
        }
        world.func_147471_g(x, y, z);
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return ChromaISBRH.colorLock.getRenderID();
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te instanceof TileEntityColorLock && ((TileEntityColorLock)te).isOpen ? null : ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityColorLock();
    }

    public void func_149749_a(World world, int x, int y, int z, Block b, int meta) {
        super.func_149749_a(world, x, y, z, b, meta);
    }

    public static class TileEntityColorLock
    extends StructureBlockTile<LocksGenerator> {
        private boolean isOpen;
        private int channel;
        private HashSet<CrystalElement> colors = new HashSet();
        private HashSet<CrystalElement> closedColors = new HashSet();
        private boolean ticked = false;
        private int queueTick;

        public TileEntityColorLock addColor(CrystalElement e) {
            this.colors.add(e);
            this.closedColors.add(e);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return this;
        }

        public void setColors(CrystalElement ... e) {
            this.colors.clear();
            this.closedColors.clear();
            this.colors.addAll(Arrays.asList(e));
            this.closedColors.addAll(this.colors);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        private void open() {
            this.isOpen = true;
            ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (Block)Blocks.field_150348_b, (float)2.0f, (float)1.0f);
            ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (Block)Blocks.field_150348_b, (float)2.0f, (float)1.0f);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        private void close() {
            if (this.queueTick > 0) {
                return;
            }
            this.isOpen = false;
            ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (Block)Blocks.field_150348_b, (float)2.0f, (float)1.0f);
            ReikaSoundHelper.playBreakSound((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (Block)Blocks.field_150348_b, (float)2.0f, (float)1.0f);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public boolean canUpdate() {
            return true;
        }

        public void func_145845_h() {
            if (!this.ticked) {
                this.close();
                this.closedColors.addAll(this.colors);
                this.ticked = true;
            }
            if (this.queueTick > 0) {
                --this.queueTick;
                if (this.queueTick == 0) {
                    this.recalc();
                }
            }
        }

        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBT.func_74757_a("open", this.isOpen);
            NBT.func_74768_a("room", this.channel);
            NBTTagList li = new NBTTagList();
            for (CrystalElement e : this.colors) {
                li.func_74742_a((NBTBase)new NBTTagInt(e.ordinal()));
            }
            NBT.func_74782_a("colors", (NBTBase)li);
            NBTTagList li2 = new NBTTagList();
            for (CrystalElement e : this.closedColors) {
                li2.func_74742_a((NBTBase)new NBTTagInt(e.ordinal()));
            }
            NBT.func_74782_a("closed_colors", (NBTBase)li2);
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.isOpen = NBT.func_74767_n("open");
            this.channel = NBT.func_74762_e("room");
            this.colors.clear();
            NBTTagList li = NBT.func_150295_c("colors", ReikaNBTHelper.NBTTypes.INT.ID);
            for (Object o : li.field_74747_a) {
                NBTTagInt tag = (NBTTagInt)o;
                this.colors.add(CrystalElement.elements[tag.func_150287_d()]);
            }
            this.closedColors.clear();
            NBTTagList li2 = NBT.func_150295_c("closed_colors", ReikaNBTHelper.NBTTypes.INT.ID);
            for (Object o : li2.field_74747_a) {
                NBTTagInt tag = (NBTTagInt)o;
                this.closedColors.add(CrystalElement.elements[tag.func_150287_d()]);
            }
        }

        private void recalcColors() {
            LocksGenerator g = (LocksGenerator)this.getGenerator();
            if (g == null) {
                return;
            }
            boolean flag = true;
            this.closedColors.clear();
            if (g.getWhiteLock(this.channel) <= 0) {
                for (CrystalElement e : this.colors) {
                    if (g.getColorCode(this.channel, e) > 0) continue;
                    flag = false;
                    this.closedColors.add(e);
                }
            }
            this.updateState(flag);
        }

        public void setOpenColors(Collection<CrystalElement> c) {
            this.closedColors.clear();
            this.closedColors.addAll(this.colors);
            this.closedColors.removeAll(c);
            this.recalcColors();
            this.updateState(this.closedColors.isEmpty());
        }

        private void updateState(boolean flag) {
            if (flag != this.isOpen) {
                if (flag) {
                    this.open();
                } else {
                    this.close();
                }
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public Collection<CrystalElement> getColors() {
            return Collections.unmodifiableCollection(this.colors);
        }

        public Collection<CrystalElement> getClosedColors() {
            return Collections.unmodifiableCollection(this.closedColors);
        }

        public int getChannel() {
            return this.channel;
        }

        public boolean isHeldOpen() {
            return this.isOpen && this.queueTick > 0;
        }

        private void recalcGate() {
            this.updateState(((LocksGenerator)this.getGenerator()).getGateCode(this.channel) == 0);
        }

        public void recalc() {
            if (this.func_145832_p() == 0) {
                this.recalcColors();
            } else if (this.func_145832_p() == 1) {
                this.recalcGate();
            }
        }

        public void setChannel(int ch) {
            this.channel = ch;
        }

        public void queueTick(int time) {
            this.queueTick = time;
        }

        @Override
        public DimensionStructureGenerator.DimensionStructureType getType() {
            return DimensionStructureGenerator.DimensionStructureType.LOCKS;
        }
    }
}

