/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure.Locks;

import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.LockLevel;
import Reika.ChromatiCraft.Base.TileEntity.StructureBlockTile;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntitySparkleFX;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityStructControl;
import Reika.ChromatiCraft.World.Dimension.Structure.Locks.LocksRoomBig;
import Reika.ChromatiCraft.World.Dimension.Structure.Locks.LocksRoomEntry;
import Reika.ChromatiCraft.World.Dimension.Structure.Locks.LocksRoomFence;
import Reika.ChromatiCraft.World.Dimension.Structure.Locks.LocksRoomHouse;
import Reika.ChromatiCraft.World.Dimension.Structure.Locks.LocksRoomRecurse;
import Reika.ChromatiCraft.World.Dimension.Structure.Locks.LocksRoomSpiral;
import Reika.ChromatiCraft.World.Dimension.Structure.Locks.LocksRoomTriple;
import Reika.ChromatiCraft.World.Dimension.Structure.Locks.LocksRoomWhite;
import Reika.ChromatiCraft.World.Dimension.Structure.LocksGenerator;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Constructor;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLockKey
extends Block {
    private long lastPlace = -1L;

    public BlockLockKey(Material mat) {
        super(mat);
        this.func_149711_c(0.15f);
        this.func_149647_a((CreativeTabs)(DragonAPICore.isReikasComputer() ? ChromatiCraft.tabChromaGen : null));
        this.func_149715_a(1.0f);
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileEntityLockKey();
    }

    public float func_149737_a(EntityPlayer ep, World world, int x, int y, int z) {
        TileEntity te2;
        TileEntityLockKey te = (TileEntityLockKey)world.func_147438_o(x, y, z);
        if (te.delegate != null && (te2 = te.delegate.getTileEntity((IBlockAccess)world)) instanceof TileEntityStructControl && ((TileEntityStructControl)te2).isInaccessible(world, x, y, z, te, ep)) {
            return -1.0f;
        }
        return super.func_149737_a(ep, world, x, y, z);
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ico.func_94245_a("chromaticraft:dimstruct/key");
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.field_149761_L;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random r) {
        int n = 2 + r.nextInt(2);
        for (int i = 0; i < n; ++i) {
            int l = 10 + r.nextInt(30);
            float s = (float)ReikaRandomHelper.getRandomBetween((double)1.0, (double)1.5);
            EntitySparkleFX fx = new EntitySparkleFX(world, (double)x + r.nextDouble(), (double)y + r.nextDouble(), (double)z + r.nextDouble(), 0.0, 0.0, 0.0).setLife(l).setScale(s);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
    }

    private void openLocks(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        if (this.lastPlace == world.func_82737_E()) {
            return;
        }
        this.lastPlace = world.func_82737_E();
        LocksGenerator gen = BlockLockKey.getGenerator(world, x, y, z);
        if (gen == null) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            Block b = world.func_147439_a(dx, dy, dz);
            int m = world.func_72805_g(dx, dy, dz);
            int ch = world.func_72805_g(x, y, z);
            if (b == ChromaBlocks.RUNE.getBlockInstance()) {
                gen.openColor(CrystalElement.elements[m], world, ch);
                break;
            }
            if (b != ChromaBlocks.STRUCTSHIELD.getBlockInstance() || m % 8 != BlockStructureShield.BlockType.CLOAK.metadata % 8) continue;
            gen.markOpenGate(world, ch);
            break;
        }
    }

    private void closeLocks(World world, int x, int y, int z, int meta2) {
        LocksGenerator gen = BlockLockKey.getGenerator(world, x, y, z);
        if (gen == null) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            Block b = world.func_147439_a(dx, dy, dz);
            int m = world.func_72805_g(dx, dy, dz);
            int ch = meta2;
            if (b == ChromaBlocks.RUNE.getBlockInstance()) {
                gen.closeColor(CrystalElement.elements[m], world, ch);
                break;
            }
            if (b != ChromaBlocks.STRUCTSHIELD.getBlockInstance() || m % 8 != BlockStructureShield.BlockType.CLOAK.metadata % 8) continue;
            gen.markClosedGate(world, ch);
            break;
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block b2, int meta2) {
        if (!world.field_72995_K) {
            TileEntity te2;
            this.closeLocks(world, x, y, z, meta2);
            TileEntityLockKey te = (TileEntityLockKey)world.func_147438_o(x, y, z);
            if (te.delegate != null && (te2 = te.delegate.getTileEntity((IBlockAccess)world)) instanceof TileEntityStructControl) {
                ((TileEntityStructControl)te2).onDelegatedTileRemoved(world, x, y, z, te);
            }
        }
        super.func_149749_a(world, x, y, z, b2, meta2);
    }

    private static LocksGenerator getGenerator(World world, int x, int y, int z) {
        return (LocksGenerator)DimensionStructureGenerator.DimensionStructureType.LOCKS.getGenerator(((TileEntityLockKey)world.func_147438_o((int)x, (int)y, (int)z)).uid);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean harvest) {
        if (this.canHarvest(world, player, x, y, z)) {
            this.func_149636_a(world, player, x, y, z, world.func_72805_g(x, y, z));
        }
        return world.func_147468_f(x, y, z);
    }

    private boolean canHarvest(World world, EntityPlayer ep, int x, int y, int z) {
        return !ep.field_71075_bZ.field_75098_d;
    }

    public void func_149636_a(World world, EntityPlayer ep, int x, int y, int z, int meta) {
        if (!this.canHarvest(world, ep, x, y, z)) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        TileEntityLockKey te = (TileEntityLockKey)world.func_147438_o(x, y, z);
        if (te == null || te.uid == null && te.delegate == null) {
            return;
        }
        ItemStack is = new ItemStack((Block)this, 1, meta);
        is.field_77990_d = new NBTTagCompound();
        if (te.uid != null) {
            is.field_77990_d.func_74778_a("uid", te.uid.toString());
        }
        if (te.delegate != null) {
            te.delegate.writeToNBT("delegate", is.field_77990_d);
        }
        ReikaItemHelper.dropItem((World)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (ItemStack)is);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase elb, ItemStack is) {
        TileEntity te2;
        if (world.field_72995_K) {
            return;
        }
        if (is.field_77990_d == null) {
            return;
        }
        TileEntityLockKey te = (TileEntityLockKey)world.func_147438_o(x, y, z);
        if (is.field_77990_d.func_74764_b("uid")) {
            te.uid = UUID.fromString(is.field_77990_d.func_74779_i("uid"));
        }
        te.delegate = Coordinate.readFromNBT((String)"delegate", (NBTTagCompound)is.field_77990_d);
        this.openLocks(world, x, y, z);
        if (te.delegate != null && (te2 = te.delegate.getTileEntity((IBlockAccess)world)) instanceof TileEntityStructControl) {
            ((TileEntityStructControl)te2).onDelegatedTileAdded(world, x, y, z, te);
        }
    }

    public static class TileEntityLockKey
    extends StructureBlockTile<LocksGenerator>
    implements TileEntityStructControl.InteractionDelegateTile {
        private Coordinate delegate;

        @Override
        public DimensionStructureGenerator.DimensionStructureType getType() {
            return DimensionStructureGenerator.DimensionStructureType.LOCKS;
        }

        @Override
        public void setDelegate(Coordinate c) {
            this.delegate = c;
        }

        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            if (this.delegate != null) {
                this.delegate.writeToNBT("delegate", NBT);
            }
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.delegate = Coordinate.readFromNBT((String)"delegate", (NBTTagCompound)NBT);
        }
    }

    public static enum LockChannel {
        ENTRY("Eniro", 3, LocksRoomEntry.class),
        BIG("Besar", 4, LocksRoomBig.class),
        WHITE("Sapheda", 3, LocksRoomWhite.class),
        TRIPLE("Yerraki", 4, LocksRoomTriple.class),
        RECURSION("Saiki", 5, LocksRoomRecurse.class),
        FENCE("Bera", 4, LocksRoomFence.class),
        HOUSE("Kuka", 5, LocksRoomHouse.class),
        SPIRAL("Karkace", 5, LocksRoomSpiral.class);

        public final String name;
        public final int numberKeys;
        private final Class genClass;
        public static final LockChannel[] lockList;

        private LockChannel(String s, int key, Class c) {
            this.name = s;
            this.numberKeys = key;
            this.genClass = c;
        }

        public LockLevel genRoom(LocksGenerator g) throws Exception {
            Constructor c = this.genClass.getDeclaredConstructor(g.getClass());
            c.setAccessible(true);
            return (LockLevel)c.newInstance(g);
        }

        static {
            lockList = LockChannel.values();
        }
    }
}

