/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure.Music;

import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Base.BlockDimensionStructureTile;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.TileEntity.StructureBlockTile;
import Reika.ChromatiCraft.Block.BlockChromaDoor;
import Reika.ChromatiCraft.Block.Decoration.BlockMusicTrigger;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.World.Dimension.Structure.Music.MusicPuzzle;
import Reika.ChromatiCraft.World.Dimension.Structure.MusicPuzzleGenerator;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMusicMemory
extends BlockDimensionStructureTile {
    private final IIcon[] icons = new IIcon[2];

    public BlockMusicMemory(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileMusicMemory();
    }

    public void func_149651_a(IIconRegister ico) {
        this.icons[0] = ico.func_94245_a("chromaticraft:dimstruct/musicmemory");
        this.icons[1] = ico.func_94245_a("chromaticraft:dimstruct/musicmemory_front");
    }

    public IIcon func_149691_a(int s, int meta) {
        int idx = s == ForgeDirection.NORTH.ordinal() ? 1 : 0;
        return this.icons[idx];
    }

    @Override
    public boolean onRightClicked(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        TileMusicMemory mus;
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_147438_o(x, y, z)) instanceof TileMusicMemory && s == (mus = (TileMusicMemory)te).facing.ordinal()) {
            mus.play();
        }
        return true;
    }

    public static void ping(World world, int x, int y, int z, CrystalElement e, int idx) {
        while (world.func_147439_a(x, y, z - 1) == ChromaBlocks.MUSICTRIGGER.getBlockInstance()) {
            --z;
        }
        int meta = world.func_72805_g(x, y + 1, z);
        x = meta < 8 ? (x -= 4) : (x += 4);
        TileEntity te = world.func_147438_o(x, y, --z);
        if (te instanceof TileMusicMemory) {
            ReikaMusicHelper.MusicKey key = CrystalMusicManager.instance.getKeys(e).get(idx);
            ((TileMusicMemory)te).ping(key);
        }
    }

    public static class TileMusicMemory
    extends StructureBlockTile<MusicPuzzleGenerator> {
        private int tick;
        private int index;
        private boolean isPlaying;
        private List<ReikaMusicHelper.MusicKey> keys = new ArrayList<ReikaMusicHelper.MusicKey>();
        private ForgeDirection facing = ForgeDirection.NORTH;
        private static final int DELAY = 10;
        private int correctIndex = -1;
        private int structureIndex;

        public void program(MusicPuzzle m, int idx) {
            this.keys = m.getMelody();
            this.structureIndex = idx;
        }

        public void ping(ReikaMusicHelper.MusicKey key) {
            if (this.keys.isEmpty()) {
                return;
            }
            ReikaMusicHelper.MusicKey next = this.keys.get(this.correctIndex + 1);
            if (key == next) {
                this.addCorrect();
            } else {
                this.resetCorrect();
            }
        }

        private void addCorrect() {
            ++this.correctIndex;
            if (this.correctIndex == this.keys.size() - 1) {
                this.complete();
            }
        }

        private void complete() {
            ChromaSounds.CAST.playSoundAtBlock(this, 1.0f, 1.0f);
            this.correctIndex = -1;
            int dz = this.field_145849_e + 13;
            ((BlockChromaDoor.TileEntityChromaDoor)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, dz)).open(-1);
            if (!this.field_145850_b.field_72995_K) {
                ((MusicPuzzleGenerator)this.getGenerator()).completePuzzle(this.structureIndex);
            }
        }

        private void resetCorrect() {
            if (this.correctIndex != -1) {
                ChromaSounds.ERROR.playSoundAtBlock(this, 1.0f, 1.0f);
            }
            this.correctIndex = -1;
        }

        public void func_145845_h() {
            if (this.isPlaying) {
                --this.tick;
                if (this.tick == 0) {
                    if (this.index == this.keys.size()) {
                        this.isPlaying = false;
                        this.index = 0;
                    } else {
                        this.playKey(this.keys.get(this.index));
                        ++this.index;
                        this.tick = 10;
                    }
                }
            }
        }

        private void playKey(ReikaMusicHelper.MusicKey key) {
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.MUSICPLAY.ordinal(), (TileEntity)this, (int)24, (int[])new int[]{key.ordinal()});
        }

        @SideOnly(value=Side.CLIENT)
        public void playKeyClient(ReikaMusicHelper.MusicKey key) {
            double rel = key.getRatio(ReikaMusicHelper.MusicKey.C5);
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.DING, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5 - 1.0), (float)1.0f, (float)((float)rel));
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.DING, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5 + 9.0), (float)1.0f, (float)((float)rel));
            for (CrystalElement e : CrystalMusicManager.instance.getColorsWithKey(key)) {
                this.playCrystal(e, key);
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void playCrystal(CrystalElement e, ReikaMusicHelper.MusicKey key) {
            int dy = this.field_145848_d + 1;
            int dx = e.ordinal() >= 8 ? this.field_145851_c - 4 : this.field_145851_c + 4;
            int dz = this.field_145849_e + 1 + e.ordinal() % 8;
            BlockMusicTrigger.createParticle(this.field_145850_b, dx, dy, dz, e);
            int idx = CrystalMusicManager.instance.getIntervalFor(e, key);
            double px = (double)dx + 0.5;
            px = e.ordinal() >= 8 ? (px += 0.75) : (px -= 0.75);
            double pz = (double)dz + 0.5;
            double py = (double)this.field_145848_d + 0.5;
            EntityCCBlurFX fx = new EntityCCBlurFX(this.field_145850_b, px, py, pz);
            fx.setColor(e.getColor()).setLife(30).setScale(3.0f).setRapidExpand().setAlphaFading();
            switch (idx) {
                case 0: {
                    fx.setIcon(ChromaIcons.RING0);
                    break;
                }
                case 1: {
                    fx.setIcon(ChromaIcons.RING1);
                    break;
                }
                case 2: {
                    fx.setIcon(ChromaIcons.RING2);
                    break;
                }
                case 3: {
                    fx.setIcon(ChromaIcons.RING3);
                }
            }
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }

        public void play() {
            if (this.keys == null) {
                return;
            }
            this.isPlaying = true;
            this.index = 0;
            this.tick = 10;
        }

        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBTTagList li = new NBTTagList();
            for (ReikaMusicHelper.MusicKey key : this.keys) {
                li.func_74742_a((NBTBase)new NBTTagInt(key.ordinal()));
            }
            NBT.func_74782_a("keys", (NBTBase)li);
            NBT.func_74768_a("idx", this.structureIndex);
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.keys.clear();
            NBTTagList li = NBT.func_150295_c("keys", ReikaNBTHelper.NBTTypes.INT.ID);
            for (Object o : li.field_74747_a) {
                int idx = ((NBTTagInt)o).func_150287_d();
                this.keys.add(ReikaMusicHelper.MusicKey.getByIndex((int)idx));
            }
            this.structureIndex = NBT.func_74762_e("idx");
        }

        @Override
        public DimensionStructureGenerator.DimensionStructureType getType() {
            return DimensionStructureGenerator.DimensionStructureType.MUSIC;
        }
    }
}

