/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure.PistonTape;

import Reika.ChromatiCraft.Base.BlockDimensionStructureTile;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.TileEntity.StructureBlockTile;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.DoorKey;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.TapeStage;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTapeGenerator;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPistonController
extends BlockDimensionStructureTile {
    private IIcon fireFront;
    private IIcon playFront;
    private IIcon stepFront;

    public BlockPistonController(Material mat) {
        super(mat);
        this.func_149715_a(12.0f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TilePistonPlayback();
            }
            case 1: {
                return new TilePistonTrigger();
            }
            case 2: {
                return new TilePistonCycler();
            }
            case 3: {
                return new TilePistonDisplay();
            }
        }
        return null;
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ico.func_94245_a("chromaticraft:dimstruct/piston_control");
        this.fireFront = ico.func_94245_a("chromaticraft:dimstruct/piston_control_fire");
        this.playFront = ico.func_94245_a("chromaticraft:dimstruct/musicmemory_front");
        this.stepFront = ico.func_94245_a("chromaticraft:dimstruct/piston_control_step");
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.field_149761_L;
    }

    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int side) {
        TilePistonController te = (TilePistonController)iba.func_147438_o(x, y, z);
        if (te.getFacing().ordinal() != side) {
            return this.field_149761_L;
        }
        switch (iba.func_72805_g(x, y, z)) {
            case 0: {
                return this.playFront;
            }
            case 1: {
                return this.fireFront;
            }
            case 2: {
                return this.stepFront;
            }
        }
        return this.field_149761_L;
    }

    @Override
    public boolean onRightClicked(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        TilePistonController te;
        if (!world.field_72995_K && (te = (TilePistonController)world.func_147438_o(x, y, z)).getFacing().ordinal() == s) {
            te.onRightClick();
        }
        return true;
    }

    public static abstract class TilePistonController
    extends StructureBlockTile<PistonTapeGenerator> {
        private ForgeDirection facing;
        private int stageIndex;
        protected int currentDoor;

        public boolean canUpdate() {
            return false;
        }

        public ForgeDirection getFacing() {
            return this.facing != null ? this.facing : ForgeDirection.UNKNOWN;
        }

        public final TapeStage getStage() {
            return ((PistonTapeGenerator)this.getGenerator()).getStage(this.stageIndex);
        }

        protected abstract void onRightClick();

        public final void setData(int stage, ForgeDirection dir) {
            this.stageIndex = stage;
            this.facing = dir;
        }

        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            if (this.facing != null) {
                NBT.func_74768_a("face", this.facing.ordinal());
            }
            NBT.func_74768_a("stage", this.stageIndex);
            NBT.func_74768_a("door", this.currentDoor);
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            if (NBT.func_74764_b("face")) {
                this.facing = ForgeDirection.VALID_DIRECTIONS[NBT.func_74762_e("face")];
            }
            this.stageIndex = NBT.func_74762_e("stage");
            this.currentDoor = NBT.func_74762_e("door");
        }

        protected final void fire() {
            if (this.getGenerator() == null) {
                return;
            }
            this.getStage().fireEmitters(this.field_145850_b, this.currentDoor);
        }

        @Override
        public final DimensionStructureGenerator.DimensionStructureType getType() {
            return DimensionStructureGenerator.DimensionStructureType.PISTONTAPE;
        }

        protected void setDoor(int door) {
            this.currentDoor = door;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public static class TilePistonDisplay
    extends TilePistonController {
        private List<DoorKey> display = new ArrayList<DoorKey>();
        private boolean active;

        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBT.func_74757_a("active", this.active);
            ReikaNBTHelper.writeCollectionToNBT(this.display, (NBTTagCompound)NBT, (String)"display", (ReikaNBTHelper.NBTIO)DoorKey.KeyIO.instance);
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.active = NBT.func_74767_n("active");
            ReikaNBTHelper.readCollectionFromNBT(this.display, (NBTTagCompound)NBT, (String)"display", (ReikaNBTHelper.NBTIO)DoorKey.KeyIO.instance);
        }

        public boolean shouldRenderInPass(int pass) {
            return pass <= 1;
        }

        public AxisAlignedBB getRenderBoundingBox() {
            return ReikaAABBHelper.getBlockAABB((TileEntity)this).func_72314_b(3.0, 3.0, 3.0);
        }

        @Override
        protected void onRightClick() {
            if (!this.field_145850_b.field_72995_K) {
                this.read();
            }
        }

        public void read() {
            TapeStage s = this.getStage();
            if (s != null) {
                this.display = new ArrayList<DoorKey>(s.getDisplayList());
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }

        public List<DoorKey> getDisplayList() {
            return this.display;
        }

        public int getActiveDoor() {
            return this.currentDoor - 1;
        }

        @Override
        public boolean canUpdate() {
            return true;
        }

        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K && this.display.isEmpty()) {
                this.read();
            }
        }

        private void setActive(boolean flag) {
            this.active = flag;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        public boolean isActive() {
            return this.active;
        }
    }

    public static class TilePistonTrigger
    extends TilePistonController {
        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
        }

        @Override
        protected void onRightClick() {
            this.fire();
        }
    }

    public static class TilePistonCycler
    extends TilePistonController {
        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
        }

        @Override
        protected void onRightClick() {
            this.setDoor(this.currentDoor + 1);
            TilePistonController te = (TilePistonController)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            te.setDoor(this.currentDoor);
            if (!this.field_145850_b.field_72995_K) {
                this.getStage().cycle(this.field_145850_b);
            }
        }
    }

    public static class TilePistonPlayback
    extends TilePistonController {
        private static final int DELAY = 70;
        private boolean isPlaying;
        private int tickUntilNextDoor = 70;

        @Override
        public boolean canUpdate() {
            return true;
        }

        public void func_145845_h() {
            if (this.isPlaying && !this.field_145850_b.field_72995_K) {
                if (this.tickUntilNextDoor > 0) {
                    --this.tickUntilNextDoor;
                } else if (this.getStage().cycle(this.field_145850_b)) {
                    this.setDoor(this.currentDoor + 1);
                    if (this.currentDoor == this.getStage().doorCount) {
                        this.tickUntilNextDoor = 70;
                    }
                    if (this.currentDoor >= this.getStage().doorCount) {
                        if (this.currentDoor >= this.getStage().getTotalLength()) {
                            this.setPlaying(false);
                        }
                    } else {
                        this.fire();
                        this.tickUntilNextDoor = 70;
                    }
                }
            }
        }

        @Override
        protected void onRightClick() {
            this.setDoor(0);
            this.setPlaying(true);
            this.fire();
            this.tickUntilNextDoor = 70;
        }

        private void setPlaying(boolean play) {
            this.isPlaying = play;
            this.getDisplay().setActive(play);
        }

        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
        }

        private TilePistonDisplay getDisplay() {
            ForgeDirection dir = ReikaDirectionHelper.getLeftBy90((ForgeDirection)this.getFacing());
            return (TilePistonDisplay)this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX * 2, this.field_145848_d + dir.offsetY - 1, this.field_145849_e + dir.offsetZ * 2);
        }

        @Override
        protected void setDoor(int door) {
            super.setDoor(door);
            this.getDisplay().setDoor(door);
        }
    }
}

