/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure.PistonTape;

import Reika.ChromatiCraft.Auxiliary.Interfaces.LaserPulseEffect;
import Reika.ChromatiCraft.Base.BlockDimensionStructureTile;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.Base.TileEntity.StructureBlockTile;
import Reika.ChromatiCraft.Block.BlockChromaDoor;
import Reika.ChromatiCraft.Entity.EntityLaserPulse;
import Reika.ChromatiCraft.Entity.EntityPistonSpline;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTape.TapeStage;
import Reika.ChromatiCraft.World.Dimension.Structure.PistonTapeGenerator;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Math.Spline;
import Reika.DragonAPI.Instantiable.RGBColorData;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"mcp.mobius.waila.api.IWailaDataProvider"})
public class BlockPistonTarget
extends BlockDimensionStructureTile
implements LaserPulseEffect,
IWailaDataProvider {
    private IIcon emitterOverlay;
    private IIcon doorOverlay;

    public BlockPistonTarget(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 0: {
                return new PistonEmitterTile();
            }
            case 1: {
                return new PistonDoorTile();
            }
        }
        return null;
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.field_149761_L;
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ico.func_94245_a("chromaticraft:dimstruct/piston_target");
        this.doorOverlay = ico.func_94245_a("chromaticraft:dimstruct/piston_emitter_overlay");
        this.emitterOverlay = ico.func_94245_a("chromaticraft:dimstruct/piston_target_overlay");
    }

    @Override
    public boolean onRightClicked(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        return true;
    }

    @Override
    public boolean onImpact(World world, int x, int y, int z, EntityLaserPulse e) {
        PistonEmitterTile te;
        if (world.func_72805_g(x, y, z) == 0 && (te = (PistonEmitterTile)world.func_147438_o(x, y, z)).getFacing() == e.direction.getCardinal()) {
            te.fire(e.color);
        }
        return true;
    }

    public boolean receiveSplineParticle(World world, int x, int y, int z, EntityPistonSpline e) {
        if (world.func_72805_g(x, y, z) == 1) {
            PistonDoorTile te = (PistonDoorTile)world.func_147438_o(x, y, z);
            if (te.color.matchColor(e.color)) {
                te.receive();
            } else {
                ChromaSounds.ERROR.playSoundAtBlock(te);
            }
        }
        return true;
    }

    public IIcon getOverlay(IBlockAccess world, int x, int y, int z, int meta) {
        return meta == 0 ? this.emitterOverlay : this.doorOverlay;
    }

    public int func_149645_b() {
        return ChromaISBRH.piston.getRenderID();
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        ChromaISBRH.piston.setRenderPass(pass);
        return pass <= 1;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public ItemStack getWailaStack(IWailaDataAccessor acc, IWailaConfigHandler config) {
        return null;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public final List<String> getWailaHead(ItemStack is, List<String> tip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        return tip;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public final List<String> getWailaBody(ItemStack is, List<String> tip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        TileEntity te = acc.getTileEntity();
        if (te instanceof PistonDoorTile) {
            tip.add("Color: " + ((PistonDoorTile)te).color.getName());
        }
        return tip;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public final List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return tag;
    }

    public static abstract class PistonTargetTile
    extends StructureBlockTile<PistonTapeGenerator> {
        private int doorBusWidth;
        private int stageIndex;
        private int doorIndex;
        private int doorColorIndex;
        private ForgeDirection facing;

        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            NBT.func_74768_a("index", this.doorColorIndex);
            NBT.func_74768_a("stage", this.stageIndex);
            NBT.func_74768_a("door", this.doorIndex);
            NBT.func_74768_a("bus", this.doorBusWidth);
            if (this.facing != null) {
                NBT.func_74768_a("facing", this.facing.ordinal());
            }
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.doorColorIndex = NBT.func_74762_e("index");
            this.stageIndex = NBT.func_74762_e("stage");
            this.doorIndex = NBT.func_74762_e("door");
            this.doorBusWidth = NBT.func_74762_e("bus");
            if (NBT.func_74764_b("facing")) {
                this.facing = ForgeDirection.VALID_DIRECTIONS[NBT.func_74762_e("facing")];
            }
        }

        public ForgeDirection getFacing() {
            return this.facing;
        }

        public int getSubIndex() {
            return this.doorColorIndex;
        }

        public int getDoorBusWidth() {
            return this.doorBusWidth;
        }

        public final void setData(ForgeDirection dir, int stage, int door, int idx, int w) {
            this.doorColorIndex = idx;
            this.stageIndex = stage;
            this.doorIndex = door;
            this.facing = dir;
            this.doorBusWidth = w;
        }

        @Override
        public DimensionStructureGenerator.DimensionStructureType getType() {
            return DimensionStructureGenerator.DimensionStructureType.PISTONTAPE;
        }

        public int getRenderColor() {
            return 0xFFFFFF;
        }

        public final TapeStage getStage() {
            return ((PistonTapeGenerator)this.getGenerator()).getStage(this.stageIndex);
        }

        public final int getDoor() {
            return this.doorIndex;
        }
    }

    public static class PistonEmitterTile
    extends PistonTargetTile {
        private int doorIndex;
        private Coordinate target = new Coordinate(0, 0, 0);
        private Spline path;

        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            this.target.writeToNBT("target", NBT);
            NBT.func_74768_a("door", this.doorIndex);
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.target = Coordinate.readFromNBT((String)"target", (NBTTagCompound)NBT);
            this.doorIndex = NBT.func_74762_e("door");
        }

        private void fire(RGBColorData clr) {
            if (this.path == null) {
                ChromaSounds.ERROR.playSoundAtBlock(this);
                return;
            }
            EntityPistonSpline e = new EntityPistonSpline(this.field_145850_b, this.path, clr);
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_72838_d((Entity)e);
            }
        }

        public void setTarget(int door, Coordinate tgt, ForgeDirection hallDir, ArrayList<Coordinate> hall) {
            ForgeDirection dir = ReikaDirectionHelper.getLeftBy90((ForgeDirection)hallDir);
            Random rand = new Random(new Coordinate((TileEntity)this).hashCode());
            rand.nextBoolean();
            this.doorIndex = door;
            this.target = tgt;
            this.path = new Spline(Spline.SplineType.CHORDAL);
            DecimalPosition p1 = new DecimalPosition((TileEntity)this);
            DecimalPosition p2 = new DecimalPosition(tgt);
            this.path.addPoint((Spline.SplineAnchor)new Spline.BasicSplinePoint(p1));
            for (Coordinate c : hall) {
                DecimalPosition p = DecimalPosition.getRandomWithin((Coordinate)c, (Random)rand);
                this.path.addPoint((Spline.SplineAnchor)new Spline.BasicSplinePoint(p));
            }
            Coordinate last = hall.get(hall.size() - 1);
            int dl = 3 + this.getDoorBusWidth();
            int dx = last.xCoord + dl * hallDir.offsetX;
            int dz = last.zCoord + dl * hallDir.offsetZ;
            int tx = tgt.xCoord + dir.offsetX * 3;
            int tz = tgt.zCoord + dir.offsetZ * 3;
            int diff = hallDir.offsetX * (tx - dx) + hallDir.offsetZ * (tz - dz);
            while (diff >= 0) {
                double rx = (double)dx + 0.5 - 1.25 + rand.nextDouble() * 2.5;
                double rz = (double)dz + 0.5 - 1.25 + rand.nextDouble() * 2.5;
                double ry = (double)tgt.yCoord + 0.5 - 1.25 + rand.nextDouble() * 2.5;
                DecimalPosition p = new DecimalPosition(rx, ry, rz);
                this.path.addPoint((Spline.SplineAnchor)new Spline.BasicSplinePoint(p));
                diff = hallDir.offsetX * (tx - (dx += hallDir.offsetX * dl)) + hallDir.offsetZ * (tz - (dz += hallDir.offsetZ * dl));
            }
            this.path.addPoint((Spline.SplineAnchor)new Spline.BasicSplinePoint(p2));
        }
    }

    public static class PistonDoorTile
    extends PistonTargetTile {
        private static final int DURATION = 50;
        private Coordinate door = new Coordinate(0, 0, 0);
        private int active;
        protected RGBColorData color = RGBColorData.white();

        private void receive() {
            if (this.getFacing() == null) {
                return;
            }
            if (this.field_145850_b.field_72995_K) {
                this.receptionParticles();
            } else {
                this.setActive(true);
                this.getStage().validate(this.getDoor());
                ChromaSounds.CAST.playSoundAtBlock(this);
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void receptionParticles() {
            Random rand = new Random();
            for (int i = 0; i < 16; ++i) {
                double x = (double)this.field_145851_c + rand.nextDouble();
                double y = (double)this.field_145848_d + rand.nextDouble();
                double z = (double)this.field_145849_e + rand.nextDouble();
                switch (this.getFacing()) {
                    case DOWN: {
                        y = this.field_145848_d;
                        break;
                    }
                    case UP: {
                        y = this.field_145848_d + 1;
                        break;
                    }
                    case WEST: {
                        x = this.field_145851_c;
                        break;
                    }
                    case EAST: {
                        x = this.field_145851_c + 1;
                        break;
                    }
                    case NORTH: {
                        z = this.field_145849_e;
                        break;
                    }
                    case SOUTH: {
                        z = this.field_145849_e + 1;
                        break;
                    }
                }
                float s = (float)ReikaRandomHelper.getRandomBetween((double)0.8, (double)1.5);
                int l = ReikaRandomHelper.getRandomBetween((int)10, (int)40);
                EntityCCBlurFX fx = new EntityCCBlurFX(this.field_145850_b, x, y, z);
                fx.setColor(this.color.getRenderColor()).setScale(s).setLife(l);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }

        private void setActive(boolean active) {
            this.active = active ? 50 : 0;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.checkDoor();
        }

        private void checkDoor() {
            boolean open = true;
            for (Coordinate c : this.getAllTiles()) {
                PistonDoorTile te = (PistonDoorTile)c.getTileEntity((IBlockAccess)this.field_145850_b);
                if (te.isActive()) continue;
                open = false;
                break;
            }
            BlockChromaDoor.setOpen(this.field_145850_b, this.door.xCoord, this.door.yCoord, this.door.zCoord, open);
        }

        private Collection<Coordinate> getAllTiles() {
            ArrayList<Coordinate> li = new ArrayList<Coordinate>();
            ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)this.getFacing());
            Coordinate root = new Coordinate(this.field_145851_c - left.offsetX * this.getSubIndex(), this.field_145848_d, this.field_145849_e - left.offsetZ * this.getSubIndex());
            for (int i = 0; i < this.getDoorBusWidth(); ++i) {
                li.add(root.offset(left, i));
            }
            return li;
        }

        public boolean isActive() {
            return this.active > 0;
        }

        public boolean canUpdate() {
            return true;
        }

        public void func_145845_h() {
            if (this.active > 0) {
                --this.active;
                if (this.active == 0) {
                    this.setActive(false);
                }
            }
        }

        @Override
        public void func_145841_b(NBTTagCompound NBT) {
            super.func_145841_b(NBT);
            this.color.writeToNBT(NBT);
            this.door.writeToNBT("doorLoc", NBT);
        }

        @Override
        public void func_145839_a(NBTTagCompound NBT) {
            super.func_145839_a(NBT);
            this.color.readFromNBT(NBT);
            this.door = Coordinate.readFromNBT((String)"doorLoc", (NBTTagCompound)NBT);
        }

        public void setTarget(Coordinate c) {
            this.door = c;
        }

        public void setColor(RGBColorData c) {
            this.color = c;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }

        @Override
        public int getRenderColor() {
            return this.color.getRenderColor();
        }
    }
}

