/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dimension.Structure.ShiftMaze;

import Reika.ChromatiCraft.Base.BlockDimensionStructure;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.ModList;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"mcp.mobius.waila.api.IWailaDataProvider"})
public class BlockShiftLock
extends BlockDimensionStructure
implements IWailaDataProvider {
    private IIcon[] icons = new IIcon[2];

    public BlockShiftLock(Material mat) {
        super(mat);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta == Passability.BREAKABLE.ordinal() ? 1.0f : super.func_149712_f(world, x, y, z);
    }

    public void func_149651_a(IIconRegister ico) {
        this.icons[0] = ico.func_94245_a("chromaticraft:dimstruct/shiftlock-closed");
        this.icons[1] = ico.func_94245_a("chromaticraft:dimstruct/shiftlock-open");
    }

    public IIcon func_149691_a(int s, int meta) {
        Passability p = Passability.list[meta];
        if (p.isDisguised(s)) {
            return ChromaBlocks.STRUCTSHIELD.getBlockInstance().func_149691_a(0, BlockStructureShield.BlockType.STONE.ordinal());
        }
        return this.icons[p.useOpenTexture() ? 1 : 0];
    }

    @Override
    public boolean onRightClicked(World world, int x, int y, int z, EntityPlayer ep, int s, float a, float b, float c) {
        ItemStack is = ep.func_71045_bC();
        if (is != null && ReikaItemHelper.matchStackWithBlock((ItemStack)is, (Block)this)) {
            return false;
        }
        world.func_147471_g(x, y, z);
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return 0;
    }

    public int func_149701_w() {
        return 1;
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List li, Entity e) {
        if (e == null || e.field_70121_D == null) {
            return;
        }
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z);
        if (e.field_70121_D.func_72326_a(box)) {
            return;
        }
        double d = 0.125;
        Passability p = Passability.list[world.func_72805_g(x, y, z)];
        if (p.isOmniPassable()) {
            return;
        }
        if (p.isPassable(ForgeDirection.DOWN)) {
            box.field_72338_b += d;
        }
        if (p.isPassable(ForgeDirection.UP)) {
            box.field_72337_e -= d;
        }
        if (p.isPassable(ForgeDirection.EAST)) {
            box.field_72336_d -= d;
        }
        if (p.isPassable(ForgeDirection.WEST)) {
            box.field_72340_a += d;
        }
        if (p.isPassable(ForgeDirection.NORTH)) {
            box.field_72339_c += d;
        }
        if (p.isPassable(ForgeDirection.SOUTH)) {
            box.field_72334_f -= d;
        }
        if (box != null && box.func_72326_a(mask)) {
            li.add(box);
        }
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        Passability p = Passability.list[world.func_72805_g(x, y, z)];
        return !p.isPassable(side) && p.isDisguised(side.ordinal());
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 1 ? null : ReikaAABBHelper.getBlockAABB((int)x, (int)y, (int)z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block b, int meta) {
        super.func_149749_a(world, x, y, z, b, meta);
    }

    public boolean func_149646_a(IBlockAccess iba, int dx, int dy, int dz, int s) {
        return super.func_149646_a(iba, dx, dy, dz, s) && iba.func_147439_a(dx, dy, dz) != this;
    }

    public static void setOpen(World world, int x, int y, int z, boolean open) {
        Passability p;
        if (world.func_147439_a(x, y, z) != ChromaBlocks.SHIFTLOCK.getBlockInstance()) {
            return;
        }
        Passability put = p = Passability.list[world.func_72805_g(x, y, z)];
        switch (p) {
            case CLOSED: 
            case OPEN: {
                put = open ? Passability.OPEN : Passability.CLOSED;
                break;
            }
            case EAST_CLOSED: 
            case EAST_OPEN: {
                put = open ? Passability.EAST_OPEN : Passability.EAST_CLOSED;
                break;
            }
            case NORTH_CLOSED: 
            case NORTH_OPEN: {
                put = open ? Passability.NORTH_OPEN : Passability.NORTH_CLOSED;
                break;
            }
            case SOUTH_CLOSED: 
            case SOUTH_OPEN: {
                put = open ? Passability.SOUTH_OPEN : Passability.SOUTH_CLOSED;
                break;
            }
            case WEST_CLOSED: 
            case WEST_OPEN: {
                put = open ? Passability.WEST_OPEN : Passability.WEST_CLOSED;
                break;
            }
        }
        if (put != p) {
            world.func_72921_c(x, y, z, put.ordinal(), 3);
            world.func_147471_g(x, y, z);
            ReikaSoundHelper.playBreakSound((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150348_b);
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public ItemStack getWailaStack(IWailaDataAccessor acc, IWailaConfigHandler config) {
        World world = acc.getWorld();
        MovingObjectPosition mov = acc.getPosition();
        if (mov != null) {
            int x = mov.field_72311_b;
            int y = mov.field_72312_c;
            int z = mov.field_72309_d;
            if (Passability.list[acc.getMetadata()].isDisguised(mov.field_72310_e)) {
                return ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.STONE.metadata);
            }
        }
        return null;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public final List<String> getWailaHead(ItemStack is, List<String> tip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        return tip;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public final List<String> getWailaBody(ItemStack is, List<String> tip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        return tip;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public final List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor acc, IWailaConfigHandler config) {
        return currenttip;
    }

    @DependentMethodStripper.ModDependent(value={ModList.WAILA})
    public final NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return tag;
    }

    public static enum Passability {
        CLOSED,
        OPEN,
        EAST_CLOSED,
        EAST_OPEN,
        WEST_CLOSED,
        WEST_OPEN,
        SOUTH_CLOSED,
        SOUTH_OPEN,
        NORTH_CLOSED,
        NORTH_OPEN,
        CLOSED_HIDDEN,
        EAST_HIDDEN,
        WEST_HIDDEN,
        SOUTH_HIDDEN,
        NORTH_HIDDEN,
        BREAKABLE;

        public static final Passability[] list;

        public boolean useOpenTexture() {
            switch (this) {
                case CLOSED: 
                case EAST_CLOSED: 
                case WEST_CLOSED: 
                case SOUTH_CLOSED: 
                case NORTH_CLOSED: 
                case CLOSED_HIDDEN: {
                    return false;
                }
            }
            return true;
        }

        public boolean isPassable(ForgeDirection side) {
            switch (this) {
                default: {
                    return false;
                }
                case OPEN: {
                    return true;
                }
                case EAST_HIDDEN: 
                case WEST_HIDDEN: {
                    return side.offsetX != 0;
                }
                case EAST_OPEN: {
                    return side == ForgeDirection.EAST;
                }
                case NORTH_OPEN: {
                    return side == ForgeDirection.NORTH;
                }
                case NORTH_HIDDEN: 
                case SOUTH_HIDDEN: {
                    return side.offsetZ != 0;
                }
                case SOUTH_OPEN: {
                    return side == ForgeDirection.SOUTH;
                }
                case WEST_OPEN: 
            }
            return side == ForgeDirection.WEST;
        }

        public boolean isOmniPassable() {
            switch (this) {
                case OPEN: {
                    return true;
                }
            }
            return false;
        }

        public boolean isDisguised(int side) {
            switch (this) {
                case CLOSED_HIDDEN: {
                    return true;
                }
                case EAST_HIDDEN: {
                    return side != ForgeDirection.WEST.ordinal();
                }
                case WEST_HIDDEN: {
                    return side != ForgeDirection.EAST.ordinal();
                }
                case SOUTH_HIDDEN: {
                    return side != ForgeDirection.NORTH.ordinal();
                }
                case NORTH_HIDDEN: {
                    return side != ForgeDirection.SOUTH.ordinal();
                }
                case EAST_CLOSED: 
                case EAST_OPEN: {
                    return side != ForgeDirection.EAST.ordinal();
                }
                case WEST_CLOSED: 
                case WEST_OPEN: {
                    return side != ForgeDirection.WEST.ordinal();
                }
                case SOUTH_CLOSED: 
                case SOUTH_OPEN: {
                    return side != ForgeDirection.SOUTH.ordinal();
                }
                case NORTH_CLOSED: 
                case NORTH_OPEN: {
                    return side != ForgeDirection.NORTH.ordinal();
                }
            }
            return false;
        }

        public static Passability getDirectionalPassability(ForgeDirection dir, boolean open) {
            switch (dir) {
                case EAST: {
                    return open ? EAST_OPEN : EAST_CLOSED;
                }
                case WEST: {
                    return open ? WEST_OPEN : WEST_CLOSED;
                }
                case SOUTH: {
                    return open ? SOUTH_OPEN : SOUTH_CLOSED;
                }
                case NORTH: {
                    return open ? NORTH_OPEN : NORTH_CLOSED;
                }
            }
            return null;
        }

        public static Passability getHiddenPassability(ForgeDirection dir) {
            switch (dir) {
                case EAST: {
                    return EAST_HIDDEN;
                }
                case WEST: {
                    return WEST_HIDDEN;
                }
                case SOUTH: {
                    return SOUTH_HIDDEN;
                }
                case NORTH: {
                    return NORTH_HIDDEN;
                }
            }
            return null;
        }

        static {
            list = Passability.values();
        }
    }
}

