/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dye;

import Reika.ChromatiCraft.Block.Dye.BlockDyeVine;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.ChromatiCraft.World.BiomeRainbowForest;
import Reika.DragonAPI.Base.BlockCustomLeaf;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import Reika.RotaryCraft.API.Interfaces.LeafBlockWithExtras;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDyeLeaf
extends BlockCustomLeaf
implements LeafBlockWithExtras {
    private final boolean decay;

    public BlockDyeLeaf(boolean decay) {
        super(decay);
        this.decay = decay;
    }

    public final int func_149741_i(int dmg) {
        return ReikaDyeHelper.dyes[dmg].getColor();
    }

    public final int func_149720_d(IBlockAccess iba, int x, int y, int z) {
        int dmg = iba.func_72805_g(x, y, z);
        return BlockDyeLeaf.getColor(dmg, BiomeRainbowForest.isDamaged(iba, x, z));
    }

    public static int getColor(int meta, boolean damage) {
        Color c = ReikaDyeHelper.dyes[meta].getJavaColor();
        return damage ? ReikaColorAPI.mixColors((int)0xA0A0A0, (int)ReikaColorAPI.getColorWithBrightnessMultiplier((int)c.getRGB(), (float)0.85f), (float)0.4f) : c.brighter().getRGB();
    }

    public final Item func_149650_a(int id, Random r, int fortune) {
        return Item.func_150898_a((Block)ChromaBlocks.DYESAPLING.getBlockInstance());
    }

    public int func_149692_a(int dmg) {
        return dmg;
    }

    protected void onRandomUpdate(World world, int x, int y, int z, Random r) {
        if (r.nextInt(10) == 0) {
            CrystalElement e = CrystalElement.elements[world.func_72805_g(x, y, z)];
            ArrayList<TileEntityCrystalPylon> c = new ArrayList<TileEntityCrystalPylon>(CrystalNetworker.instance.getNearbyPylons(world, x, y, z, e, 16, false));
            if (c == null || c.isEmpty()) {
                return;
            }
            TileEntityCrystalPylon te = c.get(r.nextInt(c.size()));
            te.speedRegenShortly(4);
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            ProgressStage.DYETREE.stepPlayerTo(player);
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public final ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        float saplingChance = 0.05f;
        float appleChance = 0.005f;
        float dyeChance = 0.1f;
        float rainbowChance = 1.0E-4f;
        saplingChance *= (float)(1 + fortune);
        appleChance *= (float)(1 + fortune * 5);
        dyeChance *= (float)(1 + fortune);
        rainbowChance *= (float)((1 + fortune) * (1 + fortune));
        float berryChance = 0.1f * (float)ReikaMathLibrary.intpow2((int)2, (int)fortune);
        int berryNum = 1;
        while (berryChance > 1.0f) {
            berryChance = Math.max(1.0f, berryChance - 0.5f);
            ++berryNum;
        }
        if (ReikaRandomHelper.doWithChance((double)saplingChance)) {
            li.add(new ItemStack(ChromaBlocks.DYESAPLING.getBlockInstance(), 1, meta));
        }
        if (ReikaRandomHelper.doWithChance((double)appleChance)) {
            li.add(new ItemStack(Items.field_151034_e, 1, 0));
        }
        if (ReikaRandomHelper.doWithChance((double)dyeChance)) {
            li.add(this.getDye(world, x, y, z, meta));
        }
        if (ReikaRandomHelper.doWithChance((double)rainbowChance)) {
            li.add(new ItemStack(ChromaBlocks.RAINBOWSAPLING.getBlockInstance(), 1, 0));
        }
        if (ReikaRandomHelper.doWithChance((double)berryChance)) {
            li.add(ChromaItems.BERRY.getCraftedMetadataProduct(berryNum + (int)berryChance, meta));
        }
        return li;
    }

    public final void func_149690_a(World world, int x, int y, int z, int metadata, float chance, int fortune) {
        if (!world.field_72995_K) {
            ArrayList<ItemStack> li = this.getDrops(world, x, y, z, metadata, fortune);
            for (int i = 0; i < li.size(); ++i) {
                if (!(chance >= 1.0f) && !ReikaRandomHelper.doWithChance((double)chance)) continue;
                this.func_149642_a(world, x, y, z, li.get(i));
            }
        }
    }

    private final ItemStack getDye(World world, int x, int y, int z, int metadata) {
        float c = ChromatiCraft.config.getVanillaDyeChance(metadata);
        if (ReikaRandomHelper.doWithChance((double)c)) {
            return new ItemStack(Items.field_151100_aR, 1, metadata);
        }
        return ChromaItems.DYE.getStackOfMetadata(metadata);
    }

    public final ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack(ChromaBlocks.DYELEAF.getBlockInstance(), 1, world.func_72805_g(x, y, z)));
        return ret;
    }

    protected final ItemStack func_149644_j(int par1) {
        return new ItemStack(ChromaBlocks.DYELEAF.getBlockInstance(), 1, par1);
    }

    public final void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (!ChromaOptions.BLOCKPARTICLES.getState() || rand.nextInt(12) > 0) {
            return;
        }
        double offset = 0.125;
        int meta = world.func_72805_g(x, y, z);
        ReikaDyeHelper dye = ReikaDyeHelper.getColorFromDamage((int)meta);
        Color color = dye.getJavaColor();
        double r = (double)color.getRed() / 255.0;
        double g = (double)color.getGreen() / 255.0;
        double b = (double)dye.getBlue() / 255.0;
        ReikaParticleHelper.spawnColoredParticlesWithOutset((World)world, (int)x, (int)y, (int)z, (double)r, (double)g, (double)b, (int)1, (double)offset);
    }

    public final Item func_149694_d(World par1World, int par2, int par3, int par4) {
        return Item.func_150898_a((Block)ChromaBlocks.DYELEAF.getBlockInstance());
    }

    public boolean decays() {
        return this.decay;
    }

    public boolean showInCreative() {
        return !this.decay;
    }

    public CreativeTabs getCreativeTab() {
        return ChromatiCraft.tabChromaGen;
    }

    public String getFastGraphicsIcon(int meta) {
        return "ChromatiCraft:dye/leaves_opaque";
    }

    public String getFancyGraphicsIcon(int meta) {
        return "ChromatiCraft:dye/leaves";
    }

    public boolean shouldTryDecay(World world, int x, int y, int z, int meta) {
        return this.decays();
    }

    public boolean shouldRandomTick() {
        return false;
    }

    public boolean allowModDecayControl() {
        return true;
    }

    public boolean isNatural() {
        return this.decays();
    }

    public boolean isMatchingLeaf(IBlockAccess iba, int x, int y, int z, int lookX, int lookY, int lookZ) {
        Block b = iba.func_147439_a(lookX, lookY, lookZ);
        return ModList.FORESTRY.isLoaded() && b == ForestryHandler.BlockEntry.LEAF.getBlock() || b == this && iba.func_72805_g(x, y, z) == iba.func_72805_g(lookX, lookY, lookZ);
    }

    public boolean isValidLog(IBlockAccess iba, int thisX, int thisY, int thisZ, int lookX, int lookY, int lookZ) {
        int meta;
        Block b = iba.func_147439_a(lookX, lookY, lookZ);
        return ReikaTreeHelper.getTree((Block)b, (int)(meta = iba.func_72805_g(lookX, lookY, lookZ))) != null || ModWoodList.isModWood((Block)b, (int)meta);
    }

    public int getMaximumLogSearchRadius() {
        return 6;
    }

    public int getMaximumLogSearchDepth() {
        return 5;
    }

    protected int getMetaLimit() {
        return 16;
    }

    public void onPreWoodcutterBreak(World world, int x, int y, int z) {
        LeafBlockWithExtras.breakHangingVines((World)world, (int)x, (int)y, (int)z, b -> b.blockID instanceof BlockDyeVine);
    }

    public ArrayList<ItemStack> getExtraDrops(World world, int x, int y, int z, int fortune) {
        return LeafBlockWithExtras.getExtraDropsForHangingVines((World)world, (int)x, (int)y, (int)z, (int)fortune, b -> b.blockID instanceof BlockDyeVine);
    }
}

