/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dye;

import Reika.ChromatiCraft.Block.Dye.BlockDyeLeaf;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaISBRH;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class BlockDyeVine
extends BlockTallGrass {
    private final boolean isFertile;
    private IIcon glowIcon;
    private final IIcon[] baseIcon = new IIcon[4];

    public BlockDyeVine(boolean fertile) {
        this.isFertile = fertile;
        this.func_149672_a(field_149779_h);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChromaGen);
    }

    public final int func_149741_i(int dmg) {
        return ReikaDyeHelper.dyes[dmg].getColor();
    }

    public final int func_149720_d(IBlockAccess iba, int x, int y, int z) {
        return ReikaColorAPI.mixColors((int)ChromaBlocks.DYELEAF.getBlockInstance().func_149720_d(iba, x, y, z), (int)0x404040, (float)0.7f);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.canBlockStay(world, x, y, z, world.func_72805_g(x, y, z));
    }

    public boolean canBlockStay(World world, int x, int y, int z, int meta) {
        Block at = world.func_147439_a(x, y + 1, z);
        return (at instanceof BlockDyeLeaf || at instanceof BlockDyeVine) && world.func_72805_g(x, y + 1, z) == meta;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(IBlockAccess world, int x, int y, int z, RenderBlocks rb, Tessellator v5, Random rand) {
        IIcon ico = this.func_149673_e(world, x, y, z, rand.nextInt(this.baseIcon.length));
        float fc = (float)ReikaRandomHelper.getRandomBetween((double)0.675, (double)0.875, (Random)rand);
        int c = ReikaColorAPI.mixColors((int)ChromaBlocks.DYELEAF.getBlockInstance().func_149720_d(world, x, y, z), (int)0x404040, (float)fc);
        v5.func_78378_d(c);
        v5.func_78380_c(this.func_149677_c(world, x, y, z));
        float dx = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125, (Random)rand);
        float dz = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.03125, (Random)rand);
        double w = ReikaRandomHelper.getRandomBetween((double)0.0, (double)0.125, (Random)rand);
        v5.func_78372_c(dx, 0.0f, dz);
        ReikaRenderHelper.renderCropTypeTex((IBlockAccess)world, (int)x, (int)y, (int)z, (IIcon)ico, (Tessellator)v5, (RenderBlocks)rb, (double)w, (double)1.0);
        if (this.isFertile) {
            ico = this.glowIcon;
            v5.func_78378_d(CrystalElement.elements[world.func_72805_g(x, y, z)].getColor());
            v5.func_78380_c(240);
            ReikaRenderHelper.renderCropTypeTex((IBlockAccess)world, (int)x, (int)y, (int)z, (IIcon)ico, (Tessellator)v5, (RenderBlocks)rb, (double)w, (double)1.0);
        }
        v5.func_78372_c(-dx, 0.0f, -dz);
    }

    public void func_149651_a(IIconRegister ico) {
        for (int i = 0; i < this.baseIcon.length; ++i) {
            this.baseIcon[i] = ico.func_94245_a("chromaticraft:dye/vine/" + i);
        }
        this.glowIcon = ico.func_94245_a("chromaticraft:dye/vine/glow");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int s, int meta) {
        return this.baseIcon[s % this.baseIcon.length];
    }

    public void func_149666_a(Item it, CreativeTabs cr, List li) {
        for (int i = 0; i < 16; ++i) {
            li.add(new ItemStack(it, 1, i));
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float f = 0.4f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 1.0f, 0.5f + f);
    }

    public int func_149645_b() {
        return ChromaISBRH.dyeVine.getRenderID();
    }

    public boolean func_149705_a(World world, int x, int y, int z, int side, ItemStack is) {
        return world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z) && this.canBlockStay(world, x, y, z, is.func_77960_j());
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (this.isFertile) {
            ret.add(ChromaItems.SHARD.getCraftedMetadataProduct(1 + world.field_73012_v.nextInt(1 + fortune / 2), meta));
        }
        if (world.field_73012_v.nextInt(Math.max(1, 10 - fortune * 2)) == 0) {
            ret.add(ChromaBlocks.DYESAPLING.getStackOfMetadata(meta));
        }
        if (world.field_73012_v.nextInt(Math.max(1, 3 - fortune)) == 0) {
            ret.add(ChromaItems.BERRY.getCraftedMetadataProduct(1 + world.field_73012_v.nextInt(1 + fortune), meta));
        }
        return ret;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        super.func_149695_a(world, x, y, z, b);
        if (world.func_147439_a(x, y, z) == Blocks.field_150350_a) {
            world.func_147439_a(x, y - 1, z).func_149695_a(world, x, y - 1, z, b);
        }
    }
}

