/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Dye;

import Reika.ChromatiCraft.Block.Dye.BlockDyeLeaf;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Entity.EntityBallLightning;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.RainbowTreeEffects;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCFloatingSeedsFX;
import Reika.ChromatiCraft.TileEntity.AOE.TileEntityRainbowBeacon;
import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.ChromatiCraft.World.BiomeRainbowForest;
import Reika.DragonAPI.Base.BlockCustomLeaf;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockRainbowLeaf
extends BlockCustomLeaf {
    private static final boolean TILE = false;

    public boolean decays() {
        return true;
    }

    public boolean showInCreative() {
        return true;
    }

    public boolean allowModDecayControl() {
        return false;
    }

    public CreativeTabs getCreativeTab() {
        return ChromatiCraft.tabChromaGen;
    }

    @SideOnly(value=Side.CLIENT)
    public final int func_149741_i(int dmg) {
        if (LeafMetas.list[dmg].hasTimeColor()) {
            return Color.HSBtoRGB((float)(System.currentTimeMillis() % 7200L) / 7200.0f, 0.7f, 1.0f);
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        int x = MathHelper.func_76128_c((double)ep.field_70165_t);
        int y = MathHelper.func_76128_c((double)(ep.field_70163_u + (double)ep.func_70047_e()));
        int z = MathHelper.func_76128_c((double)ep.field_70161_v);
        return this.func_149720_d((IBlockAccess)world, x, y, z);
    }

    public final int func_149720_d(IBlockAccess iba, int x, int y, int z) {
        int sc = 32;
        int meta = iba.func_147439_a(x, y, z) == this ? iba.func_72805_g(x, y, z) : 0;
        float hue = LeafMetas.list[meta].hasTimeColor() ? (float)(System.currentTimeMillis() % 7200L) / 7200.0f : (float)(ReikaMathLibrary.py3d((double)x, (double)(y * 3), (double)(z + x)) % (double)sc) / (float)sc;
        boolean dmgd = BiomeRainbowForest.isDamaged(iba, x, z);
        return Color.HSBtoRGB(hue, dmgd ? 0.4f : 0.7f, dmgd ? 0.6f : 1.0f);
    }

    public final Item func_149650_a(int id, Random r, int fortune) {
        return Item.func_150898_a((Block)ChromaBlocks.RAINBOWSAPLING.getBlockInstance());
    }

    public int func_149692_a(int dmg) {
        return 0;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            ProgressStage.RAINBOWLEAF.stepPlayerTo(player);
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public final ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        float saplingChance = 0.0125f;
        float appleChance = 0.1f;
        float goldAppleChance = 0.025f;
        float rareGoldAppleChance = ChromaOptions.getRainbowLeafGoldAppleDropChance();
        boolean small = meta == LeafMetas.SMALL.ordinal();
        saplingChance *= (float)(1 + fortune);
        appleChance *= (float)(1 + fortune * 5);
        goldAppleChance *= (float)(1 + fortune * 3);
        rareGoldAppleChance *= (float)(1 + fortune * 3);
        if (small) {
            saplingChance = (float)((double)saplingChance * 0.1);
            appleChance = (float)((double)appleChance * 0.25);
            goldAppleChance = (float)((double)goldAppleChance * 0.1);
            rareGoldAppleChance = 0.0f;
        }
        if (ReikaRandomHelper.doWithChance((double)saplingChance)) {
            li.add(new ItemStack(ChromaBlocks.RAINBOWSAPLING.getBlockInstance(), 1, 0));
        }
        if (ReikaRandomHelper.doWithChance((double)appleChance)) {
            li.add(new ItemStack(Items.field_151034_e, 1, 0));
        }
        if (ReikaRandomHelper.doWithChance((double)goldAppleChance)) {
            li.add(new ItemStack(Items.field_151153_ao, 1, 0));
        }
        if (ReikaRandomHelper.doWithChance((double)rareGoldAppleChance)) {
            li.add(new ItemStack(Items.field_151153_ao, 1, 1));
        }
        li.addAll(this.getDyes(world, x, y, z, fortune, small));
        return li;
    }

    private final ArrayList<ItemStack> getDyes(World world, int x, int y, int z, int fortune, boolean small) {
        int drop = this.getDyeDropCount(fortune, small);
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (int i = 0; i < drop; ++i) {
            CrystalElement e = CrystalElement.randomElement();
            if (ReikaRandomHelper.doWithChance((double)ChromatiCraft.config.getVanillaDyeChance(e))) {
                li.add(new ItemStack(Items.field_151100_aR, 1, e.ordinal()));
                continue;
            }
            li.add(ChromaItems.DYE.getStackOf(e));
        }
        return li;
    }

    private int getDyeDropCount(int fortune, boolean small) {
        int ret = 1 + this.rand.nextInt(3 * (1 + fortune)) + fortune + this.rand.nextInt(1 + fortune * fortune);
        if (small) {
            ret = (int)((double)ret * (0.125 + 0.375 * this.rand.nextDouble()));
        }
        return ret;
    }

    public final void func_149690_a(World world, int x, int y, int z, int metadata, float chance, int fortune) {
        if (!world.field_72995_K) {
            ArrayList<ItemStack> li = this.getDrops(world, x, y, z, metadata, fortune);
            for (int i = 0; i < li.size(); ++i) {
                if (!(chance >= 1.0f) && !ReikaRandomHelper.doWithChance((double)chance)) continue;
                this.func_149642_a(world, x, y, z, li.get(i));
            }
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block b, int meta) {
        super.func_149749_a(world, x, y, z, b, meta);
        if (this.rand.nextInt(10) == 0 && !world.field_72995_K && ChromaOptions.BALLLIGHTNING.getState()) {
            world.func_72838_d((Entity)new EntityBallLightning(world, CrystalElement.randomElement(), (double)x + 0.5, (double)y + 0.5, (double)z + 0.5).setNoDrops());
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase e, ItemStack is) {
        if (e instanceof EntityPlayer) {
            world.func_72921_c(x, y, z, 1, 3);
        }
    }

    public final ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack(ChromaBlocks.RAINBOWLEAF.getBlockInstance()));
        return ret;
    }

    protected final ItemStack func_149644_j(int par1) {
        return new ItemStack(ChromaBlocks.RAINBOWLEAF.getBlockInstance());
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_149734_b(World world, int x, int y, int z, Random rand) {
        int color = this.func_149720_d((IBlockAccess)world, x, y, z);
        float r = (float)ReikaColorAPI.getRed((int)color) / 255.0f;
        float g = (float)ReikaColorAPI.getGreen((int)color) / 255.0f;
        float b = (float)ReikaColorAPI.getBlue((int)color) / 255.0f;
        world.func_72869_a("reddust", (double)x + rand.nextDouble(), (double)y, (double)z + rand.nextDouble(), (double)r, (double)g, (double)b);
        if ((BiomeGlowingCliffs.isGlowingCliffs(world.func_72807_a(x, z)) || ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.isMystAge((World)world)) && world.func_147439_a(x, y + 1, z) != this) {
            color = ReikaColorAPI.getModifiedSat((int)color, (float)10.0f);
            float s = 0.75f + rand.nextFloat() * 0.5f;
            ChromaIcons ico = ChromaIcons.FADE_GENTLE;
            EntityCCFloatingSeedsFX fx = new EntityCCFloatingSeedsFX(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble(), (double)z + rand.nextDouble(), 0.0, 90.0, ico);
            fx.freedom *= 4.0;
            fx.angleVelocity *= 4.0;
            fx.setColor(color).setScale(s);
            EntityCCFloatingSeedsFX fx2 = new EntityCCFloatingSeedsFX(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble(), (double)z + rand.nextDouble(), 0.0, 90.0, ico);
            fx2.setColor(ReikaColorAPI.mixColors((int)color, (int)0xFFFFFF, (float)0.5f)).setScale(s * 0.66f).lockTo((EntityFX)fx);
            EntityCCFloatingSeedsFX fx3 = new EntityCCFloatingSeedsFX(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble(), (double)z + rand.nextDouble(), 0.0, 90.0, ico);
            fx3.setColor(0xFFFFFF).setScale(s * 0.33f).lockTo((EntityFX)fx);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx3);
        }
    }

    public final Item func_149694_d(World par1World, int par2, int par3, int par4) {
        return Item.func_150898_a((Block)ChromaBlocks.RAINBOWLEAF.getBlockInstance());
    }

    public String getFastGraphicsIcon(int meta) {
        return "ChromatiCraft:dye/leaves_opaque";
    }

    public String getFancyGraphicsIcon(int meta) {
        return "ChromatiCraft:dye/leaves";
    }

    public boolean shouldTryDecay(World world, int x, int y, int z, int meta) {
        return meta != LeafMetas.PLACED.ordinal();
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 90;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (world instanceof World) {
            RainbowTreeEffects.instance.addInstability((World)world, x, y, z);
        }
        return 180;
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion e) {
        RainbowTreeEffects.instance.addInstability(world, x, y, z);
    }

    public boolean hasTileEntity(int meta) {
        return false;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return this.hasTileEntity(meta) ? new TileEntityRainbowBeacon() : null;
    }

    protected void onRandomUpdate(World world, int x, int y, int z, Random r) {
        RainbowTreeEffects.instance.doRainbowTreeEffects(world, x, y, z, 1.0f, 1.0, r, true);
    }

    public boolean shouldRandomTick() {
        return true;
    }

    public boolean isNatural() {
        return true;
    }

    public boolean isMatchingLeaf(IBlockAccess iba, int thisX, int thisY, int thisZ, int lookX, int lookY, int lookZ) {
        return iba.func_147439_a(lookX, lookY, lookZ) == this;
    }

    public boolean isValidLog(IBlockAccess iba, int thisX, int thisY, int thisZ, int lookX, int lookY, int lookZ) {
        return ((BlockDyeLeaf)ChromaBlocks.DECAY.getBlockInstance()).isValidLog(iba, thisX, thisY, thisZ, lookX, lookY, lookZ);
    }

    public int getMaximumLogSearchRadius() {
        return 18;
    }

    public int getMaximumLogSearchDepth() {
        return 15;
    }

    protected int getMetaLimit() {
        return LeafMetas.list.length;
    }

    public static enum LeafMetas {
        BASIC,
        PLACED,
        TILE,
        TIMECOLOR,
        TIMECOLORTILE,
        SMALL;

        public static final LeafMetas[] list;

        public boolean hasTile() {
            return this == TILE || this == TIMECOLORTILE;
        }

        public boolean hasTimeColor() {
            return this == TIMECOLOR || this == TIMECOLORTILE;
        }

        static {
            list = LeafMetas.values();
        }
    }
}

