/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Worldgen;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Auxiliary.ProgressiveRecursiveBreaker;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.GeoStrata.API.RockProofStone;
import com.carpentersblocks.api.IWrappableBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"com.carpentersblocks.api.IWrappableBlock"})
public class BlockCliffStone
extends Block
implements RockProofStone,
IWrappableBlock {
    private IIcon grassTop;
    private IIcon stoneBlendUp;
    private IIcon stoneBlendDown;
    private IIcon stoneBlendUp_Dirt;
    private IIcon stoneBlendUp_Sand;
    private IIcon stoneBlendUp_Clay;
    private IIcon farmlandTop;
    private final IIcon[][] stoneTextures = new IIcon[2][2];
    private static final ProgressiveRecursiveBreaker.BreakerCallback cliffStoneTransparifier = new ProgressiveRecursiveBreaker.BreakerCallback(){

        public void onPostBreak(ProgressiveRecursiveBreaker.ProgressiveBreaker b, World world, int x, int y, int z, Block id, int meta) {
            world.func_147465_d(x, y, z, id, Variants.STONE.getMeta(false, true), 2);
            for (int i = -1; i <= 4; ++i) {
                world.func_147451_t(x, y + i, z);
            }
            ReikaSoundHelper.playPlaceSound((World)world, (int)x, (int)y, (int)z, (Block)id);
        }

        public boolean canBreak(ProgressiveRecursiveBreaker.ProgressiveBreaker b, World world, int x, int y, int z, Block id, int meta) {
            return id == ChromaBlocks.CLIFFSTONE.getBlockInstance() && meta == Variants.STONE.getMeta(false, false);
        }

        public void onPreBreak(ProgressiveRecursiveBreaker.ProgressiveBreaker b, World world, int x, int y, int z, Block id, int meta) {
        }

        public void onFinish(ProgressiveRecursiveBreaker.ProgressiveBreaker b) {
        }
    };

    public BlockCliffStone(Material m) {
        super(m);
        this.func_149647_a((CreativeTabs)ChromatiCraft.tabChromaGen);
    }

    public float func_149737_a(EntityPlayer ep, World world, int x, int y, int z) {
        return Variants.getVariant(world.func_72805_g(x, y, z)).proxy.func_149737_a(ep, world, x, y, z);
    }

    public float getExplosionResistance(Entity e, World world, int x, int y, int z, double ex, double ey, double ez) {
        return Variants.getVariant(world.func_72805_g(x, y, z)).proxy.getExplosionResistance(e, world, x, y, z, ex, ey, ez);
    }

    public static boolean transparify(World world, int x, int y, int z, EntityPlayer ep) {
        if (world.field_72995_K) {
            return false;
        }
        Block id = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (id == ChromaBlocks.CLIFFSTONE.getBlockInstance() && meta == Variants.STONE.getMeta(false, false)) {
            int depth = 30;
            ProgressiveRecursiveBreaker.ProgressiveBreaker br = ProgressiveRecursiveBreaker.instance.addCoordinateWithReturn(world, x, y, z, depth);
            br.call = cliffStoneTransparifier;
            br.drops = false;
            br.extraSpread = true;
            br.player = ep;
            br.causeUpdates = false;
            return true;
        }
        return false;
    }

    public int func_149692_a(int meta) {
        Variants v = Variants.getVariant(meta);
        if (v == Variants.GRASS) {
            v = Variants.DIRT;
        }
        return v.getMeta(false, false);
    }

    public IIcon func_149691_a(int s, int meta) {
        Variants v = Variants.getVariant(meta);
        switch (v) {
            case DIRT: {
                return v.baseTexture;
            }
            case GRASS: {
                return s == 0 ? Variants.DIRT.baseTexture : (s == 1 ? this.grassTop : v.baseTexture);
            }
            case STONE: {
                return v.baseTexture;
            }
            case FARMLAND: {
                return s == 1 ? this.farmlandTop : Blocks.field_150346_d.func_149691_a(s, meta);
            }
        }
        return Blocks.field_150353_l.func_149691_a(0, 0);
    }

    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        int meta = iba.func_72805_g(x, y, z);
        Variants v = Variants.getVariant(meta);
        if (v == Variants.DIRT) {
            if (s == 0) {
                if (iba.func_147439_a(x, y - 1, z) == Blocks.field_150350_a) {
                    return Variants.STONE.baseTexture;
                }
            } else if (s > 1 && (iba.func_72805_g(x, y - 1, z) != meta || iba.func_147439_a(x, y - 1, z) != this)) {
                return v.blend[0];
            }
        } else if (v == Variants.STONE) {
            int a = 0;
            int b = 0;
            switch (ForgeDirection.VALID_DIRECTIONS[s]) {
                case UP: {
                    a = x % 2;
                    b = z % 2;
                    break;
                }
                case DOWN: {
                    a = x % 2;
                    b = z % 2;
                    break;
                }
                case EAST: {
                    a = z % 2;
                    b = y % 2;
                    break;
                }
                case WEST: {
                    a = z % 2;
                    b = y % 2;
                    break;
                }
                case NORTH: {
                    a = x % 2;
                    b = y % 2;
                    break;
                }
                case SOUTH: {
                    a = x % 2;
                    b = y % 2;
                    break;
                }
            }
            a = (a + 2) % 2;
            b = (b + 2) % 2;
            return this.stoneTextures[b][a];
        }
        return super.func_149673_e(iba, x, y, z, s);
    }

    public void func_149651_a(IIconRegister ico) {
        for (int i = 0; i < Variants.list.length; ++i) {
            Variants v = Variants.list[i];
            v.registerIcons(ico);
        }
        this.grassTop = ico.func_94245_a("chromaticraft:cliffstone/grass_top_base");
        this.farmlandTop = ico.func_94245_a("chromaticraft:cliffstone/farmland_top");
        this.stoneBlendUp = ico.func_94245_a("chromaticraft:cliffstone/stone_blend_up");
        this.stoneBlendDown = ico.func_94245_a("chromaticraft:cliffstone/stone_blend_down");
        this.stoneBlendUp_Dirt = ico.func_94245_a("chromaticraft:cliffstone/stone_vblend_up");
        this.stoneBlendUp_Clay = ico.func_94245_a("chromaticraft:cliffstone/stone_vblend_up_clay");
        this.stoneBlendUp_Sand = ico.func_94245_a("chromaticraft:cliffstone/stone_vblend_up_sand");
        this.stoneTextures[0][0] = ico.func_94245_a("chromaticraft:cliffstone/stone_base_0");
        this.stoneTextures[0][1] = ico.func_94245_a("chromaticraft:cliffstone/stone_base_1");
        this.stoneTextures[1][0] = ico.func_94245_a("chromaticraft:cliffstone/stone_base_2");
        this.stoneTextures[1][1] = ico.func_94245_a("chromaticraft:cliffstone/stone_base_3");
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        Material mat;
        super.func_149695_a(world, x, y, z, b);
        if (Variants.getVariant(world.func_72805_g(x, y, z)) == Variants.FARMLAND && (mat = world.func_147439_a(x, y + 1, z).func_149688_o()).func_76220_a()) {
            world.func_147449_b(x, y, z, Blocks.field_150346_d);
        }
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        if (Variants.getVariant(meta) == Variants.FARMLAND) {
            return Blocks.field_150346_d.func_149650_a(0, rand, fortune);
        }
        return super.func_149650_a(meta, rand, fortune);
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        if (Variants.getVariant(world.func_72805_g(x, y, z)) == Variants.FARMLAND) {
            return Item.func_150898_a((Block)Blocks.field_150346_d);
        }
        return super.func_149694_d(world, x, y, z);
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    public void func_149746_a(World world, int x, int y, int z, Entity e, float dist) {
        if (Variants.getVariant(world.func_72805_g(x, y, z)) == Variants.FARMLAND) {
            Blocks.field_150458_ak.func_149746_a(world, x, y, z, e, dist);
        } else {
            super.func_149746_a(world, x, y, z, e, dist);
        }
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        if (Variants.getVariant(world.func_72805_g(x, y, z)) == Variants.FARMLAND) {
            return Blocks.field_150458_ak.canSustainPlant(world, x, y, z, direction, plantable);
        }
        return super.canSustainPlant(world, x, y, z, direction, plantable);
    }

    public boolean isFertile(World world, int x, int y, int z) {
        if (Variants.getVariant(world.func_72805_g(x, y, z)) == Variants.FARMLAND) {
            return true;
        }
        return super.isFertile(world, x, y, z);
    }

    public int getLightValue(IBlockAccess iba, int x, int y, int z) {
        if (Variants.getVariant(iba.func_72805_g(x, y, z)) == Variants.FARMLAND) {
            return 6;
        }
        return 0;
    }

    public int getLightOpacity(IBlockAccess iba, int x, int y, int z) {
        return BlockCliffStone.isTransparent(iba, x, y, z) ? 0 : super.getLightOpacity(iba, x, y, z);
    }

    public boolean isReplaceableOreGen(World world, int x, int y, int z, Block b) {
        return b == this || b == Variants.getVariant(world.func_72805_g(x, y, z)).proxy;
    }

    public static boolean isTransparent(IBlockAccess iba, int x, int y, int z) {
        World w;
        if (iba instanceof World && !ReikaWorldHelper.isChunkPastNoiseGen((World)(w = (World)iba), (int)(x >> 4), (int)(z >> 4))) {
            return false;
        }
        return (iba.func_72805_g(x, y, z) & 8) != 0;
    }

    public boolean blockRockGeneration(World world, int x, int y, int z, Block b, int meta) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorMultiplier(IBlockAccess iba, int x, int y, int z, Block b, int meta) {
        return this.func_149720_d(iba, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess iba, int x, int y, int z, int side, Block b, int meta) {
        return this.func_149673_e(iba, x, y, z, side);
    }

    public int getWeakRedstone(World world, int x, int y, int z, Block b, int meta) {
        return 0;
    }

    public int getStrongRedstone(World world, int x, int y, int z, Block b, int meta) {
        return 0;
    }

    public float getHardness(World world, int x, int y, int z, Block b, int meta) {
        return this.func_149712_f(world, x, y, z);
    }

    public float getBlastResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ, Block b, int meta) {
        return this.getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public int getFlammability(IBlockAccess iba, int x, int y, int z, ForgeDirection side, Block b, int meta) {
        return 0;
    }

    public int getFireSpread(IBlockAccess iba, int x, int y, int z, ForgeDirection side, Block b, int meta) {
        return 0;
    }

    public boolean sustainsFire(IBlockAccess iba, int x, int y, int z, ForgeDirection side, Block b, int meta) {
        return false;
    }

    public boolean isLog(IBlockAccess iba, int x, int y, int z, Block b, int meta) {
        return false;
    }

    public boolean canEntityDestroy(IBlockAccess iba, int x, int y, int z, Entity e, Block b, int meta) {
        return this.canEntityDestroy(iba, x, y, z, e);
    }

    public static enum Variants {
        STONE(Blocks.field_150348_b),
        DIRT(Blocks.field_150346_d),
        GRASS((Block)Blocks.field_150349_c),
        FARMLAND(Blocks.field_150458_ak);

        private final Block proxy;
        private IIcon baseTexture;
        private IIcon[] blend = new IIcon[9];
        public static Variants[] list;

        private Variants(Block b) {
            this.proxy = b;
        }

        @SideOnly(value=Side.CLIENT)
        private void registerIcons(IIconRegister ico) {
            String s = this.name().toLowerCase(Locale.ENGLISH);
            this.baseTexture = ico.func_94245_a("chromaticraft:cliffstone/" + s + "_base");
            for (int i = 0; i < 9; ++i) {
                this.blend[i] = ico.func_94245_a("chromaticraft:cliffstone/" + s + "_blend_down");
            }
        }

        public Block getBlockProxy() {
            return this.proxy;
        }

        public boolean isGround() {
            return this.proxy.func_149688_o() == Material.field_151578_c || this.proxy.func_149688_o() == Material.field_151577_b || this.proxy == Blocks.field_150351_n || this.proxy == Blocks.field_150435_aG || this.proxy == Blocks.field_150354_m;
        }

        public static Variants getVariant(int meta) {
            return list[meta % 4];
        }

        public int getMeta(boolean unused, boolean transparent) {
            return this.ordinal() + (unused ? 4 : 0) + (transparent ? 8 : 0);
        }

        static {
            list = Variants.values();
        }
    }
}

