/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Block.Worldgen;

import Reika.ChromatiCraft.Auxiliary.Potions.PotionVoidGaze;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class BlockEtherealLuma
extends BlockFluidClassic {
    private final IIcon[] icons = new IIcon[16];
    private final IIcon[] dimensionIcons = new IIcon[16];

    public BlockEtherealLuma(Fluid fluid, Material material) {
        super(fluid, material);
        this.setQuantaPerBlock(16);
    }

    protected void flowIntoBlock(World world, int x, int y, int z, int meta) {
        super.flowIntoBlock(world, x, y, z, meta);
    }

    public int getQuantaValue(IBlockAccess world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y - 1, z);
        int val = super.getQuantaValue(world, x, y, z);
        return ReikaBlockHelper.isLiquid((Block)b) ? Math.min(val, 2) : val;
    }

    public void func_149651_a(IIconRegister ico) {
        for (int i = 0; i < 16; ++i) {
            this.icons[i] = ico.func_94245_a("chromaticraft:fluid/aether/aether_still_" + i);
            this.dimensionIcons[i] = ico.func_94245_a("chromaticraft:fluid/aether/aether_still_dim_" + i);
        }
        this.field_149761_L = ico.func_94245_a("chromaticraft:fluid/aether/aether_full");
    }

    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        if (iba.func_72805_g(x, y, z) != 0 || this.getFlowVector(iba, x, y, z).func_72433_c() > 0.0) {
            return ChromatiCraft.luma.getFlowingIcon();
        }
        IIcon[] arr = this.icons;
        int dx = (x % 4 + 4) % 4;
        int dz = (z % 4 + 4) % 4;
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
            arr = this.dimensionIcons;
            int sc = dx;
            dx = dz;
            dz = sc;
        }
        int idx = dz * 4 + dx;
        return arr[idx];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random r) {
        if (r.nextInt(2 * (1 + Minecraft.func_71410_x().field_71474_y.field_74362_aa)) == 0) {
            double px = (double)x + r.nextDouble();
            double py = (double)y + r.nextDouble();
            double pz = (double)z + r.nextDouble();
            int l = 5 + r.nextInt(40);
            float s = 0.75f;
            EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz).setIcon(ChromaIcons.SPARKLEPARTICLE).setBasicBlend().setLife(l).setAlphaFading().setScale(s);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            if (r.nextInt(4) == 0) {
                float g = -((float)ReikaRandomHelper.getRandomBetween((double)0.03125, (double)0.125));
                s = (float)ReikaRandomHelper.getRandomBetween((double)1.0, (double)2.0);
                l = 20 + r.nextInt(30);
                fx = new EntityCCBlurFX(world, px, py, pz).setIcon(ChromaIcons.FADE_GENTLE).setLife(l).setScale(s).setGravity(g).setRapidExpand();
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity e) {
        if (e instanceof EntityLivingBase) {
            EntityLivingBase elb = (EntityLivingBase)e;
            if (elb.func_70086_ai() < 300) {
                elb.func_70050_g(elb.func_70086_ai() + 1);
            }
            if (elb instanceof EntityPlayer && world.func_72805_g(x, y, z) == 0) {
                EntityPlayer ep = (EntityPlayer)elb;
                ProgressStage.LUMA.stepPlayerTo(ep);
                BlockEtherealLuma.addPotions(ep);
            }
        }
        super.func_149670_a(world, x, y, z, e);
    }

    public static void addPotions(EntityPlayer ep) {
        int lvl;
        PotionEffect cur = ep.func_70660_b((Potion)ChromatiCraft.voidGaze);
        if ((cur == null || cur.func_76459_b() < 5) && (lvl = PotionVoidGaze.VoidGazeLevels.getAppliedLevel(ep)) >= 0) {
            ep.func_70690_d(new PotionEffect(ChromatiCraft.voidGaze.field_76415_H, 100, lvl));
            if (cur == null) {
                PotionVoidGaze.VoidGazeLevels.list[lvl].onStart(ep);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149677_c(IBlockAccess iba, int x, int y, int z) {
        return 240;
    }
}

